/*
 * Decompiled with CFR 0.152.
 */
package com.leff.midi.event;

import com.leff.midi.event.ChannelAftertouch;
import com.leff.midi.event.Controller;
import com.leff.midi.event.MidiEvent;
import com.leff.midi.event.NoteAftertouch;
import com.leff.midi.event.NoteOff;
import com.leff.midi.event.NoteOn;
import com.leff.midi.event.PitchBend;
import com.leff.midi.event.ProgramChange;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;

public class ChannelEvent
extends MidiEvent {
    protected int mType;
    protected int mChannel;
    protected int mValue1;
    protected int mValue2;
    private static HashMap<Integer, Integer> mOrderMap;
    public static final int NOTE_OFF = 8;
    public static final int NOTE_ON = 9;
    public static final int NOTE_AFTERTOUCH = 10;
    public static final int CONTROLLER = 11;
    public static final int PROGRAM_CHANGE = 12;
    public static final int CHANNEL_AFTERTOUCH = 13;
    public static final int PITCH_BEND = 14;

    protected ChannelEvent(long tick, int type, int channel, int param1, int param2) {
        this(tick, 0L, type, channel, param1, param2);
    }

    protected ChannelEvent(long tick, long delta, int type, int channel, int param1, int param2) {
        super(tick, delta);
        this.mType = type & 0xF;
        this.mChannel = channel & 0xF;
        this.mValue1 = param1 & 0xFF;
        this.mValue2 = param2 & 0xFF;
    }

    public int getType() {
        return this.mType;
    }

    @Override
    public ChannelEvent clone() {
        return new ChannelEvent(this.mTick, this.mDelta.getValue(), this.mType, this.mChannel, this.mValue1, this.mValue2);
    }

    public void setChannel(int c) {
        if (c < 0) {
            c = 0;
        } else if (c > 15) {
            c = 15;
        }
        this.mChannel = c;
    }

    public int getChannel() {
        return this.mChannel;
    }

    @Override
    protected int getEventSize() {
        switch (this.mType) {
            case 12: 
            case 13: {
                return 2;
            }
        }
        return 3;
    }

    @Override
    public int compareTo(MidiEvent other) {
        if (this.mTick != other.getTick()) {
            return this.mTick < other.getTick() ? -1 : 1;
        }
        if (this.mDelta.getValue() != other.mDelta.getValue()) {
            return this.mDelta.getValue() < other.mDelta.getValue() ? 1 : -1;
        }
        if (!(other instanceof ChannelEvent)) {
            return 1;
        }
        ChannelEvent o = (ChannelEvent)other;
        if (this.mType != o.getType()) {
            int order2;
            int order1;
            if (mOrderMap == null) {
                ChannelEvent.buildOrderMap();
            }
            return (order1 = mOrderMap.get(this.mType).intValue()) < (order2 = mOrderMap.get(o.getType()).intValue()) ? -1 : 1;
        }
        if (this.mValue1 != o.mValue1) {
            return this.mValue1 < o.mValue1 ? -1 : 1;
        }
        if (this.mValue2 != o.mValue2) {
            return this.mValue2 < o.mValue2 ? -1 : 1;
        }
        if (this.mChannel != o.getChannel()) {
            return this.mChannel < o.getChannel() ? -1 : 1;
        }
        return 0;
    }

    @Override
    public boolean requiresStatusByte(MidiEvent prevEvent) {
        return true;
    }

    @Override
    public void writeToFile(OutputStream out, boolean writeType) throws IOException {
        super.writeToFile(out, writeType);
        if (writeType) {
            int typeChannel = (this.mType << 4) + this.mChannel;
            out.write(typeChannel);
        }
        out.write(this.mValue1);
        if (this.mType != 12 && this.mType != 13) {
            out.write(this.mValue2);
        }
    }

    public byte[] toByteArray() throws Exception {
        ByteArrayOutputStream str = new ByteArrayOutputStream();
        this.writeToFile(str, true);
        byte[] b = str.toByteArray();
        str.close();
        return b;
    }

    public static ChannelEvent parseChannelEvent(long tick, long delta, int type, int channel, InputStream in) throws IOException {
        int val1 = in.read();
        int val2 = 0;
        if (type != 12 && type != 13) {
            val2 = in.read();
        }
        switch (type) {
            case 8: {
                return new NoteOff(tick, delta, channel, val1, val2);
            }
            case 9: {
                return new NoteOn(tick, delta, channel, val1, val2);
            }
            case 10: {
                return new NoteAftertouch(tick, delta, channel, val1, val2);
            }
            case 11: {
                return new Controller(tick, delta, channel, val1, val2);
            }
            case 12: {
                return new ProgramChange(tick, delta, channel, val1);
            }
            case 13: {
                return new ChannelAftertouch(tick, delta, channel, val1);
            }
            case 14: {
                return new PitchBend(tick, delta, channel, val1, val2);
            }
        }
        return new ChannelEvent(tick, delta, type, channel, val1, val2);
    }

    private static void buildOrderMap() {
        mOrderMap = new HashMap();
        mOrderMap.put(12, 0);
        mOrderMap.put(11, 1);
        mOrderMap.put(9, 2);
        mOrderMap.put(8, 3);
        mOrderMap.put(10, 4);
        mOrderMap.put(13, 5);
        mOrderMap.put(14, 6);
    }
}

