/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi.util.swing;

import com.aparapi.Kernel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;

public abstract class MultiPassKernelSwingWorker
extends SwingWorker<Void, Void> {
    public static final int DEFAULT_POLL_INTERVAL = 50;
    private Kernel kernel;
    private Timer timer;

    protected MultiPassKernelSwingWorker(Kernel kernel) {
        this.kernel = kernel;
    }

    public void cancelExecution() {
        this.kernel.cancelMultiPass();
    }

    protected abstract void executeKernel(Kernel var1);

    protected abstract void updatePassId(int var1);

    @Override
    protected final Void doInBackground() throws Exception {
        try {
            this.setUpExecution();
            this.executeKernel(this.kernel);
            Void void_ = null;
            return void_;
        }
        finally {
            this.cleanUpExecution();
        }
    }

    private void setUpExecution() {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiPassKernelSwingWorker.this.updatePassId();
            }
        };
        this.timer = new Timer(this.getPollIntervalMillis(), listener);
        this.timer.setCoalesce(false);
        this.timer.start();
    }

    private void cleanUpExecution() {
        this.timer.stop();
        this.timer = null;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MultiPassKernelSwingWorker.this.updatePassId(-1);
            }
        });
    }

    private void updatePassId() {
        int progress = this.kernel.getCurrentPass();
        this.updatePassId(progress);
    }

    protected int getPollIntervalMillis() {
        return 50;
    }
}

