/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi.internal.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class UnsafeWrapper {
    private static Object unsafe;
    private static Method getIntVolatileMethod;
    private static Method arrayBaseOffsetMethod;
    private static Method arrayIndexScaleMethod;
    private static Method getObjectMethod;
    private static Method getIntMethod;
    private static Method getFloatMethod;
    private static Method getByteMethod;
    private static Method getBooleanMethod;
    private static Method getLongMethod;
    private static Method objectFieldOffsetMethod;
    private static Method putBooleanMethod;
    private static Method putIntMethod;
    private static Method putFloatMethod;
    private static Method putDoubleMethod;
    private static Method putByteMethod;
    private static Method putLongMethod;
    private static Method compareAndSwapIntMethod;
    private static int intArrayBase;
    private static int intArrayScale;

    public static int atomicAdd(int[] _arr, int _index, int _delta) {
        if (_index < 0 || _index >= _arr.length) {
            throw new IndexOutOfBoundsException("index " + _index);
        }
        long rawIndex = (long)intArrayBase + (long)_index * (long)intArrayScale;
        while (true) {
            try {
                int next;
                int current;
                do {
                    current = (Integer)getIntVolatileMethod.invoke(unsafe, _arr, rawIndex);
                    next = current + _delta;
                } while (!((Boolean)compareAndSwapIntMethod.invoke(unsafe, _arr, rawIndex, current, next)).booleanValue());
                return current;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static int arrayBaseOffset(Class<?> _arrayClass) {
        int offset = 0;
        try {
            offset = (Integer)arrayBaseOffsetMethod.invoke(unsafe, _arrayClass);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return offset;
    }

    public static int arrayIndexScale(Class<?> _arrayClass) {
        int scale = 0;
        try {
            scale = (Integer)arrayIndexScaleMethod.invoke(unsafe, _arrayClass);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return scale;
    }

    public static Object getObject(Object _object, long _offset) {
        Object object = null;
        try {
            object = getObjectMethod.invoke(unsafe, _object, _offset);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return object;
    }

    public static int getInt(Object _object, long _offset) {
        int value = 0;
        try {
            value = (Integer)getIntMethod.invoke(unsafe, _object, _offset);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return value;
    }

    public static float getFloat(Object _object, long _offset) {
        float value = 0.0f;
        try {
            value = ((Float)getFloatMethod.invoke(unsafe, _object, _offset)).floatValue();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return value;
    }

    public static byte getByte(Object _object, long _offset) {
        byte value = 0;
        try {
            value = (Byte)getByteMethod.invoke(unsafe, _object, _offset);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return value;
    }

    public static boolean getBoolean(Object _object, long _offset) {
        boolean value = false;
        try {
            value = (Boolean)getBooleanMethod.invoke(unsafe, _object, _offset);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return value;
    }

    public static long getLong(Object _object, long _offset) {
        long value = 0L;
        try {
            value = (Long)getLongMethod.invoke(unsafe, _object, _offset);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return value;
    }

    public static void putBoolean(Object _object, long _offset, boolean _boolean) {
        try {
            putBooleanMethod.invoke(unsafe, _object, _offset, _boolean);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void putFloat(Object _object, long _offset, float _float) {
        try {
            putFloatMethod.invoke(unsafe, _object, _offset, Float.valueOf(_float));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void putInt(Object _object, long _offset, int _int) {
        try {
            putIntMethod.invoke(unsafe, _object, _offset, _int);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void putDouble(Object _object, long _offset, double _double) {
        try {
            putDoubleMethod.invoke(unsafe, _object, _offset, _double);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void putByte(Object _object, long _offset, byte _byte) {
        try {
            putByteMethod.invoke(unsafe, _object, _offset, _byte);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void putLong(Object _object, long _offset, long _long) {
        try {
            putLongMethod.invoke(unsafe, _object, _offset, _long);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static long objectFieldOffset(Field _field) {
        long offset = 0L;
        try {
            offset = (Long)objectFieldOffsetMethod.invoke(unsafe, _field);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return offset;
    }

    static {
        try {
            Class<?> uc = Class.forName("sun.misc.Unsafe");
            Field field = uc.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = field.get(uc);
            getIntVolatileMethod = uc.getDeclaredMethod("getIntVolatile", Object.class, Long.TYPE);
            arrayBaseOffsetMethod = uc.getDeclaredMethod("arrayBaseOffset", Class.class);
            arrayIndexScaleMethod = uc.getDeclaredMethod("arrayIndexScale", Class.class);
            getObjectMethod = uc.getDeclaredMethod("getObject", Object.class, Long.TYPE);
            getIntMethod = uc.getDeclaredMethod("getInt", Object.class, Long.TYPE);
            getFloatMethod = uc.getDeclaredMethod("getFloat", Object.class, Long.TYPE);
            getByteMethod = uc.getDeclaredMethod("getByte", Object.class, Long.TYPE);
            getBooleanMethod = uc.getDeclaredMethod("getBoolean", Object.class, Long.TYPE);
            getLongMethod = uc.getDeclaredMethod("getLong", Object.class, Long.TYPE);
            objectFieldOffsetMethod = uc.getDeclaredMethod("objectFieldOffset", Field.class);
            putBooleanMethod = uc.getDeclaredMethod("putBoolean", Object.class, Long.TYPE, Boolean.TYPE);
            putIntMethod = uc.getDeclaredMethod("putInt", Object.class, Long.TYPE, Integer.TYPE);
            putFloatMethod = uc.getDeclaredMethod("putFloat", Object.class, Long.TYPE, Float.TYPE);
            putDoubleMethod = uc.getDeclaredMethod("putDouble", Object.class, Long.TYPE, Double.TYPE);
            putLongMethod = uc.getDeclaredMethod("putLong", Object.class, Long.TYPE, Long.TYPE);
            putByteMethod = uc.getDeclaredMethod("putByte", Object.class, Long.TYPE, Byte.TYPE);
            compareAndSwapIntMethod = uc.getDeclaredMethod("compareAndSwapInt", Object.class, Long.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        intArrayBase = UnsafeWrapper.arrayBaseOffset(int[].class);
        intArrayScale = UnsafeWrapper.arrayIndexScale(int[].class);
    }
}

