/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi.internal.tool;

import com.aparapi.Config;
import com.aparapi.internal.exception.AparapiException;
import com.aparapi.internal.exception.ClassParseException;
import com.aparapi.internal.instruction.Instruction;
import com.aparapi.internal.instruction.InstructionSet;
import com.aparapi.internal.model.ClassModel;
import com.aparapi.internal.model.Entrypoint;
import com.aparapi.internal.model.MethodModel;
import com.aparapi.internal.tool.InstructionHelper;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.image.BufferedImage;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class InstructionViewer
implements Config.InstructionListener {
    public static final int VMARGIN = 2;
    public static final int HMARGIN = 2;
    public static final int HGAPROOT = 100;
    public static final int HGAP = 40;
    public static final int VGAP = 20;
    public static final int ARROWGAP = 5;
    public static final int EDGEGAP = 20;
    public static final int CURVEBOW = 20;
    private final JPanel container;
    private BufferedImage offscreen;
    private Dimension offscreensize;
    private Graphics2D offgraphics;
    private boolean dirty = false;
    private final View view = new View();
    private XY dragStart = null;
    public Options config = new Options();
    private final Color unselectedColor = Color.WHITE;
    private final Color selectedColor = Color.gray.brighter();
    private final Stroke thickStroke = new BasicStroke(2.0f);
    private final Stroke thinStroke = new BasicStroke(1.0f);
    private final Stroke outlineStroke = new BasicStroke(0.5f);
    public Polygon arrowHeadOut = new Polygon();
    Polygon arrowHeadIn;
    private final Map<Instruction, InstructionView> locationToInstructionViewMap;
    ClassModel classModel;
    volatile Instruction first;
    volatile Instruction current;
    public static DoorBell doorbell = new DoorBell();

    public void dirty() {
        this.dirty = true;
        this.container.repaint();
    }

    public synchronized void draw(Graphics _g) {
        Dimension containerSize = this.container.getSize();
        if (this.dirty || this.offscreen == null || containerSize.width != this.offscreensize.width || containerSize.height != this.offscreensize.height) {
            this.offscreensize = new Dimension(containerSize.width, containerSize.height);
            this.offscreen = (BufferedImage)this.container.createImage(this.offscreensize.width, this.offscreensize.height);
            if (this.offgraphics != null) {
                this.offgraphics.dispose();
            }
            this.offgraphics = this.offscreen.createGraphics();
            this.offgraphics.setFont(this.container.getFont());
            this.offgraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.offgraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            this.offgraphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            this.offgraphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            AffineTransform offGraphicsTransform = new AffineTransform();
            this.offgraphics.setTransform(offGraphicsTransform);
            this.offgraphics.setColor(this.container.getBackground());
            this.offgraphics.fillRect(0, 0, this.offscreensize.width, this.offscreensize.height);
            offGraphicsTransform.setToTranslation(this.view.screenx(), this.view.screeny());
            offGraphicsTransform.scale(this.view.scale, this.view.scale);
            this.offgraphics.setTransform(offGraphicsTransform);
            this.view.offGraphicsTransform = offGraphicsTransform;
            this.dirty = false;
        } else {
            this.offgraphics.setColor(this.container.getBackground());
            this.offgraphics.fillRect(0, 0, this.offscreensize.width, this.offscreensize.height);
        }
        this.render(this.offgraphics);
        _g.drawImage(this.offscreen, 0, 0, null);
    }

    public Component getContainer() {
        return this.container;
    }

    public void text(Graphics2D _g, String _text, double _x, double _y) {
        FontMetrics fm = _g.getFontMetrics();
        _g.drawString(_text, (int)_x, (int)(_y - (double)fm.getAscent() + (double)fm.getHeight()));
    }

    public void text(Graphics2D _g, Color _color, String _text, double _x, double _y) {
        Color color = _g.getColor();
        _g.setColor(_color);
        this.text(_g, _text, _x, _y);
        _g.setColor(color);
    }

    public void line(Graphics2D _g, Stroke _stroke, double _x1, double _y1, double _x2, double _y2) {
        Stroke stroke = _g.getStroke();
        _g.setStroke(_stroke);
        this.line(_g, _x1, _y1, _x2, _y2);
        _g.setStroke(stroke);
    }

    public void stroke(Graphics2D _g, Stroke _stroke, Shape _rect) {
        Stroke stroke = _g.getStroke();
        _g.setStroke(_stroke);
        this.draw(_g, _rect);
        _g.setStroke(stroke);
    }

    public void fill(Graphics2D _g, Color _color, Shape _rect) {
        Color color = _g.getColor();
        _g.setColor(_color);
        this.fill(_g, _rect);
        _g.setColor(color);
    }

    public void fillStroke(Graphics2D _g, Color _fillColor, Color _strokeColor, Stroke _stroke, Shape _rect) {
        Color color = _g.getColor();
        _g.setColor(_fillColor);
        this.fill(_g, _rect);
        _g.setColor(_strokeColor);
        this.stroke(_g, _stroke, _rect);
        _g.setColor(color);
    }

    public void line(Graphics2D _g, double _x1, double _y1, double _x2, double _y2) {
        _g.drawLine((int)_x1, (int)_y1, (int)_x2, (int)_y2);
    }

    public void draw(Graphics2D _g, Shape _rectangle) {
        _g.draw(_rectangle);
    }

    public void fill(Graphics2D _g, Shape _rectangle) {
        _g.fill(_rectangle);
    }

    InstructionView getInstructionView(Instruction _instruction) {
        InstructionView instructionView = this.locationToInstructionViewMap.get(_instruction);
        if (instructionView == null) {
            instructionView = new InstructionView(_instruction);
            this.locationToInstructionViewMap.put(_instruction, instructionView);
        }
        return instructionView;
    }

    double foldPlace(Graphics2D _g, InstructionView _instructionView, double _x, double _y, boolean _dim) {
        _instructionView.dim = _dim;
        FontMetrics fm = _g.getFontMetrics();
        _instructionView.label = InstructionHelper.getLabel(_instructionView.instruction, this.config.showPc, this.config.showExpressions, this.config.verboseBytecodeLabels);
        int w = fm.stringWidth(_instructionView.label) + 2;
        int h = fm.getHeight() + 2;
        double y = _y;
        double x = _x + (double)w + (double)(_instructionView.instruction.getRootExpr() == _instructionView.instruction ? 40 : 40);
        if (!this.config.collapseAll && !this.config.showExpressions) {
            for (Instruction e = _instructionView.instruction.getFirstChild(); e != null; e = e.getNextExpr()) {
                y = this.foldPlace(_g, this.getInstructionView(e), x, y, _dim);
                if (e == _instructionView.instruction.getLastChild()) continue;
                y += 20.0;
            }
        }
        double top = (y + _y) / 2.0 - (double)(h / 2);
        _instructionView.shape = new Rectangle((int)_x, (int)top, w, h);
        return Math.max(_y, y);
    }

    void foldRender(Graphics2D _g, InstructionView _instructionView) {
        Instruction e;
        Instruction instruction = _instructionView.instruction;
        if (!this.config.collapseAll && !this.config.showExpressions) {
            for (e = instruction.getFirstChild(); e != null; e = e.getNextExpr()) {
                this.foldRender(_g, this.getInstructionView(e));
            }
        }
        if (_instructionView.dim) {
            _g.setColor(this.unselectedColor);
        } else {
            _g.setColor(this.selectedColor);
        }
        _g.fill(_instructionView.shape);
        _g.setColor(Color.black);
        _g.setStroke(this.outlineStroke);
        _g.draw(_instructionView.shape);
        this.text(_g, _instructionView.label, _instructionView.shape.getBounds().getCenterX() - _instructionView.shape.getBounds().getWidth() / 2.0, _instructionView.shape.getBounds().getCenterY());
        if (!this.config.collapseAll && !this.config.showExpressions) {
            if (this.config.edgeFan) {
                for (e = instruction.getFirstChild(); e != null; e = e.getNextExpr()) {
                    InstructionView iv = this.getInstructionView(e);
                    double x1 = _instructionView.shape.getBounds().getMaxX() + 5.0;
                    double y1 = _instructionView.shape.getBounds().getCenterY();
                    double x2 = iv.shape.getBounds().getMinX() - 5.0;
                    double y2 = iv.shape.getBounds().getCenterY();
                    if (this.config.edgeCurve) {
                        _g.draw(new CubicCurve2D.Double(x1, y1, x1 + 20.0, y1, x2 - 20.0, y2, x2, y2));
                        continue;
                    }
                    double dx = x1 - x2;
                    double dy = y1 - y2;
                    AffineTransform transform = _g.getTransform();
                    double hypot = Math.hypot(dy, dx);
                    double angle = Math.atan2(dy, dx);
                    _g.translate(x2, y2);
                    _g.rotate(angle);
                    this.line(_g, this.thickStroke, 0.0, 0.0, hypot, 0.0);
                    _g.fillPolygon(this.arrowHeadOut);
                    _g.setTransform(transform);
                }
            } else {
                _g.setStroke(this.thickStroke);
                if (instruction.getFirstChild() != null && instruction.getFirstChild() != instruction.getLastChild()) {
                    InstructionView iv0 = this.getInstructionView(instruction.getFirstChild());
                    InstructionView ivn = this.getInstructionView(instruction.getLastChild());
                    double midx = (_instructionView.shape.getBounds().getMaxX() + iv0.shape.getBounds().getMinX()) / 2.0;
                    this.line(_g, midx, iv0.shape.getBounds().getCenterY(), midx, ivn.shape.getBounds().getCenterY());
                    this.line(_g, _instructionView.shape.getBounds().getMaxX() + 5.0, _instructionView.shape.getBounds().getCenterY(), midx, _instructionView.shape.getBounds().getCenterY());
                    for (Instruction e2 = instruction.getFirstChild(); e2 != null; e2 = e2.getNextExpr()) {
                        InstructionView iv = this.getInstructionView(e2);
                        this.line(_g, midx, iv.shape.getBounds().getCenterY(), iv.shape.getBounds().getMinX() - 5.0, iv.shape.getBounds().getCenterY());
                    }
                } else if (instruction.getFirstChild() != null) {
                    InstructionView iv = this.getInstructionView(instruction.getFirstChild());
                    this.line(_g, _instructionView.shape.getBounds().getMaxX() + 5.0, _instructionView.shape.getBounds().getCenterY(), iv.shape.getBounds().getMinX() - 5.0, iv.shape.getBounds().getCenterY());
                }
            }
        }
    }

    double flatPlace(Graphics2D _g, InstructionView _instructionView, double _x, double _y) {
        FontMetrics fm = _g.getFontMetrics();
        Instruction instruction = _instructionView.instruction;
        _instructionView.label = InstructionHelper.getLabel(instruction, this.config.showPc, this.config.showExpressions, this.config.verboseBytecodeLabels);
        int h = fm.getHeight() + 2;
        double top = _y / 2.0 - (double)(h / 2);
        _instructionView.shape = new Rectangle((int)_x, (int)top, fm.stringWidth(_instructionView.label) + 2, h);
        return _y + (double)h;
    }

    void flatRender(Graphics2D _g, InstructionView _instructionView) {
        _g.setColor(this.unselectedColor);
        _g.fill(_instructionView.shape);
        _g.setColor(Color.black);
        this.stroke(_g, this.outlineStroke, _instructionView.shape);
        this.text(_g, _instructionView.label, _instructionView.shape.getBounds().getCenterX() - _instructionView.shape.getBounds().getWidth() / 2.0, _instructionView.shape.getBounds().getCenterY());
    }

    public InstructionViewer(Color _background, String _name) {
        this.arrowHeadOut.addPoint(8, -4);
        this.arrowHeadOut.addPoint(0, 0);
        this.arrowHeadOut.addPoint(8, 4);
        this.arrowHeadOut.addPoint(8, -4);
        this.arrowHeadIn = new Polygon();
        this.arrowHeadIn.addPoint(0, -4);
        this.arrowHeadIn.addPoint(8, 0);
        this.arrowHeadIn.addPoint(0, 4);
        this.arrowHeadIn.addPoint(0, -4);
        this.locationToInstructionViewMap = new HashMap<Instruction, InstructionView>();
        this.classModel = null;
        this.first = null;
        this.current = null;
        try {
            this.classModel = ClassModel.createClassModel(Class.forName(_name));
        }
        catch (ClassParseException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.container = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics g) {
                InstructionViewer.this.draw(g);
            }
        };
        this.container.setBackground(_background);
        MouseAdapter mouseAdaptor = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                InstructionViewer.this.container.requestFocusInWindow();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (InstructionViewer.this.dragStart != null) {
                    InstructionViewer.this.view.x = InstructionViewer.this.view.translatex(e.getX()) - ((InstructionViewer)InstructionViewer.this).dragStart.x;
                    InstructionViewer.this.view.y = InstructionViewer.this.view.translatey(e.getY()) - ((InstructionViewer)InstructionViewer.this).dragStart.y;
                    InstructionViewer.this.dirty();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    InstructionViewer.this.dragStart = new XY(InstructionViewer.this.view.translatex(e.getX()), InstructionViewer.this.view.translatey(e.getY()));
                    InstructionViewer.this.dirty();
                } else if (e.getButton() == 3 && InstructionViewer.this.select(InstructionViewer.this.view.translatex(e.getX()), InstructionViewer.this.view.translatey(e.getY()))) {
                    InstructionViewer.this.dirty();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                InstructionViewer.this.dragStart = null;
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                View view = InstructionViewer.this.view;
                view.scale = view.scale + (double)e.getWheelRotation() / 10.0;
                InstructionViewer.this.dirty();
            }
        };
        KeyAdapter keyAdaptor = new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent arg0) {
                if (arg0.getKeyChar() == '-' || arg0.getKeyChar() == '+') {
                    if (arg0.getKeyChar() == '-') {
                        View view = InstructionViewer.this.view;
                        view.scale = view.scale - 0.1;
                    } else {
                        View view = InstructionViewer.this.view;
                        view.scale = view.scale + 0.1;
                    }
                    InstructionViewer.this.dirty();
                }
            }
        };
        this.container.addMouseMotionListener(mouseAdaptor);
        this.container.addMouseListener(mouseAdaptor);
        this.container.addMouseWheelListener(mouseAdaptor);
        this.container.addKeyListener(keyAdaptor);
        this.container.repaint();
    }

    public InstructionViewer() {
        this.arrowHeadOut.addPoint(8, -4);
        this.arrowHeadOut.addPoint(0, 0);
        this.arrowHeadOut.addPoint(8, 4);
        this.arrowHeadOut.addPoint(8, -4);
        this.arrowHeadIn = new Polygon();
        this.arrowHeadIn.addPoint(0, -4);
        this.arrowHeadIn.addPoint(8, 0);
        this.arrowHeadIn.addPoint(0, 4);
        this.arrowHeadIn.addPoint(0, -4);
        this.locationToInstructionViewMap = new HashMap<Instruction, InstructionView>();
        this.classModel = null;
        this.first = null;
        this.current = null;
        JFrame frame = new JFrame();
        Color background = Color.WHITE;
        JPanel panel = new JPanel(new BorderLayout());
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        ActionListener closeActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                System.exit(1);
            }
        };
        ActionListener nextActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                doorbell.ring();
            }
        };
        JMenuItem closeMenuItem = new JMenuItem("Close");
        closeMenuItem.setMnemonic(67);
        closeMenuItem.addActionListener(closeActionListener);
        fileMenu.add(closeMenuItem);
        menuBar.add(fileMenu);
        menuBar.setEnabled(true);
        frame.setJMenuBar(menuBar);
        JToolBar toolBar = new JToolBar();
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(closeActionListener);
        toolBar.add(closeButton);
        JButton nextButton = new JButton("Next");
        nextButton.addActionListener(nextActionListener);
        toolBar.add(nextButton);
        panel.add("First", toolBar);
        this.container = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics g) {
                InstructionViewer.this.draw(g);
            }
        };
        this.container.setBackground(Color.WHITE);
        MouseAdapter mouseAdaptor = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                InstructionViewer.this.container.requestFocusInWindow();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (InstructionViewer.this.dragStart != null) {
                    InstructionViewer.this.view.x = InstructionViewer.this.view.translatex(e.getX()) - ((InstructionViewer)InstructionViewer.this).dragStart.x;
                    InstructionViewer.this.view.y = InstructionViewer.this.view.translatey(e.getY()) - ((InstructionViewer)InstructionViewer.this).dragStart.y;
                    InstructionViewer.this.dirty();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    InstructionViewer.this.dragStart = new XY(InstructionViewer.this.view.translatex(e.getX()), InstructionViewer.this.view.translatey(e.getY()));
                    InstructionViewer.this.dirty();
                } else if (e.getButton() == 3 && InstructionViewer.this.select(InstructionViewer.this.view.translatex(e.getX()), InstructionViewer.this.view.translatey(e.getY()))) {
                    InstructionViewer.this.dirty();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                InstructionViewer.this.dragStart = null;
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                View view = InstructionViewer.this.view;
                view.scale = view.scale + (double)e.getWheelRotation() / 10.0;
                InstructionViewer.this.dirty();
            }
        };
        KeyAdapter keyAdaptor = new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent arg0) {
                if (arg0.getKeyChar() == '-' || arg0.getKeyChar() == '+') {
                    if (arg0.getKeyChar() == '-') {
                        View view = InstructionViewer.this.view;
                        view.scale = view.scale - 0.1;
                    } else {
                        View view = InstructionViewer.this.view;
                        view.scale = view.scale + 0.1;
                    }
                    InstructionViewer.this.dirty();
                }
            }
        };
        this.container.addMouseMotionListener(mouseAdaptor);
        this.container.addMouseListener(mouseAdaptor);
        this.container.addMouseWheelListener(mouseAdaptor);
        this.container.addKeyListener(keyAdaptor);
        this.container.repaint();
        panel.add("Center", this.container);
        JPanel controls = new JPanel(new BorderLayout());
        Form<Options> form = new Form<Options>(this.config){

            @Override
            public void sync() {
                InstructionViewer.this.dirty();
            }
        };
        controls.add(form.getPanel());
        controls.setPreferredSize(new Dimension(200, 500));
        panel.add("East", controls);
        frame.setBackground(background);
        frame.getContentPane().add(panel);
        frame.setPreferredSize(new Dimension(1024, 1000));
        frame.pack();
        frame.setVisible(true);
    }

    public boolean select(double _x, double _y) {
        for (Instruction l = this.first; l != null; l = l.getNextPC()) {
            InstructionView iv = this.getInstructionView(l);
            if (iv.shape == null || !iv.shape.contains(_x, _y)) continue;
            return true;
        }
        return false;
    }

    public void render(Graphics2D _g) {
        block12: {
            if (this.first == null) break block12;
            if (this.config.fold) {
                Object instruction;
                double y = 100.0;
                Instruction firstRoot = this.first.getRootExpr();
                ArrayList<InstructionView> instructionViews = new ArrayList<InstructionView>();
                Object lastInstruction = null;
                for (instruction = firstRoot; instruction != null; instruction = ((Instruction)instruction).getNextExpr()) {
                    InstructionView instructionView = this.getInstructionView((Instruction)instruction);
                    instructionView.dim = false;
                    y = this.foldPlace(_g, instructionView, 100.0, y, false) + 20.0;
                    instructionViews.add(instructionView);
                    lastInstruction = instruction;
                }
                ((Instruction)lastInstruction).getRootExpr();
                while (lastInstruction instanceof InstructionSet.CompositeInstruction) {
                    lastInstruction = ((Instruction)lastInstruction).getLastChild();
                }
                for (instruction = ((Instruction)lastInstruction).getNextPC(); instruction != null; instruction = ((Instruction)instruction).getNextPC()) {
                    InstructionView instructionView = this.getInstructionView((Instruction)instruction);
                    instructionView.dim = true;
                    y = this.foldPlace(_g, instructionView, 100.0, y, true) + 20.0;
                    instructionViews.add(instructionView);
                }
                _g.setColor(Color.black);
                for (InstructionView instructionView : instructionViews) {
                    if (!instructionView.instruction.isBranch()) continue;
                    Instruction rootFromInstruction = instructionView.instruction;
                    Instruction rootToInstruction = instructionView.instruction.asBranch().getTarget();
                    InstructionView fromIv = this.getInstructionView(rootFromInstruction);
                    InstructionView toIv = this.getInstructionView(rootToInstruction);
                    this.edge(_g, Color.BLACK, fromIv, toIv, null, null);
                }
                InstructionView last = null;
                for (InstructionView instructionView : instructionViews) {
                    this.foldRender(_g, instructionView);
                    if (last != null) {
                        this.line(_g, this.thickStroke, 120.0, last.shape.getBounds().getMaxY(), 120.0, instructionView.shape.getBounds().getMinY());
                    }
                    this.foldRender(_g, instructionView);
                    last = instructionView;
                }
            } else {
                Instruction l;
                double y = 100.0;
                for (l = this.first; l != null; l = l.getNextPC()) {
                    y = this.flatPlace(_g, this.getInstructionView(l), 100.0, y) + 20.0;
                }
                _g.setColor(Color.black);
                for (l = this.first; l != null; l = l.getNextPC()) {
                    if (!l.isBranch()) continue;
                    Instruction rootFromInstruction = l;
                    Instruction rootToInstruction = l.asBranch().getTarget();
                    InstructionView fromIv = this.getInstructionView(rootFromInstruction);
                    InstructionView instructionView = this.getInstructionView(rootToInstruction);
                    this.edge(_g, Color.BLACK, fromIv, instructionView, null, null);
                }
                InstructionView last = null;
                for (Instruction l2 = this.first; l2 != null; l2 = l2.getNextPC()) {
                    InstructionView iv = this.getInstructionView(l2);
                    if (last != null) {
                        this.line(_g, this.thickStroke, 120.0, last.shape.getBounds().getMaxY(), 120.0, iv.shape.getBounds().getMinY());
                    }
                    this.flatRender(_g, iv);
                    last = iv;
                }
            }
        }
    }

    public void edge(Graphics2D _g, Color _color, InstructionView _branch, InstructionView _target, String _endLabel, String _startLabel) {
        int delta = _target.instruction.getThisPC() - _branch.instruction.getThisPC();
        int adjust = 7 + Math.abs(delta);
        double y1 = (int)_branch.shape.getBounds().getMaxY();
        if (_target.shape != null) {
            _g.setStroke(this.thinStroke);
            Color old = _g.getColor();
            _g.setColor(_color);
            double y2 = (int)_target.shape.getBounds().getMinY();
            if (delta > 0) {
                double x1 = (int)_branch.shape.getBounds().getMinX() - 20;
                double x2 = (int)_target.shape.getBounds().getMinX() - 20;
                _g.draw(new CubicCurve2D.Double(x1, y1, x1 - (double)adjust, y1, x1 - (double)adjust, y2, x2, y2));
                AffineTransform transform = _g.getTransform();
                _g.translate(x2 - 5.0, y2);
                _g.fillPolygon(this.arrowHeadIn);
                _g.setTransform(transform);
            } else {
                double x1 = (int)_branch.shape.getBounds().getMaxX() + 20;
                double x2 = (int)_target.shape.getBounds().getMaxX() + 20;
                _g.draw(new CubicCurve2D.Double(x1, y1, Math.max(x1, x2) + (double)adjust, y1, Math.max(x1, x2) + (double)adjust, y2, x2, y2));
                AffineTransform transform = _g.getTransform();
                _g.translate(x2 - 5.0, y2);
                _g.fillPolygon(this.arrowHeadOut);
                _g.setTransform(transform);
            }
            _g.setColor(old);
        }
    }

    @Override
    public void showAndTell(String message, Instruction head, Instruction _instruction) {
        if (this.first == null) {
            this.first = head;
        }
        this.current = _instruction;
        this.dirty();
        doorbell.snooze();
    }

    public static void main(String[] _args) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException, AparapiException {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        Color background = Color.WHITE;
        JPanel panel = new JPanel(new BorderLayout());
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        ActionListener closeActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                System.exit(1);
            }
        };
        ActionListener nextActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                doorbell.ring();
            }
        };
        JMenuItem closeMenuItem = new JMenuItem("Close");
        closeMenuItem.setMnemonic(67);
        closeMenuItem.addActionListener(closeActionListener);
        fileMenu.add(closeMenuItem);
        menuBar.add(fileMenu);
        menuBar.setEnabled(true);
        frame.setJMenuBar(menuBar);
        final InstructionViewer instructionViewer = new InstructionViewer(background, _args[0]);
        Config.instructionListener = instructionViewer;
        JToolBar toolBar = new JToolBar();
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(closeActionListener);
        toolBar.add(closeButton);
        JButton nextButton = new JButton("Next");
        nextButton.addActionListener(nextActionListener);
        toolBar.add(nextButton);
        panel.add("First", toolBar);
        panel.add("Center", instructionViewer.getContainer());
        JPanel controls = new JPanel(new BorderLayout());
        Form<Options> form = new Form<Options>(instructionViewer.config){

            @Override
            public void sync() {
                instructionViewer.dirty();
            }
        };
        controls.add(form.getPanel());
        controls.setPreferredSize(new Dimension(200, 500));
        panel.add("East", controls);
        frame.setBackground(background);
        frame.getContentPane().add(panel);
        frame.setPreferredSize(new Dimension(800, 1000));
        frame.pack();
        frame.setVisible(true);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Entrypoint entrypoint = instructionViewer.classModel.getEntrypoint();
                    MethodModel methodModel = entrypoint.getMethodModel();
                }
                catch (AparapiException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    public static class DoorBell {
        volatile boolean notified = false;

        public synchronized void snooze() {
            while (!this.notified) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.notified = false;
        }

        public synchronized void ring() {
            this.notified = true;
            this.notify();
        }
    }

    public class InstructionView {
        private final Instruction instruction;
        private Shape shape;
        public Instruction branchTarget;
        public Instruction collapsedBranchTarget;
        public String label;
        public boolean dim;

        public InstructionView(Instruction _instruction) {
            this.instruction = _instruction;
        }
    }

    private static class View {
        AffineTransform offGraphicsTransform = new AffineTransform();
        private double scale = 1.0;
        private double x;
        private double y;

        private View() {
        }

        public double translatex(int _screenx) {
            return ((double)_screenx - this.offGraphicsTransform.getTranslateX()) / this.offGraphicsTransform.getScaleX();
        }

        public double screenx() {
            return this.offGraphicsTransform.getScaleX() * this.x + this.offGraphicsTransform.getTranslateX();
        }

        public double translatey(int _screeny) {
            return ((double)_screeny - this.offGraphicsTransform.getTranslateY()) / this.offGraphicsTransform.getScaleY();
        }

        public double screeny() {
            return this.offGraphicsTransform.getScaleY() * this.y + this.offGraphicsTransform.getTranslateY();
        }
    }

    private static class XY {
        double x;
        double y;

        public XY(double _x, double _y) {
            this.x = _x;
            this.y = _y;
        }
    }

    public static class Options
    implements Form.Template {
        @Form.Toggle(label="Fold", on="On", off="Off")
        public boolean fold = true;
        @Form.Check(label="Fan Edges")
        public boolean edgeFan = true;
        @Form.Check(label="Curves")
        public boolean edgeCurve = false;
        @Form.Check(label="PC")
        public boolean showPc = true;
        @Form.Check(label="Bytecode Labels")
        public boolean verboseBytecodeLabels = false;
        @Form.Check(label="Collapse All")
        public boolean collapseAll = false;
        public boolean showExpressions = false;
    }

    public static abstract class Form<T extends Template> {
        public static final int INSET = 5;
        private final T template;
        JPanel panel;
        private final SpringLayout layout = new SpringLayout();

        void setBoolean(Field _field, boolean _value) {
            try {
                _field.setBoolean(this.template, _value);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }

        boolean getBoolean(Field _field) {
            try {
                return _field.getBoolean(this.template);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return false;
        }

        Object get(Field _field) {
            try {
                return _field.get(this.template);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return null;
        }

        public Form(T _template) {
            Check checkAnnotation;
            this.template = _template;
            JPanel last = this.panel = new JPanel(this.layout);
            LinkedHashMap<Field, JLabel> fieldToLabelMap = new LinkedHashMap<Field, JLabel>();
            Field fieldWithWidestLabel = null;
            int fieldWithWidestLabelWidth = 0;
            for (Field field : this.template.getClass().getFields()) {
                String labelString = null;
                checkAnnotation = field.getAnnotation(Check.class);
                if (checkAnnotation != null) {
                    labelString = checkAnnotation.label();
                } else {
                    Toggle toggleAnnotation = field.getAnnotation(Toggle.class);
                    if (toggleAnnotation != null) {
                        labelString = toggleAnnotation.label();
                    }
                }
                if (labelString == null) continue;
                JLabel label = new JLabel(labelString);
                this.panel.add(label);
                fieldToLabelMap.put(field, label);
                if (labelString.length() <= fieldWithWidestLabelWidth) continue;
                fieldWithWidestLabel = field;
                fieldWithWidestLabelWidth = labelString.length();
            }
            for (Field field : fieldToLabelMap.keySet()) {
                this.layout.putConstraint("North", (Component)fieldToLabelMap.get(field), 5, last == this.panel ? "North" : "South", (Component)last);
                this.layout.putConstraint("West", (Component)fieldToLabelMap.get(field), 5, "West", (Component)this.panel);
                JToggleButton newComponent = null;
                if (field.getType().isAssignableFrom(Boolean.TYPE)) {
                    final Field booleanField = field;
                    Toggle toggleAnnotation = field.getAnnotation(Toggle.class);
                    if (toggleAnnotation != null) {
                        final String toggleButtonOnLabel = toggleAnnotation.on();
                        final String toggleButtonOffLabel = toggleAnnotation.off();
                        String toggleButtonLabel = this.getBoolean(field) ? toggleButtonOnLabel : toggleButtonOffLabel;
                        JToggleButton toggleButton = new JToggleButton(toggleButtonLabel, this.getBoolean(field));
                        toggleButton.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent _actionEvent) {
                                JToggleButton toggleButton = (JToggleButton)_actionEvent.getSource();
                                if (toggleButton.getText().equals(toggleButtonOnLabel)) {
                                    toggleButton.setText(toggleButtonOffLabel);
                                    Form.this.setBoolean(booleanField, false);
                                } else {
                                    toggleButton.setText(toggleButtonOnLabel);
                                    Form.this.setBoolean(booleanField, true);
                                }
                                Form.this.sync();
                            }
                        });
                        newComponent = toggleButton;
                    }
                    if ((checkAnnotation = field.getAnnotation(Check.class)) != null) {
                        JCheckBox checkBox = new JCheckBox();
                        checkBox.setSelected(this.getBoolean(field));
                        checkBox.addChangeListener(new ChangeListener(){

                            @Override
                            public void stateChanged(ChangeEvent _changeEvent) {
                                JCheckBox checkBox = (JCheckBox)_changeEvent.getSource();
                                Form.this.setBoolean(booleanField, checkBox.isSelected());
                                Form.this.sync();
                            }
                        });
                        newComponent = checkBox;
                    }
                }
                if (newComponent != null) {
                    this.panel.add(newComponent);
                    this.layout.putConstraint("North", newComponent, 5, last == this.panel ? "North" : "South", (Component)last);
                    this.layout.putConstraint("West", newComponent, 5, "East", (Component)fieldToLabelMap.get(fieldWithWidestLabel));
                    this.layout.putConstraint("East", (Component)newComponent, 5, "East", (Component)this.panel);
                }
                last = newComponent;
            }
            this.layout.layoutContainer(this.panel);
        }

        public abstract void sync();

        public Component getPanel() {
            return this.panel;
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface Check {
            public String label();
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface Toggle {
            public String label();

            public String on();

            public String off();
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface List {
            public Class<?> value();
        }

        public static interface Template {
        }

        public static @interface OneOf {
            public String label();

            public String[] options();
        }
    }
}

