/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi.internal.opencl;

import com.aparapi.device.OpenCLDevice;
import com.aparapi.internal.jni.OpenCLJNI;
import com.aparapi.internal.opencl.OpenCLLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OpenCLPlatform
extends OpenCLJNI {
    private long platformId;
    private final String version;
    private final String vendor;
    private final String name;
    private final List<OpenCLDevice> devices = new ArrayList<OpenCLDevice>();
    private static List<OpenCLPlatform> platforms;

    public OpenCLPlatform() {
        this.version = "";
        this.vendor = "";
        this.name = "";
    }

    public OpenCLPlatform(long _platformId, String _version, String _vendor, String _name) {
        this.platformId = _platformId;
        this.version = _version;
        this.vendor = _vendor;
        this.name = _name;
    }

    public void addOpenCLDevice(OpenCLDevice device) {
        this.devices.add(device);
    }

    public List<OpenCLDevice> getOpenCLDevices() {
        return this.devices;
    }

    public List<OpenCLPlatform> getOpenCLPlatforms() {
        if (platforms == null) {
            if (OpenCLLoader.isOpenCLAvailable()) {
                platforms = this.getPlatforms();
            } else {
                return Collections.EMPTY_LIST;
            }
        }
        return platforms;
    }

    public static List<OpenCLPlatform> getUncachedOpenCLPlatforms() {
        platforms = null;
        platforms = new OpenCLPlatform().getOpenCLPlatforms();
        return platforms;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PlatformId ");
        sb.append("\nName:");
        sb.append(this.vendor);
        sb.append("\nVersion:");
        sb.append(this.version);
        return sb.toString();
    }
}

