/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi.internal.opencl;

import com.aparapi.Config;
import com.aparapi.internal.jni.OpenCLJNI;
import com.aparapi.natives.NativeLoader;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OpenCLLoader
extends OpenCLJNI {
    private static final Logger logger = Logger.getLogger(Config.getLoggerName());
    private static boolean openCLAvailable = false;
    private static final OpenCLLoader instance = new OpenCLLoader();

    protected static OpenCLLoader getInstance() {
        return instance;
    }

    public static boolean isOpenCLAvailable() {
        return openCLAvailable;
    }

    static {
        if (Config.useAgent) {
            logger.fine("Using agent!");
            openCLAvailable = true;
        } else {
            try {
                NativeLoader.load();
                logger.info("Aparapi JNI loaded successfully.");
                openCLAvailable = true;
            }
            catch (IOException | UnsatisfiedLinkError e) {
                logger.log(Level.SEVERE, "Check your environment. Failed to load codegen native library  or possibly failed to locate opencl native library (opencl.dll/opencl.so). Ensure that OpenCL is in your PATH (windows) or in LD_LIBRARY_PATH (linux).");
            }
        }
    }
}

