/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi.internal.opencl;

import com.aparapi.internal.opencl.OpenCLKernel;
import com.aparapi.internal.opencl.OpenCLMem;

public class OpenCLArgDescriptor {
    public static final int ARG_BYTE_BIT = 1;
    public static final int ARG_SHORT_BIT = 2;
    public static final int ARG_INT_BIT = 4;
    public static final int ARG_FLOAT_BIT = 8;
    public static final int ARG_LONG_BIT = 16;
    public static final int ARG_DOUBLE_BIT = 32;
    public static final int ARG_ARRAY_BIT = 64;
    public static final int ARG_PRIMITIVE_BIT = 128;
    public static final int ARG_GLOBAL_BIT = 256;
    public static final int ARG_LOCAL_BIT = 512;
    public static final int ARG_CONST_BIT = 1024;
    public static final int ARG_READONLY_BIT = 2048;
    public static final int ARG_WRITEONLY_BIT = 4096;
    public static final int ARG_READWRITE_BIT = 8192;
    public static final int ARG_ISARG_BIT = 16384;
    public OpenCLMem memVal;
    private final String name;
    public long bits;
    public OpenCLKernel kernel;

    public OpenCLArgDescriptor(String _name, long _bits) {
        this.name = _name;
        this.bits = _bits;
    }

    public String toString() {
        StringBuilder argBuilder = new StringBuilder();
        if ((this.bits & 0x100L) == 256L) {
            argBuilder.append("__global ");
        } else if ((this.bits & 0x200L) == 512L) {
            argBuilder.append("__local ");
        } else if ((this.bits & 0x400L) == 1024L) {
            argBuilder.append("__constant ");
        } else if ((this.bits & 0x4000L) != 16384L) {
            argBuilder.append("WHATISTHIS?");
        }
        if ((this.bits & 8L) == 8L) {
            argBuilder.append("float ");
        } else if ((this.bits & 4L) == 4L) {
            argBuilder.append("int ");
        } else if ((this.bits & 2L) == 2L) {
            argBuilder.append("short ");
        } else if ((this.bits & 0x20L) == 32L) {
            argBuilder.append("double ");
        } else if ((this.bits & 0x10L) == 16L) {
            argBuilder.append("long ");
        }
        if ((this.bits & 0x40L) == 64L) {
            argBuilder.append("*");
        }
        argBuilder.append(this.name);
        if ((this.bits & 0x800L) == 2048L) {
            argBuilder.append(" /* readonly */");
        } else if ((this.bits & 0x1000L) == 4096L) {
            argBuilder.append(" /* writeonly */");
        } else if ((this.bits & 0x2000L) == 8192L) {
            argBuilder.append(" /* readwrite */");
        }
        return argBuilder.toString();
    }
}

