/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi.internal.model;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class ValueCache<K, V, T extends Throwable> {
    private final ConcurrentMap<K, SoftReference<V>> map = new ConcurrentHashMap<K, SoftReference<V>>();
    private final ThrowingValueComputer<K, V, T> computer;

    public static <K, V, T extends Throwable> ValueCache<K, V, T> on(ThrowingValueComputer<K, V, T> computer) {
        return new ValueCache<K, V, T>(computer);
    }

    private ValueCache(ThrowingValueComputer<K, V, T> computer) {
        this.computer = computer;
    }

    public V computeIfAbsent(K key) throws T {
        Object value;
        Reference reference = (Reference)this.map.get(key);
        Object t = value = reference == null ? null : (Object)reference.get();
        if (value == null) {
            value = this.computer.compute(key);
            this.map.put(key, new SoftReference<Object>(value));
        }
        return (V)value;
    }

    public void invalidate() {
        this.map.clear();
    }

    public static interface ValueComputer<K, V>
    extends ThrowingValueComputer<K, V, RuntimeException> {
    }

    public static interface ThrowingValueComputer<K, V, T extends Throwable> {
        public V compute(K var1) throws T;
    }
}

