/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi.internal.model;

import com.aparapi.internal.model.Optional;
import com.aparapi.internal.model.Supplier;
import java.util.concurrent.atomic.AtomicReference;

public interface Memoizer<T>
extends Supplier<T> {

    public static final class Impl<T>
    implements Memoizer<T> {
        private final Supplier<T> supplier;
        private final AtomicReference<Optional<T>> valueRef = new AtomicReference(Optional.None.none());

        Impl(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        @Override
        public T get() {
            Optional<T> value = this.valueRef.get();
            while (!value.isPresent()) {
                Optional<T> newValue = Optional.Some.of(this.supplier.get());
                if (this.valueRef.compareAndSet(value, newValue)) {
                    value = newValue;
                    break;
                }
                value = this.valueRef.get();
            }
            return value.get();
        }

        public static <T> Memoizer<T> of(Supplier<T> supplier) {
            return new Impl<T>(supplier);
        }
    }
}

