/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi.internal.model;

import com.aparapi.Config;
import com.aparapi.Kernel;
import com.aparapi.internal.exception.AparapiException;
import com.aparapi.internal.exception.ClassParseException;
import com.aparapi.internal.instruction.Instruction;
import com.aparapi.internal.instruction.InstructionSet;
import com.aparapi.internal.model.ClassModel;
import com.aparapi.internal.model.MethodModel;
import com.aparapi.internal.util.UnsafeWrapper;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Entrypoint
implements Cloneable {
    private static Logger logger = Logger.getLogger(Config.getLoggerName());
    private final List<ClassModel.ClassModelField> referencedClassModelFields = new ArrayList<ClassModel.ClassModelField>();
    private final List<Field> referencedFields = new ArrayList<Field>();
    private ClassModel classModel;
    private Object kernelInstance = null;
    private final Set<String> referencedFieldNames = new LinkedHashSet<String>();
    private final Set<String> arrayFieldAssignments = new LinkedHashSet<String>();
    private final Set<String> arrayFieldAccesses = new LinkedHashSet<String>();
    private final HashMap<String, ClassModel> objectArrayFieldsClasses = new HashMap();
    private final HashMap<String, ClassModel> allFieldsClasses = new HashMap();
    private final Set<String> arrayFieldArrayLengthUsed = new LinkedHashSet<String>();
    private final List<MethodModel> calledMethods = new ArrayList<MethodModel>();
    private final MethodModel methodModel;
    private boolean usesDoubles;
    private boolean usesByteWrites;
    private boolean usesAtomic32;
    private boolean usesAtomic64;

    public boolean requiresDoublePragma() {
        return this.usesDoubles;
    }

    public boolean requiresByteAddressableStorePragma() {
        return this.usesByteWrites;
    }

    public void setRequiresAtomics32Pragma(boolean newVal) {
        this.usesAtomic32 = newVal;
    }

    public void setRequiresAtomics64Pragma(boolean newVal) {
        this.usesAtomic64 = newVal;
    }

    public boolean requiresAtomic32Pragma() {
        return this.usesAtomic32;
    }

    public boolean requiresAtomic64Pragma() {
        return this.usesAtomic64;
    }

    public Object getKernelInstance() {
        return this.kernelInstance;
    }

    public void setKernelInstance(Object _k) {
        this.kernelInstance = _k;
    }

    public Map<String, ClassModel> getObjectArrayFieldsClasses() {
        return this.objectArrayFieldsClasses;
    }

    public static Field getFieldFromClassHierarchy(Class<?> _clazz, String _name) throws AparapiException {
        Field field = null;
        assert (_name != null) : "_name should not be null";
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("looking for " + _name + " in " + _clazz.getName());
        }
        try {
            field = _clazz.getDeclaredField(_name);
            Class<?> type = field.getType();
            if (type.isPrimitive() || type.isArray()) {
                return field;
            }
            if (field.getAnnotation(Kernel.NoCL.class) != null) {
                return null;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("field type is " + type.getName());
            }
            throw new ClassParseException(ClassParseException.TYPE.OBJECTFIELDREFERENCE);
        }
        catch (NoSuchFieldException type) {
            Class<?> mySuper = _clazz.getSuperclass();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("looking for " + _name + " in " + mySuper.getName());
            }
            while (!mySuper.getName().equals(Kernel.class.getName())) {
                try {
                    field = mySuper.getDeclaredField(_name);
                    int modifiers = field.getModifiers();
                    if (!Modifier.isStatic(modifiers) && !Modifier.isPrivate(modifiers)) {
                        Class<?> type2 = field.getType();
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("field type is " + type2.getName());
                        }
                        if (type2.isPrimitive() || type2.isArray()) {
                            return field;
                        }
                        throw new ClassParseException(ClassParseException.TYPE.OBJECTFIELDREFERENCE);
                    }
                    return null;
                }
                catch (NoSuchFieldException nsfe) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("no " + _name + " in " + mySuper.getName());
                    }
                    mySuper = mySuper.getSuperclass();
                    assert (mySuper != null) : "mySuper is null!";
                }
            }
            return null;
        }
    }

    public ClassModel getOrUpdateAllClassAccesses(String className) throws AparapiException {
        ClassModel memberClassModel = this.allFieldsClasses.get(className);
        if (memberClassModel == null) {
            try {
                Class<?> memberClass = Class.forName(className);
                memberClassModel = ClassModel.createClassModel(memberClass);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("adding class " + className);
                }
                this.allFieldsClasses.put(className, memberClassModel);
                for (ClassModel superModel = memberClassModel.getSuperClazz(); superModel != null; superModel = superModel.getSuperClazz()) {
                    ClassModel oldSuper = this.allFieldsClasses.get(superModel.getClassWeAreModelling().getName());
                    if (oldSuper != null) {
                        if (oldSuper == superModel) continue;
                        memberClassModel.replaceSuperClazz(oldSuper);
                        if (!logger.isLoggable(Level.FINEST)) continue;
                        logger.finest("replaced super " + oldSuper.getClassWeAreModelling().getName() + " for " + className);
                        continue;
                    }
                    this.allFieldsClasses.put(superModel.getClassWeAreModelling().getName(), superModel);
                    if (!logger.isLoggable(Level.FINEST)) continue;
                    logger.finest("add new super " + superModel.getClassWeAreModelling().getName() + " for " + className);
                }
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("Cannot find: " + className);
                }
                throw new AparapiException(e);
            }
        }
        return memberClassModel;
    }

    public ClassModel.ClassModelMethod resolveAccessorCandidate(InstructionSet.MethodCall _methodCall, ClassModel.ConstantPool.MethodEntry _methodEntry) throws AparapiException {
        Instruction callInstance;
        String methodsActualClassName = _methodEntry.getClassEntry().getNameUTF8Entry().getUTF8().replace('/', '.');
        if (_methodCall instanceof InstructionSet.VirtualMethodCall && (callInstance = ((InstructionSet.VirtualMethodCall)_methodCall).getInstanceReference()) instanceof InstructionSet.AccessArrayElement) {
            InstructionSet.AccessArrayElement arrayAccess = (InstructionSet.AccessArrayElement)callInstance;
            Instruction refAccess = arrayAccess.getArrayRef();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Looking for class in accessor call: " + methodsActualClassName);
            }
            ClassModel memberClassModel = this.getOrUpdateAllClassAccesses(methodsActualClassName);
            return memberClassModel.getMethod(_methodEntry, false);
        }
        return null;
    }

    public void updateObjectMemberFieldAccesses(String className, ClassModel.ConstantPool.FieldEntry field) throws AparapiException {
        String accessedFieldName = field.getNameAndTypeEntry().getNameUTF8Entry().getUTF8();
        if (field.getNameAndTypeEntry().getDescriptorUTF8Entry().getUTF8().startsWith("L") || field.getNameAndTypeEntry().getDescriptorUTF8Entry().getUTF8().startsWith("[L")) {
            throw new ClassParseException(ClassParseException.TYPE.OBJECTARRAYFIELDREFERENCE);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Updating access: " + className + " field:" + accessedFieldName);
        }
        ClassModel memberClassModel = this.getOrUpdateAllClassAccesses(className);
        Class<?> memberClass = memberClassModel.getClassWeAreModelling();
        ClassModel superCandidate = null;
        boolean add = true;
        for (ClassModel classModel : this.allFieldsClasses.values()) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(" super: " + classModel.getClassWeAreModelling().getName() + " for " + className);
            }
            if (classModel.isSuperClass(memberClass)) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("selected super: " + classModel.getClassWeAreModelling().getName() + " for " + className);
                }
                superCandidate = classModel;
                break;
            }
            if (!logger.isLoggable(Level.FINEST)) continue;
            logger.finest(" no super match for " + memberClass.getName());
        }
        if (superCandidate != null) {
            ArrayList<ClassModel.ConstantPool.FieldEntry> structMemberSet = superCandidate.getStructMembers();
            for (ClassModel.ConstantPool.FieldEntry f : structMemberSet) {
                Field classField;
                Field superField;
                if (!f.getNameAndTypeEntry().getNameUTF8Entry().getUTF8().equals(accessedFieldName) || !f.getNameAndTypeEntry().getDescriptorUTF8Entry().getUTF8().equals(field.getNameAndTypeEntry().getDescriptorUTF8Entry().getUTF8())) continue;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Found match: " + accessedFieldName + " class: " + field.getClassEntry().getNameUTF8Entry().getUTF8() + " to class: " + f.getClassEntry().getNameUTF8Entry().getUTF8());
                }
                if (!f.getClassEntry().getNameUTF8Entry().getUTF8().equals(field.getClassEntry().getNameUTF8Entry().getUTF8()) && !(superField = Entrypoint.getFieldFromClassHierarchy(superCandidate.getClassWeAreModelling(), f.getNameAndTypeEntry().getNameUTF8Entry().getUTF8())).equals(classField = Entrypoint.getFieldFromClassHierarchy(memberClass, f.getNameAndTypeEntry().getNameUTF8Entry().getUTF8()))) {
                    throw new ClassParseException(ClassParseException.TYPE.OVERRIDENFIELD);
                }
                add = false;
                break;
            }
        }
        if (add) {
            boolean found = false;
            ArrayList<ClassModel.ConstantPool.FieldEntry> arrayList = memberClassModel.getStructMembers();
            for (ClassModel.ConstantPool.FieldEntry f : arrayList) {
                if (!f.getNameAndTypeEntry().getNameUTF8Entry().getUTF8().equals(accessedFieldName) || !f.getNameAndTypeEntry().getDescriptorUTF8Entry().getUTF8().equals(field.getNameAndTypeEntry().getDescriptorUTF8Entry().getUTF8())) continue;
                found = true;
            }
            if (!found) {
                arrayList.add(field);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Adding assigned field " + field.getNameAndTypeEntry().getNameUTF8Entry().getUTF8() + " type: " + field.getNameAndTypeEntry().getDescriptorUTF8Entry().getUTF8() + " to " + memberClassModel.getClassWeAreModelling().getName());
                }
            }
        }
    }

    ClassModel.ClassModelMethod resolveCalledMethod(InstructionSet.MethodCall methodCall, ClassModel classModel) throws AparapiException {
        ClassModel.ClassModelMethod m;
        boolean isMapped;
        ClassModel.ConstantPool.MethodEntry methodEntry = methodCall.getConstantPoolMethodEntry();
        int thisClassIndex = classModel.getThisClassConstantPoolIndex();
        boolean bl = isMapped = thisClassIndex != methodEntry.getClassIndex() && Kernel.isMappedMethod(methodEntry);
        if (logger.isLoggable(Level.FINE)) {
            if (methodCall instanceof InstructionSet.I_INVOKESPECIAL) {
                logger.fine("Method call to super: " + methodEntry);
            } else if (thisClassIndex != methodEntry.getClassIndex()) {
                logger.fine("Method call to ??: " + methodEntry + ", isMappedMethod=" + isMapped);
            } else {
                logger.fine("Method call in kernel class: " + methodEntry);
            }
        }
        if ((m = classModel.getMethod(methodEntry, methodCall instanceof InstructionSet.I_INVOKESPECIAL)) == null && !isMapped) {
            m = this.resolveAccessorCandidate(methodCall, methodEntry);
        }
        if (m == null && !isMapped) {
            for (ClassModel c : this.allFieldsClasses.values()) {
                if (!c.getClassWeAreModelling().getName().equals(methodEntry.getClassEntry().getNameUTF8Entry().getUTF8().replace('/', '.'))) continue;
                m = c.getMethod(methodEntry, methodCall instanceof InstructionSet.I_INVOKESPECIAL);
                assert (m != null);
                break;
            }
        }
        if (m == null && !isMapped && methodCall instanceof InstructionSet.I_INVOKESTATIC) {
            String otherClassName = methodEntry.getClassEntry().getNameUTF8Entry().getUTF8().replace('/', '.');
            ClassModel otherClassModel = this.getOrUpdateAllClassAccesses(otherClassName);
            m = otherClassModel.getMethod(methodEntry, false);
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.fine("Selected method for: " + methodEntry + " is " + m);
        }
        return m;
    }

    public Entrypoint(ClassModel _classModel, MethodModel _methodModel, Object _k) throws AparapiException {
        this.classModel = _classModel;
        this.methodModel = _methodModel;
        this.kernelInstance = _k;
        LinkedHashMap<Object, MethodModel> methodMap = new LinkedHashMap<Object, MethodModel>();
        boolean discovered = true;
        if (this.methodModel.requiresDoublePragma()) {
            this.usesDoubles = true;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Enabling doubles on " + this.methodModel.getName());
            }
        }
        if (this.methodModel.requiresByteAddressableStorePragma()) {
            this.usesByteWrites = true;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Enabling byte addressable on " + this.methodModel.getName());
            }
        }
        for (InstructionSet.MethodCall methodCall : this.methodModel.getMethodCalls()) {
            ClassModel.ClassModelMethod m = this.resolveCalledMethod(methodCall, this.classModel);
            if (m == null || methodMap.keySet().contains(m) || this.noCL(m)) continue;
            MethodModel methodModel = new MethodModel(m, this);
            methodMap.put(m, methodModel);
            this.methodModel.getCalledMethods().add(methodModel);
            discovered = true;
        }
        while (discovered) {
            discovered = false;
            for (MethodModel mm : new ArrayList(methodMap.values())) {
                for (InstructionSet.MethodCall methodCall : mm.getMethodCalls()) {
                    ClassModel.ClassModelMethod m = this.resolveCalledMethod(methodCall, this.classModel);
                    if (m == null || this.noCL(m)) continue;
                    MethodModel target = null;
                    if (methodMap.keySet().contains(m)) {
                        target = (MethodModel)methodMap.remove(m);
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.fine("repositioning : " + m.getClassModel().getClassWeAreModelling().getName() + " " + m.getName() + " " + m.getDescriptor());
                        }
                    } else {
                        target = new MethodModel(m, this);
                        discovered = true;
                    }
                    methodMap.put(m, target);
                    mm.getCalledMethods().add(target);
                }
            }
        }
        this.methodModel.checkForRecursion(new HashSet<MethodModel>());
        this.calledMethods.addAll(methodMap.values());
        Collections.reverse(this.calledMethods);
        ArrayList<MethodModel> methods = new ArrayList<MethodModel>(this.calledMethods);
        methods.add(this.methodModel);
        HashSet<String> fieldAssignments = new HashSet<String>();
        HashSet<String> fieldAccesses = new HashSet<String>();
        for (MethodModel methodModel : methods) {
            if (methodModel.requiresDoublePragma()) {
                this.usesDoubles = true;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Enabling doubles on " + methodModel.getName());
                }
            }
            if (methodModel.requiresByteAddressableStorePragma()) {
                this.usesByteWrites = true;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Enabling byte addressable on " + methodModel.getName());
                }
            }
            for (Instruction instruction = methodModel.getPCHead(); instruction != null; instruction = instruction.getNextPC()) {
                ClassModel.ConstantPool.MethodReferenceEntry.Arg[] methodArgs;
                ClassModel.ConstantPool.FieldEntry field;
                Object access;
                InstructionSet.I_GETFIELD getField;
                Instruction arrayRef;
                Object assignment;
                if (instruction instanceof InstructionSet.AssignToArrayElement) {
                    assignment = (InstructionSet.AssignToArrayElement)instruction;
                    arrayRef = ((InstructionSet.ArrayAccess)assignment).getArrayRef();
                    if (!(arrayRef instanceof InstructionSet.I_GETFIELD)) continue;
                    getField = (InstructionSet.I_GETFIELD)arrayRef;
                    ClassModel.ConstantPool.FieldEntry field2 = getField.getConstantPoolFieldEntry();
                    String assignedArrayFieldName = field2.getNameAndTypeEntry().getNameUTF8Entry().getUTF8();
                    this.arrayFieldAssignments.add(assignedArrayFieldName);
                    this.referencedFieldNames.add(assignedArrayFieldName);
                    continue;
                }
                if (instruction instanceof InstructionSet.AccessArrayElement) {
                    access = (InstructionSet.AccessArrayElement)instruction;
                    arrayRef = ((InstructionSet.ArrayAccess)access).getArrayRef();
                    if (!(arrayRef instanceof InstructionSet.I_GETFIELD)) continue;
                    getField = (InstructionSet.I_GETFIELD)arrayRef;
                    ClassModel.ConstantPool.FieldEntry field2 = getField.getConstantPoolFieldEntry();
                    String accessedArrayFieldName = field2.getNameAndTypeEntry().getNameUTF8Entry().getUTF8();
                    this.arrayFieldAccesses.add(accessedArrayFieldName);
                    this.referencedFieldNames.add(accessedArrayFieldName);
                    continue;
                }
                if (instruction instanceof InstructionSet.I_ARRAYLENGTH) {
                    Instruction child = instruction.getFirstChild();
                    while (child instanceof InstructionSet.I_AALOAD) {
                        child = child.getFirstChild();
                    }
                    if (!(child instanceof InstructionSet.AccessField)) {
                        throw new ClassParseException(ClassParseException.TYPE.LOCALARRAYLENGTHACCESS);
                    }
                    InstructionSet.AccessField childField = (InstructionSet.AccessField)((Object)child);
                    String arrayName = childField.getConstantPoolFieldEntry().getNameAndTypeEntry().getNameUTF8Entry().getUTF8();
                    this.arrayFieldArrayLengthUsed.add(arrayName);
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.fine("Noted arraylength in " + methodModel.getName() + " on " + arrayName);
                    continue;
                }
                if (instruction instanceof InstructionSet.AccessField) {
                    String className;
                    access = (InstructionSet.AccessField)((Object)instruction);
                    field = access.getConstantPoolFieldEntry();
                    String accessedFieldName = field.getNameAndTypeEntry().getNameUTF8Entry().getUTF8();
                    fieldAccesses.add(accessedFieldName);
                    this.referencedFieldNames.add(accessedFieldName);
                    String signature = field.getNameAndTypeEntry().getDescriptorUTF8Entry().getUTF8();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("AccessField field type= " + signature + " in " + methodModel.getName());
                    }
                    if (signature.startsWith("[L")) {
                        className = signature.substring(2, signature.length() - 1).replace('/', '.');
                        ClassModel arrayFieldModel = this.getOrUpdateAllClassAccesses(className);
                        if (arrayFieldModel == null) continue;
                        Class<?> memberClass = arrayFieldModel.getClassWeAreModelling();
                        int modifiers = memberClass.getModifiers();
                        if (!Modifier.isFinal(modifiers)) {
                            throw new ClassParseException(ClassParseException.TYPE.ACCESSEDOBJECTNONFINAL);
                        }
                        ClassModel refModel = this.objectArrayFieldsClasses.get(className);
                        if (refModel != null) continue;
                        Iterator<ClassModel> iterator = this.objectArrayFieldsClasses.values().iterator();
                        while (iterator.hasNext()) {
                            ClassModel memberObjClass;
                            for (ClassModel superModel = memberObjClass = iterator.next(); superModel != null; superModel = superModel.getSuperClazz()) {
                                if (!superModel.isSuperClass(memberClass)) continue;
                                throw new ClassParseException(ClassParseException.TYPE.ACCESSEDOBJECTFIELDNAMECONFLICT);
                            }
                        }
                        this.objectArrayFieldsClasses.put(className, arrayFieldModel);
                        if (!logger.isLoggable(Level.FINE)) continue;
                        logger.fine("adding class to objectArrayFields: " + className);
                        continue;
                    }
                    className = field.getClassEntry().getNameUTF8Entry().getUTF8().replace('/', '.');
                    if (className.equals(this.getClassModel().getClassWeAreModelling().getName()) || Entrypoint.getFieldFromClassHierarchy(this.getClassModel().getClassWeAreModelling(), accessedFieldName) != null) continue;
                    this.updateObjectMemberFieldAccesses(className, field);
                    continue;
                }
                if (instruction instanceof InstructionSet.AssignToField) {
                    assignment = (InstructionSet.AssignToField)((Object)instruction);
                    field = assignment.getConstantPoolFieldEntry();
                    String assignedFieldName = field.getNameAndTypeEntry().getNameUTF8Entry().getUTF8();
                    fieldAssignments.add(assignedFieldName);
                    this.referencedFieldNames.add(assignedFieldName);
                    String className = field.getClassEntry().getNameUTF8Entry().getUTF8().replace('/', '.');
                    if (!className.equals(this.getClassModel().getClassWeAreModelling().getName()) && Entrypoint.getFieldFromClassHierarchy(this.getClassModel().getClassWeAreModelling(), assignedFieldName) == null) {
                        this.updateObjectMemberFieldAccesses(className, field);
                        continue;
                    }
                    if (Config.enablePUTFIELD || !methodModel.methodUsesPutfield() || methodModel.isSetter()) continue;
                    throw new ClassParseException(ClassParseException.TYPE.ACCESSEDOBJECTONLYSUPPORTSSIMPLEPUTFIELD);
                }
                if (!(instruction instanceof InstructionSet.I_INVOKEVIRTUAL)) continue;
                InstructionSet.I_INVOKEVIRTUAL invokeInstruction = (InstructionSet.I_INVOKEVIRTUAL)instruction;
                MethodModel invokedMethod = invokeInstruction.getMethod();
                ClassModel.ConstantPool.FieldEntry getterField = this.getSimpleGetterField(invokedMethod);
                if (getterField != null) {
                    this.referencedFieldNames.add(getterField.getNameAndTypeEntry().getNameUTF8Entry().getUTF8());
                    continue;
                }
                ClassModel.ConstantPool.MethodEntry methodEntry = invokeInstruction.getConstantPoolMethodEntry();
                if (!Kernel.isMappedMethod(methodEntry)) continue;
                if (Kernel.usesAtomic32(methodEntry)) {
                    this.setRequiresAtomics32Pragma(true);
                }
                if ((methodArgs = methodEntry.getArgs()).length <= 0 || !methodArgs[0].isArray()) continue;
                Instruction arrInstruction = invokeInstruction.getArg(0);
                if (arrInstruction instanceof InstructionSet.AccessField) {
                    InstructionSet.AccessField access2 = (InstructionSet.AccessField)((Object)arrInstruction);
                    ClassModel.ConstantPool.FieldEntry field3 = access2.getConstantPoolFieldEntry();
                    String accessedFieldName = field3.getNameAndTypeEntry().getNameUTF8Entry().getUTF8();
                    this.arrayFieldAssignments.add(accessedFieldName);
                    this.referencedFieldNames.add(accessedFieldName);
                    continue;
                }
                throw new ClassParseException(ClassParseException.TYPE.ACCESSEDOBJECTSETTERARRAY);
            }
        }
        for (String referencedFieldName : this.referencedFieldNames) {
            try {
                Class<?> clazz = this.classModel.getClassWeAreModelling();
                Field field = Entrypoint.getFieldFromClassHierarchy(clazz, referencedFieldName);
                if (field == null) continue;
                this.referencedFields.add(field);
                ClassModel.ClassModelField ff = this.classModel.getField(referencedFieldName);
                assert (ff != null) : "ff should not be null for " + clazz.getName() + "." + referencedFieldName;
                this.referencedClassModelFields.add(ff);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
        if (!this.objectArrayFieldsClasses.keySet().isEmpty()) {
            for (ClassModel memberObjClass : this.objectArrayFieldsClasses.values()) {
                for (ClassModel superModel = memberObjClass.getSuperClazz(); superModel != null; superModel = superModel.getSuperClazz()) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("adding = " + superModel.getClassWeAreModelling().getName() + " fields into " + memberObjClass.getClassWeAreModelling().getName());
                    }
                    memberObjClass.getStructMembers().addAll(superModel.getStructMembers());
                }
            }
            Comparator<ClassModel.ConstantPool.FieldEntry> comparator = new Comparator<ClassModel.ConstantPool.FieldEntry>(){

                @Override
                public int compare(ClassModel.ConstantPool.FieldEntry aa, ClassModel.ConstantPool.FieldEntry bb) {
                    String aType = aa.getNameAndTypeEntry().getDescriptorUTF8Entry().getUTF8();
                    String bType = bb.getNameAndTypeEntry().getDescriptorUTF8Entry().getUTF8();
                    int aSize = InstructionSet.TypeSpec.valueOf(aType.equals("Z") ? "B" : aType).getSize();
                    int bSize = InstructionSet.TypeSpec.valueOf(bType.equals("Z") ? "B" : bType).getSize();
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("aType= " + aType + " aSize= " + aSize + " . . bType= " + bType + " bSize= " + bSize);
                    }
                    if (aSize > bSize) {
                        return -1;
                    }
                    if (aSize == bSize) {
                        return 0;
                    }
                    return 1;
                }
            };
            for (ClassModel c : this.objectArrayFieldsClasses.values()) {
                ArrayList<ClassModel.ConstantPool.FieldEntry> fields = c.getStructMembers();
                if (fields.size() <= 0) continue;
                Collections.sort(fields, comparator);
                int totalSize = 0;
                int alignTo = 0;
                for (ClassModel.ConstantPool.FieldEntry f : fields) {
                    Field rfield = Entrypoint.getFieldFromClassHierarchy(c.getClassWeAreModelling(), f.getNameAndTypeEntry().getNameUTF8Entry().getUTF8());
                    c.getStructMemberOffsets().add(UnsafeWrapper.objectFieldOffset(rfield));
                    String fType = f.getNameAndTypeEntry().getDescriptorUTF8Entry().getUTF8();
                    c.getStructMemberTypes().add(InstructionSet.TypeSpec.valueOf(fType));
                    int fSize = InstructionSet.TypeSpec.valueOf(fType.equals("Z") ? "B" : fType).getSize();
                    if (fSize > alignTo) {
                        alignTo = fSize;
                    }
                    totalSize += fSize;
                    if (!logger.isLoggable(Level.FINEST)) continue;
                    logger.finest("Field = " + f.getNameAndTypeEntry().getNameUTF8Entry().getUTF8() + " size=" + fSize + " totalSize=" + totalSize);
                }
                int totalStructSize = 0;
                totalStructSize = totalSize % alignTo == 0 ? totalSize : (totalSize / alignTo + 1) * alignTo;
                c.setTotalStructSize(totalStructSize);
            }
        }
    }

    private boolean noCL(ClassModel.ClassModelMethod m) {
        boolean found = m.getClassModel().getNoCLMethods().contains(m.getName());
        return found;
    }

    private ClassModel.ConstantPool.FieldEntry getSimpleGetterField(MethodModel method) {
        return method.getAccessorVariableFieldEntry();
    }

    public List<ClassModel.ClassModelField> getReferencedClassModelFields() {
        return this.referencedClassModelFields;
    }

    public List<Field> getReferencedFields() {
        return this.referencedFields;
    }

    public List<MethodModel> getCalledMethods() {
        return this.calledMethods;
    }

    public Set<String> getReferencedFieldNames() {
        return this.referencedFieldNames;
    }

    public Set<String> getArrayFieldAssignments() {
        return this.arrayFieldAssignments;
    }

    public Set<String> getArrayFieldAccesses() {
        return this.arrayFieldAccesses;
    }

    public Set<String> getArrayFieldArrayLengthUsed() {
        return this.arrayFieldArrayLengthUsed;
    }

    public MethodModel getMethodModel() {
        return this.methodModel;
    }

    public ClassModel getClassModel() {
        return this.classModel;
    }

    public MethodModel getCallTarget(ClassModel.ConstantPool.MethodEntry _methodEntry, boolean _isSpecial) {
        ClassModel.ClassModelMethod target = this.getClassModel().getMethod(_methodEntry, _isSpecial);
        boolean isMapped = Kernel.isMappedMethod(_methodEntry);
        if (logger.isLoggable(Level.FINE) && target == null) {
            logger.fine("Did not find call target: " + _methodEntry + " in " + this.getClassModel().getClassWeAreModelling().getName() + " isMapped=" + isMapped);
        }
        if (target == null) {
            for (ClassModel memberObjClass : this.objectArrayFieldsClasses.values()) {
                String entryClassNameInDotForm = _methodEntry.getClassEntry().getNameUTF8Entry().getUTF8().replace('/', '.');
                if (!entryClassNameInDotForm.equals(memberObjClass.getClassWeAreModelling().getName())) continue;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Searching for call target: " + _methodEntry + " in " + memberObjClass.getClassWeAreModelling().getName());
                }
                if ((target = memberObjClass.getMethod(_methodEntry, false)) == null) continue;
                break;
            }
        }
        if (target != null) {
            for (MethodModel m : this.calledMethods) {
                if (m.getMethod() != target) continue;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("selected from called methods = " + m.getName());
                }
                return m;
            }
        }
        for (MethodModel m : this.calledMethods) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Searching for call target: " + _methodEntry + " in " + m.getName());
            }
            if (!m.getMethod().getName().equals(_methodEntry.getNameAndTypeEntry().getNameUTF8Entry().getUTF8()) || !m.getMethod().getDescriptor().equals(_methodEntry.getNameAndTypeEntry().getDescriptorUTF8Entry().getUTF8())) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Found " + m.getMethod().getClassModel().getClassWeAreModelling().getName() + "." + m.getMethod().getName() + " " + m.getMethod().getDescriptor());
            }
            return m;
        }
        assert (target == null) : "Should not have missed a method in calledMethods";
        return null;
    }

    Entrypoint cloneForKernel(Object _k) throws AparapiException {
        try {
            Entrypoint clonedEntrypoint = (Entrypoint)this.clone();
            clonedEntrypoint.kernelInstance = _k;
            return clonedEntrypoint;
        }
        catch (CloneNotSupportedException e) {
            throw new AparapiException(e);
        }
    }
}

