/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi.internal.model;

import com.aparapi.Config;
import com.aparapi.Kernel;
import com.aparapi.internal.annotation.DocMe;
import com.aparapi.internal.exception.AparapiException;
import com.aparapi.internal.exception.ClassParseException;
import com.aparapi.internal.instruction.InstructionSet;
import com.aparapi.internal.model.CacheEnabler;
import com.aparapi.internal.model.Entrypoint;
import com.aparapi.internal.model.EntrypointKey;
import com.aparapi.internal.model.Memoizer;
import com.aparapi.internal.model.MethodKey;
import com.aparapi.internal.model.MethodModel;
import com.aparapi.internal.model.Supplier;
import com.aparapi.internal.model.ValueCache;
import com.aparapi.internal.reader.ByteReader;
import com.aparapi.internal.util.Reflection;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassModel {
    public static final char SIGC_VOID = 'V';
    public static final char SIGC_BOOLEAN = 'Z';
    public static final char SIGC_BYTE = 'B';
    public static final char SIGC_CHAR = 'C';
    public static final char SIGC_SHORT = 'S';
    public static final char SIGC_INT = 'I';
    public static final char SIGC_LONG = 'J';
    public static final char SIGC_FLOAT = 'F';
    public static final char SIGC_DOUBLE = 'D';
    public static final char SIGC_ARRAY = '[';
    public static final char SIGC_CLASS = 'L';
    public static final char SIGC_START_METHOD = '(';
    public static final char SIGC_END_CLASS = ';';
    public static final char SIGC_END_METHOD = ')';
    public static final char SIGC_PACKAGE = '/';
    private static Logger logger = Logger.getLogger(Config.getLoggerName());
    private ClassModel superClazz = null;
    private Memoizer<Set<String>> noClMethods = Memoizer.Impl.of(new Supplier<Set<String>>(){

        @Override
        public Set<String> get() {
            return ClassModel.this.computeNoCLMethods();
        }
    });
    private Memoizer<Map<String, Kernel.PrivateMemorySpace>> privateMemoryFields = Memoizer.Impl.of(new Supplier<Map<String, Kernel.PrivateMemorySpace>>(){

        @Override
        public Map<String, Kernel.PrivateMemorySpace> get() {
            return ClassModel.this.computePrivateMemoryFields();
        }
    });
    private ValueCache<String, Integer, ClassParseException> privateMemorySizes = ValueCache.on(new ValueCache.ThrowingValueComputer<String, Integer, ClassParseException>(){

        @Override
        public Integer compute(String fieldName) throws ClassParseException {
            return ClassModel.this.computePrivateMemorySize(fieldName);
        }
    });
    private static final ValueCache<Class<?>, ClassModel, ClassParseException> classModelCache = ValueCache.on(new ValueCache.ThrowingValueComputer<Class<?>, ClassModel, ClassParseException>(){

        @Override
        public ClassModel compute(Class<?> key) throws ClassParseException {
            return ClassModel.createClassModelInternal(key);
        }
    });
    private int magic;
    private int minorVersion;
    private int majorVersion;
    private ConstantPool constantPool;
    private int accessFlags;
    private int thisClassConstantPoolIndex;
    private int superClassConstantPoolIndex;
    private final List<ClassModelInterface> interfaces = new ArrayList<ClassModelInterface>();
    private final List<ClassModelField> fields = new ArrayList<ClassModelField>();
    private final List<ClassModelMethod> methods = new ArrayList<ClassModelMethod>();
    private AttributePool attributePool;
    private static ClassLoader classModelLoader = ClassModel.class.getClassLoader();
    private Class<?> clazz;
    private ValueCache<MethodKey, MethodModel, AparapiException> methodModelCache = ValueCache.on(new ValueCache.ThrowingValueComputer<MethodKey, MethodModel, AparapiException>(){

        @Override
        public MethodModel compute(MethodKey key) throws AparapiException {
            return ClassModel.this.computeMethodModel(key);
        }
    });
    private final ArrayList<ConstantPool.FieldEntry> structMembers = new ArrayList();
    private final ArrayList<Long> structMemberOffsets = new ArrayList();
    private final ArrayList<InstructionSet.TypeSpec> structMemberTypes = new ArrayList();
    private int totalStructSize = 0;
    private final ValueCache<EntrypointKey, Entrypoint, AparapiException> entrypointCache = ValueCache.on(new ValueCache.ThrowingValueComputer<EntrypointKey, Entrypoint, AparapiException>(){

        @Override
        public Entrypoint compute(EntrypointKey key) throws AparapiException {
            return ClassModel.this.computeBasicEntrypoint(key);
        }
    });

    private ClassModel(Class<?> _class) throws ClassParseException {
        this.parse(_class);
        Class<?> mySuper = _class.getSuperclass();
        if (mySuper != null && !mySuper.getName().equals(Kernel.class.getName()) && !mySuper.getName().equals("java.lang.Object")) {
            this.superClazz = ClassModel.createClassModel(mySuper);
        }
    }

    ClassModel(InputStream _inputStream) throws ClassParseException {
        this.parse(_inputStream);
    }

    ClassModel(Class<?> _clazz, byte[] _bytes) throws ClassParseException {
        this.clazz = _clazz;
        this.parse(new ByteArrayInputStream(_bytes));
    }

    public boolean isSuperClass(String otherClassName) {
        if (this.getClassWeAreModelling().getName().equals(otherClassName)) {
            return true;
        }
        if (this.superClazz != null) {
            return this.superClazz.isSuperClass(otherClassName);
        }
        return false;
    }

    public boolean isSuperClass(Class<?> other) {
        for (Class<?> s = other.getSuperclass(); s != null; s = s.getSuperclass()) {
            if (this.getClassWeAreModelling() != s && !this.getClassWeAreModelling().getName().equals(s.getName())) continue;
            return true;
        }
        return false;
    }

    public ClassModel getSuperClazz() {
        return this.superClazz;
    }

    @DocMe
    public void replaceSuperClazz(ClassModel c) {
        if (this.superClazz != null) {
            assert (c.isSuperClass(this.getClassWeAreModelling())) : "not my super";
            if (this.superClazz.getClassWeAreModelling().getName().equals(c.getClassWeAreModelling().getName())) {
                this.superClazz = c;
            } else {
                this.superClazz.replaceSuperClazz(c);
            }
        }
    }

    public static String typeName(char _typeChar) {
        String returnName = null;
        switch (_typeChar) {
            case 'V': {
                returnName = "void";
                break;
            }
            case 'I': {
                returnName = "int";
                break;
            }
            case 'D': {
                returnName = "double";
                break;
            }
            case 'F': {
                returnName = "float";
                break;
            }
            case 'S': {
                returnName = "short";
                break;
            }
            case 'C': {
                returnName = "char";
                break;
            }
            case 'B': {
                returnName = "byte";
                break;
            }
            case 'J': {
                returnName = "long";
                break;
            }
            case 'Z': {
                returnName = "boolean";
            }
        }
        return returnName;
    }

    public Integer getPrivateMemorySize(String fieldName) throws ClassParseException {
        if (CacheEnabler.areCachesEnabled()) {
            return this.privateMemorySizes.computeIfAbsent(fieldName);
        }
        return this.computePrivateMemorySize(fieldName);
    }

    private Integer computePrivateMemorySize(String fieldName) throws ClassParseException {
        Kernel.PrivateMemorySpace annotation = (Kernel.PrivateMemorySpace)((Map)this.privateMemoryFields.get()).get(fieldName);
        if (annotation != null) {
            return annotation.value();
        }
        return ClassModel.getPrivateMemorySizeFromFieldName(fieldName);
    }

    private Map<String, Kernel.PrivateMemorySpace> computePrivateMemoryFields() {
        Kernel.PrivateMemorySpace privateMemorySpace;
        HashMap<String, Kernel.PrivateMemorySpace> tempPrivateMemoryFields = new HashMap<String, Kernel.PrivateMemorySpace>();
        HashMap<Field, Kernel.PrivateMemorySpace> privateMemoryFields = new HashMap<Field, Kernel.PrivateMemorySpace>();
        for (Field field : this.getClassWeAreModelling().getDeclaredFields()) {
            privateMemorySpace = field.getAnnotation(Kernel.PrivateMemorySpace.class);
            if (privateMemorySpace == null) continue;
            privateMemoryFields.put(field, privateMemorySpace);
        }
        for (Field field : this.getClassWeAreModelling().getFields()) {
            privateMemorySpace = field.getAnnotation(Kernel.PrivateMemorySpace.class);
            if (privateMemorySpace == null) continue;
            privateMemoryFields.put(field, privateMemorySpace);
        }
        for (Map.Entry entry : privateMemoryFields.entrySet()) {
            tempPrivateMemoryFields.put(((Field)entry.getKey()).getName(), (Kernel.PrivateMemorySpace)entry.getValue());
        }
        return tempPrivateMemoryFields;
    }

    public static Integer getPrivateMemorySizeFromField(Field field) {
        Kernel.PrivateMemorySpace privateMemorySpace = field.getAnnotation(Kernel.PrivateMemorySpace.class);
        if (privateMemorySpace != null) {
            return privateMemorySpace.value();
        }
        return null;
    }

    public static Integer getPrivateMemorySizeFromFieldName(String fieldName) throws ClassParseException {
        if (fieldName.contains("_$private$")) {
            int lastDollar = fieldName.lastIndexOf(36);
            String sizeText = fieldName.substring(lastDollar + 1);
            try {
                return new Integer(Integer.parseInt(sizeText));
            }
            catch (NumberFormatException e) {
                throw new ClassParseException(ClassParseException.TYPE.IMPROPERPRIVATENAMEMANGLING, fieldName);
            }
        }
        return null;
    }

    public Set<String> getNoCLMethods() {
        return this.computeNoCLMethods();
    }

    private Set<String> computeNoCLMethods() {
        HashSet<String> tempNoClMethods = new HashSet<String>();
        HashSet<Method> methods = new HashSet<Method>();
        for (Method method : this.getClassWeAreModelling().getDeclaredMethods()) {
            if (method.getAnnotation(Kernel.NoCL.class) == null) continue;
            methods.add(method);
        }
        for (Method method : this.getClassWeAreModelling().getMethods()) {
            if (method.getAnnotation(Kernel.NoCL.class) == null) continue;
            methods.add(method);
        }
        for (Method method : methods) {
            tempNoClMethods.add(method.getName());
        }
        return tempNoClMethods;
    }

    public static String convert(String _string) {
        return ClassModel.convert(_string, "", false);
    }

    public static String convert(String _string, String _insert) {
        return ClassModel.convert(_string, _insert, false);
    }

    public static String convert(String _string, String _insert, boolean _showFullClassName) {
        Stack<String> stringStack = new Stack<String>();
        Stack<String> methodStack = null;
        int length = _string.length();
        char[] chars = _string.toCharArray();
        int i = 0;
        boolean inArray = false;
        boolean inMethod = false;
        boolean inArgs = false;
        int args = 0;
        while (i < length) {
            switch (chars[i]) {
                case 'L': {
                    StringBuilder classNameBuffer = new StringBuilder();
                    ++i;
                    while (i < length && chars[i] != ';') {
                        if (chars[i] == '/') {
                            classNameBuffer.append('.');
                        } else {
                            classNameBuffer.append(chars[i]);
                        }
                        ++i;
                    }
                    ++i;
                    String className = classNameBuffer.toString();
                    if (_showFullClassName) {
                        if (className.startsWith("java.lang")) {
                            className = className.substring("java.lang.".length());
                        }
                    } else {
                        int lastDot = className.lastIndexOf(46);
                        if (lastDot > 0) {
                            className = className.substring(lastDot + 1);
                        }
                    }
                    if (inArray) {
                        String popped = (String)stringStack.pop();
                        if (inArgs && args > 0) {
                            stringStack.push(", ");
                        }
                        stringStack.push(className);
                        stringStack.push(popped);
                        inArray = false;
                    } else {
                        if (inArgs && args > 0) {
                            stringStack.push(", ");
                        }
                        stringStack.push(className);
                    }
                    ++args;
                    break;
                }
                case '[': {
                    StringBuilder arrayDims = new StringBuilder();
                    while (i < length && chars[i] == '[') {
                        arrayDims.append("[]");
                        ++i;
                    }
                    stringStack.push(arrayDims.toString());
                    inArray = true;
                    break;
                }
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'Z': {
                    if (inArray) {
                        String popped = (String)stringStack.pop();
                        if (inArgs && args > 0) {
                            stringStack.push(", ");
                        }
                        stringStack.push(ClassModel.typeName(chars[i]));
                        stringStack.push(popped);
                        inArray = false;
                    } else {
                        if (inArgs && args > 0) {
                            stringStack.push(", ");
                        }
                        stringStack.push(ClassModel.typeName(chars[i]));
                    }
                    ++i;
                    break;
                }
                case '(': {
                    stringStack.push("(");
                    ++i;
                    inArgs = true;
                    args = 0;
                    break;
                }
                case ')': {
                    inMethod = true;
                    inArgs = false;
                    stringStack.push(")");
                    methodStack = stringStack;
                    stringStack = new Stack();
                    ++i;
                }
            }
        }
        StringBuilder returnValue = new StringBuilder();
        for (String s : stringStack) {
            returnValue.append(s);
            returnValue.append(" ");
        }
        if (inMethod) {
            for (String s : methodStack) {
                returnValue.append(s);
                returnValue.append(" ");
            }
        } else {
            returnValue.append(_insert);
        }
        return returnValue.toString();
    }

    public static MethodDescription getMethodDescription(String _string) {
        String className = null;
        String methodName = null;
        String descriptor = null;
        MethodDescription methodDescription = null;
        if (_string.startsWith("(")) {
            className = "?";
            methodName = "?";
            descriptor = _string;
        } else {
            int parenIndex = _string.indexOf("(");
            int dotIndex = _string.indexOf(".");
            descriptor = _string.substring(parenIndex);
            className = _string.substring(0, dotIndex);
            methodName = _string.substring(dotIndex + 1, parenIndex);
        }
        Stack<String> stringStack = new Stack<String>();
        Stack<String> methodStack = null;
        int length = descriptor.length();
        char[] chars = new char[descriptor.length()];
        descriptor.getChars(0, descriptor.length(), chars, 0);
        int i = 0;
        boolean inArray = false;
        boolean inMethod = false;
        while (i < length) {
            switch (chars[i]) {
                case 'L': {
                    StringBuilder stringBuffer = null;
                    stringBuffer = inArray ? new StringBuilder((String)stringStack.pop()) : new StringBuilder();
                    while (i < length && chars[i] != ';') {
                        stringBuffer.append(chars[i]);
                        ++i;
                    }
                    stringBuffer.append(chars[i]);
                    ++i;
                    stringStack.push(stringBuffer.toString());
                    inArray = false;
                    break;
                }
                case '[': {
                    StringBuilder stringBuffer = new StringBuilder();
                    while (i < length && chars[i] == '[') {
                        stringBuffer.append(chars[i]);
                        ++i;
                    }
                    stringStack.push(stringBuffer.toString());
                    inArray = true;
                    break;
                }
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'Z': {
                    StringBuilder stringBuffer = null;
                    stringBuffer = inArray ? new StringBuilder((String)stringStack.pop()) : new StringBuilder();
                    stringBuffer.append(chars[i]);
                    ++i;
                    stringStack.push(stringBuffer.toString());
                    inArray = false;
                    break;
                }
                case '(': {
                    ++i;
                    break;
                }
                case ')': {
                    inMethod = true;
                    inArray = false;
                    methodStack = stringStack;
                    stringStack = new Stack();
                    ++i;
                }
            }
        }
        if (inMethod) {
            methodDescription = new MethodDescription(className, methodName, stringStack.toArray(new String[0])[0], methodStack.toArray(new String[0]));
        } else {
            System.out.println("can't convert to a description");
        }
        return methodDescription;
    }

    private static ClassModel createClassModelInternal(Class<?> key) throws ClassParseException {
        ClassModel classModel = new ClassModel(key);
        return classModel;
    }

    public static ClassModel createClassModel(Class<?> _class) throws ClassParseException {
        if (CacheEnabler.areCachesEnabled()) {
            return classModelCache.computeIfAbsent(_class);
        }
        return ClassModel.createClassModelInternal(_class);
    }

    public void parse(Class<?> _class) throws ClassParseException {
        this.clazz = _class;
        this.parse(_class.getClassLoader(), _class.getName());
    }

    private void parse(ClassLoader _classLoader, String _className) throws ClassParseException {
        this.parse(_classLoader.getResourceAsStream(_className.replace('.', '/') + ".class"));
    }

    void parse(InputStream _inputStream) throws ClassParseException {
        ByteReader byteReader = new ByteReader(_inputStream);
        this.magic = byteReader.u4();
        this.minorVersion = byteReader.u2();
        this.majorVersion = byteReader.u2();
        this.constantPool = new ConstantPool(byteReader);
        this.accessFlags = byteReader.u2();
        this.thisClassConstantPoolIndex = byteReader.u2();
        this.superClassConstantPoolIndex = byteReader.u2();
        int interfaceCount = byteReader.u2();
        for (int i = 0; i < interfaceCount; ++i) {
            ClassModelInterface iface = new ClassModelInterface(byteReader);
            this.interfaces.add(iface);
        }
        int fieldCount = byteReader.u2();
        for (int i = 0; i < fieldCount; ++i) {
            ClassModelField field = new ClassModelField(byteReader, i);
            this.fields.add(field);
        }
        int methodPoolLength = byteReader.u2();
        for (int i = 0; i < methodPoolLength; ++i) {
            ClassModelMethod method = new ClassModelMethod(byteReader, i);
            this.methods.add(method);
        }
        this.attributePool = new AttributePool(byteReader, Reflection.getSimpleName(this.getClassWeAreModelling()));
    }

    public int getMagic() {
        return this.magic;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public int getThisClassConstantPoolIndex() {
        return this.thisClassConstantPoolIndex;
    }

    public int getSuperClassConstantPoolIndex() {
        return this.superClassConstantPoolIndex;
    }

    public AttributePool getAttributePool() {
        return this.attributePool;
    }

    public ClassModelField getField(String _name, String _descriptor) {
        for (ClassModelField entry : this.fields) {
            if (!entry.getName().equals(_name) || !entry.getDescriptor().equals(_descriptor)) continue;
            return entry;
        }
        return this.superClazz.getField(_name, _descriptor);
    }

    public ClassModelField getField(String _name) {
        for (ClassModelField entry : this.fields) {
            if (!entry.getName().equals(_name)) continue;
            return entry;
        }
        return this.superClazz.getField(_name);
    }

    public ClassModelMethod getMethod(String _name, String _descriptor) {
        ClassModelMethod methodOrNull = this.getMethodOrNull(_name, _descriptor);
        if (methodOrNull == null) {
            return this.superClazz != null ? this.superClazz.getMethod(_name, _descriptor) : null;
        }
        return methodOrNull;
    }

    private ClassModelMethod getMethodOrNull(String _name, String _descriptor) {
        for (ClassModelMethod entry : this.methods) {
            if (!entry.getName().equals(_name) || !entry.getDescriptor().equals(_descriptor)) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Found " + this.clazz.getName() + "." + entry.getName() + " " + entry.getDescriptor() + " for " + _name.replace('/', '.'));
            }
            return entry;
        }
        return null;
    }

    public List<ClassModelField> getFieldPoolEntries() {
        return this.fields;
    }

    public ClassModelMethod getMethod(ConstantPool.MethodEntry _methodEntry, boolean _isSpecial) {
        String entryClassNameInDotForm = _methodEntry.getClassEntry().getNameUTF8Entry().getUTF8().replace('/', '.');
        if (_isSpecial && this.superClazz != null && this.superClazz.isSuperClass(entryClassNameInDotForm)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("going to look in super:" + this.superClazz.getClassWeAreModelling().getName() + " on behalf of " + entryClassNameInDotForm);
            }
            return this.superClazz.getMethod(_methodEntry, false);
        }
        ConstantPool.NameAndTypeEntry nameAndTypeEntry = _methodEntry.getNameAndTypeEntry();
        ClassModelMethod methodOrNull = this.getMethodOrNull(nameAndTypeEntry.getNameUTF8Entry().getUTF8(), nameAndTypeEntry.getDescriptorUTF8Entry().getUTF8());
        if (methodOrNull == null) {
            return this.superClazz != null ? this.superClazz.getMethod(_methodEntry, false) : null;
        }
        return methodOrNull;
    }

    public MethodModel getMethodModel(String _name, String _signature) throws AparapiException {
        if (CacheEnabler.areCachesEnabled()) {
            return this.methodModelCache.computeIfAbsent(MethodKey.of(_name, _signature));
        }
        ClassModelMethod method = this.getMethod(_name, _signature);
        return new MethodModel(method);
    }

    private MethodModel computeMethodModel(MethodKey methodKey) throws AparapiException {
        ClassModelMethod method = this.getMethod(methodKey.getName(), methodKey.getSignature());
        return new MethodModel(method);
    }

    public ArrayList<ConstantPool.FieldEntry> getStructMembers() {
        return this.structMembers;
    }

    public ArrayList<Long> getStructMemberOffsets() {
        return this.structMemberOffsets;
    }

    public ArrayList<InstructionSet.TypeSpec> getStructMemberTypes() {
        return this.structMemberTypes;
    }

    public int getTotalStructSize() {
        return this.totalStructSize;
    }

    public void setTotalStructSize(int x) {
        this.totalStructSize = x;
    }

    Entrypoint getEntrypoint(String _entrypointName, String _descriptor, Object _k) throws AparapiException {
        if (CacheEnabler.areCachesEnabled()) {
            EntrypointKey key = EntrypointKey.of(_entrypointName, _descriptor);
            long s = System.nanoTime();
            Entrypoint entrypointWithoutKernel = this.entrypointCache.computeIfAbsent(key);
            long e = System.nanoTime() - s;
            return entrypointWithoutKernel.cloneForKernel(_k);
        }
        MethodModel method = this.getMethodModel(_entrypointName, _descriptor);
        return new Entrypoint(this, method, _k);
    }

    Entrypoint computeBasicEntrypoint(EntrypointKey entrypointKey) throws AparapiException {
        MethodModel method = this.getMethodModel(entrypointKey.getEntrypointName(), entrypointKey.getDescriptor());
        return new Entrypoint(this, method, null);
    }

    public Class<?> getClassWeAreModelling() {
        return this.clazz;
    }

    public Entrypoint getEntrypoint(String _entrypointName, Object _k) throws AparapiException {
        return this.getEntrypoint(_entrypointName, "()V", _k);
    }

    public Entrypoint getEntrypoint() throws AparapiException {
        return this.getEntrypoint("run", "()V", null);
    }

    public static void invalidateCaches() {
        classModelCache.invalidate();
    }

    public String toString() {
        return "ClassModel of " + this.getClassWeAreModelling();
    }

    public class ClassModelInterface {
        private final int interfaceIndex;

        ClassModelInterface(ByteReader _byteReader) {
            this.interfaceIndex = _byteReader.u2();
        }

        ConstantPool.ClassEntry getClassEntry() {
            return ClassModel.this.constantPool.getClassEntry(this.interfaceIndex);
        }

        int getInterfaceIndex() {
            return this.interfaceIndex;
        }
    }

    public class ClassModelMethod {
        private final int methodAccessFlags;
        private final AttributePool methodAttributePool;
        private final int descriptorIndex;
        private final int index;
        private final int nameIndex;
        private final AttributePool.CodeEntry codeEntry;

        public ClassModelMethod(ByteReader _byteReader, int _index) {
            this.index = _index;
            this.methodAccessFlags = _byteReader.u2();
            this.nameIndex = _byteReader.u2();
            this.descriptorIndex = _byteReader.u2();
            this.methodAttributePool = new AttributePool(_byteReader, this.getName());
            this.codeEntry = this.methodAttributePool.getCodeEntry();
        }

        public int getAccessFlags() {
            return this.methodAccessFlags;
        }

        public boolean isStatic() {
            return Access.STATIC.bitIsSet(this.methodAccessFlags);
        }

        public AttributePool getAttributePool() {
            return this.methodAttributePool;
        }

        public AttributePool.CodeEntry getCodeEntry() {
            return this.methodAttributePool.getCodeEntry();
        }

        public String getDescriptor() {
            return this.getDescriptorUTF8Entry().getUTF8();
        }

        public int getDescriptorIndex() {
            return this.descriptorIndex;
        }

        public ConstantPool.UTF8Entry getDescriptorUTF8Entry() {
            return ClassModel.this.constantPool.getUTF8Entry(this.descriptorIndex);
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.getNameUTF8Entry().getUTF8();
        }

        public int getNameIndex() {
            return this.nameIndex;
        }

        public ConstantPool.UTF8Entry getNameUTF8Entry() {
            return ClassModel.this.constantPool.getUTF8Entry(this.nameIndex);
        }

        public ConstantPool getConstantPool() {
            return ClassModel.this.constantPool;
        }

        public AttributePool.LineNumberTableEntry getLineNumberTableEntry() {
            return this.getAttributePool().codeEntry.codeEntryAttributePool.lineNumberTableEntry;
        }

        public LocalVariableTableEntry getLocalVariableTableEntry() {
            return this.getAttributePool().codeEntry.codeEntryAttributePool.localVariableTableEntry;
        }

        void setLocalVariableTableEntry(LocalVariableTableEntry _localVariableTableEntry) {
            this.getAttributePool().codeEntry.codeEntryAttributePool.localVariableTableEntry = _localVariableTableEntry;
        }

        public LocalVariableInfo getLocalVariable(int _pc, int _index) {
            return this.getLocalVariableTableEntry().getVariable(_pc, _index);
        }

        public byte[] getCode() {
            return this.codeEntry.getCode();
        }

        public ClassModel getClassModel() {
            return ClassModel.this;
        }

        public String toString() {
            return this.getClassModel().getClassWeAreModelling().getName() + "." + this.getName() + " " + this.getDescriptor();
        }

        public ClassModel getOwnerClassModel() {
            return ClassModel.this;
        }
    }

    public class ClassModelField {
        private final int fieldAccessFlags;
        AttributePool fieldAttributePool;
        private final int descriptorIndex;
        private final int index;
        private final int nameIndex;

        public ClassModelField(ByteReader _byteReader, int _index) {
            this.index = _index;
            this.fieldAccessFlags = _byteReader.u2();
            this.nameIndex = _byteReader.u2();
            this.descriptorIndex = _byteReader.u2();
            this.fieldAttributePool = new AttributePool(_byteReader, this.getName());
        }

        public int getAccessFlags() {
            return this.fieldAccessFlags;
        }

        public AttributePool getAttributePool() {
            return this.fieldAttributePool;
        }

        public String getDescriptor() {
            return this.getDescriptorUTF8Entry().getUTF8();
        }

        public int getDescriptorIndex() {
            return this.descriptorIndex;
        }

        public ConstantPool.UTF8Entry getDescriptorUTF8Entry() {
            return ClassModel.this.constantPool.getUTF8Entry(this.descriptorIndex);
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.getNameUTF8Entry().getUTF8();
        }

        public int getNameIndex() {
            return this.nameIndex;
        }

        public ConstantPool.UTF8Entry getNameUTF8Entry() {
            return ClassModel.this.constantPool.getUTF8Entry(this.nameIndex);
        }

        public Class<?> getDeclaringClass() {
            String clazzName = this.getDescriptor().replaceAll("^L", "").replaceAll("/", ".").replaceAll(";$", "");
            try {
                return Class.forName(clazzName, true, classModelLoader);
            }
            catch (ClassNotFoundException e) {
                System.out.println("no class found for " + clazzName);
                e.printStackTrace();
                return null;
            }
        }
    }

    public class AttributePool {
        private final List<AttributePoolEntry> attributePoolEntries = new ArrayList<AttributePoolEntry>();
        private CodeEntry codeEntry = null;
        private EnclosingMethodEntry enclosingMethodEntry = null;
        private DeprecatedEntry deprecatedEntry = null;
        private ExceptionEntry exceptionEntry = null;
        private LineNumberTableEntry lineNumberTableEntry = null;
        private LocalVariableTableEntry localVariableTableEntry = null;
        private RuntimeAnnotationsEntry runtimeVisibleAnnotationsEntry;
        private RuntimeAnnotationsEntry runtimeInvisibleAnnotationsEntry;
        private SourceFileEntry sourceFileEntry = null;
        private SyntheticEntry syntheticEntry = null;
        private BootstrapMethodsEntry bootstrapMethodsEntry = null;
        private static final String LOCALVARIABLETABLE_TAG = "LocalVariableTable";
        private static final String CONSTANTVALUE_TAG = "ConstantValue";
        private static final String LINENUMBERTABLE_TAG = "LineNumberTable";
        private static final String SOURCEFILE_TAG = "SourceFile";
        private static final String SYNTHETIC_TAG = "Synthetic";
        private static final String EXCEPTIONS_TAG = "Exceptions";
        private static final String INNERCLASSES_TAG = "InnerClasses";
        private static final String DEPRECATED_TAG = "Deprecated";
        private static final String CODE_TAG = "Code";
        private static final String ENCLOSINGMETHOD_TAG = "EnclosingMethod";
        private static final String SIGNATURE_TAG = "Signature";
        private static final String RUNTIMEINVISIBLEANNOTATIONS_TAG = "RuntimeInvisibleAnnotations";
        private static final String RUNTIMEVISIBLEANNOTATIONS_TAG = "RuntimeVisibleAnnotations";
        private static final String BOOTSTRAPMETHODS_TAG = "BootstrapMethods";
        private static final String STACKMAPTABLE_TAG = "StackMapTable";
        private static final String LOCALVARIABLETYPETABLE_TAG = "LocalVariableTypeTable";

        public AttributePool(ByteReader _byteReader, String name) {
            int attributeCount = _byteReader.u2();
            AttributePoolEntry entry = null;
            for (int i = 0; i < attributeCount; ++i) {
                int attributeNameIndex = _byteReader.u2();
                int length = _byteReader.u4();
                ConstantPool.UTF8Entry utf8Entry = ClassModel.this.constantPool.getUTF8Entry(attributeNameIndex);
                if (utf8Entry == null) {
                    throw new IllegalStateException("corrupted state reading attributes for " + name);
                }
                String attributeName = utf8Entry.getUTF8();
                if (attributeName.equals(LOCALVARIABLETABLE_TAG)) {
                    this.localVariableTableEntry = new RealLocalVariableTableEntry(_byteReader, attributeNameIndex, length);
                    entry = (RealLocalVariableTableEntry)this.localVariableTableEntry;
                } else if (attributeName.equals(CONSTANTVALUE_TAG)) {
                    entry = new ConstantValueEntry(_byteReader, attributeNameIndex, length);
                } else if (attributeName.equals(LINENUMBERTABLE_TAG)) {
                    this.lineNumberTableEntry = new LineNumberTableEntry(_byteReader, attributeNameIndex, length);
                    entry = this.lineNumberTableEntry;
                } else if (attributeName.equals(SOURCEFILE_TAG)) {
                    this.sourceFileEntry = new SourceFileEntry(_byteReader, attributeNameIndex, length);
                    entry = this.sourceFileEntry;
                } else if (attributeName.equals(SYNTHETIC_TAG)) {
                    this.syntheticEntry = new SyntheticEntry(_byteReader, attributeNameIndex, length);
                    entry = this.syntheticEntry;
                } else if (attributeName.equals(EXCEPTIONS_TAG)) {
                    this.exceptionEntry = new ExceptionEntry(_byteReader, attributeNameIndex, length);
                    entry = this.exceptionEntry;
                } else if (attributeName.equals(INNERCLASSES_TAG)) {
                    entry = new InnerClassesEntry(_byteReader, attributeNameIndex, length);
                } else if (attributeName.equals(DEPRECATED_TAG)) {
                    this.deprecatedEntry = new DeprecatedEntry(_byteReader, attributeNameIndex, length);
                    entry = this.deprecatedEntry;
                } else if (attributeName.equals(CODE_TAG)) {
                    this.codeEntry = new CodeEntry(_byteReader, attributeNameIndex, length);
                    entry = this.codeEntry;
                } else if (attributeName.equals(ENCLOSINGMETHOD_TAG)) {
                    this.enclosingMethodEntry = new EnclosingMethodEntry(_byteReader, attributeNameIndex, length);
                    entry = this.enclosingMethodEntry;
                } else if (attributeName.equals(SIGNATURE_TAG)) {
                    entry = new SignatureEntry(_byteReader, attributeNameIndex, length);
                } else if (attributeName.equals(RUNTIMEINVISIBLEANNOTATIONS_TAG)) {
                    this.runtimeInvisibleAnnotationsEntry = new RuntimeAnnotationsEntry(_byteReader, attributeNameIndex, length);
                    entry = this.runtimeInvisibleAnnotationsEntry;
                } else if (attributeName.equals(RUNTIMEVISIBLEANNOTATIONS_TAG)) {
                    this.runtimeVisibleAnnotationsEntry = new RuntimeAnnotationsEntry(_byteReader, attributeNameIndex, length);
                    entry = this.runtimeVisibleAnnotationsEntry;
                } else if (attributeName.equals(BOOTSTRAPMETHODS_TAG)) {
                    this.bootstrapMethodsEntry = new BootstrapMethodsEntry(_byteReader, attributeNameIndex, length);
                    entry = this.bootstrapMethodsEntry;
                } else if (attributeName.equals(STACKMAPTABLE_TAG)) {
                    entry = new StackMapTableEntry(_byteReader, attributeNameIndex, length);
                } else if (attributeName.equals(LOCALVARIABLETYPETABLE_TAG)) {
                    entry = new LocalVariableTypeTableEntry(_byteReader, attributeNameIndex, length);
                } else {
                    logger.warning("Found unexpected Attribute (name = " + attributeName + ")");
                    entry = new OtherEntry(_byteReader, attributeNameIndex, length);
                }
                this.attributePoolEntries.add(entry);
            }
        }

        public CodeEntry getCodeEntry() {
            return this.codeEntry;
        }

        public DeprecatedEntry getDeprecatedEntry() {
            return this.deprecatedEntry;
        }

        public ExceptionEntry getExceptionEntry() {
            return this.exceptionEntry;
        }

        public LineNumberTableEntry getLineNumberTableEntry() {
            return this.lineNumberTableEntry;
        }

        public LocalVariableTableEntry getLocalVariableTableEntry() {
            return this.localVariableTableEntry;
        }

        public SourceFileEntry getSourceFileEntry() {
            return this.sourceFileEntry;
        }

        public SyntheticEntry getSyntheticEntry() {
            return this.syntheticEntry;
        }

        public RuntimeAnnotationsEntry getRuntimeInvisibleAnnotationsEntry() {
            return this.runtimeInvisibleAnnotationsEntry;
        }

        public RuntimeAnnotationsEntry getRuntimeVisibleAnnotationsEntry() {
            return this.runtimeVisibleAnnotationsEntry;
        }

        public RuntimeAnnotationsEntry getBootstrap() {
            return this.runtimeVisibleAnnotationsEntry;
        }

        public class RuntimeAnnotationsEntry
        extends PoolEntry<AnnotationInfo> {
            public RuntimeAnnotationsEntry(ByteReader _byteReader, int _nameIndex, int _length) {
                super(_byteReader, _nameIndex, _length);
                int localVariableTableLength = _byteReader.u2();
                for (int i = 0; i < localVariableTableLength; ++i) {
                    this.getPool().add(new AnnotationInfo(_byteReader));
                }
            }

            public class AnnotationInfo {
                private final int typeIndex;
                private final int elementValuePairCount;
                private final ElementValuePair[] elementValuePairs;

                public AnnotationInfo(ByteReader _byteReader) {
                    this.typeIndex = _byteReader.u2();
                    this.elementValuePairCount = _byteReader.u2();
                    this.elementValuePairs = new ElementValuePair[this.elementValuePairCount];
                    for (int i = 0; i < this.elementValuePairCount; ++i) {
                        this.elementValuePairs[i] = new ElementValuePair(_byteReader);
                    }
                }

                public int getTypeIndex() {
                    return this.typeIndex;
                }

                public String getTypeDescriptor() {
                    return ClassModel.this.constantPool.getUTF8Entry(this.typeIndex).getUTF8();
                }

                public class ElementValuePair {
                    private final int elementNameIndex;
                    private Value value;

                    public ElementValuePair(ByteReader _byteReader) {
                        this.elementNameIndex = _byteReader.u2();
                        int tag = _byteReader.u1();
                        switch (tag) {
                            case 66: 
                            case 67: 
                            case 68: 
                            case 70: 
                            case 73: 
                            case 74: 
                            case 83: 
                            case 90: 
                            case 115: {
                                this.value = new PrimitiveValue(tag, _byteReader);
                                break;
                            }
                            case 101: {
                                this.value = new EnumValue(tag, _byteReader);
                                break;
                            }
                            case 99: {
                                this.value = new ClassValue(tag, _byteReader);
                                break;
                            }
                            case 64: {
                                this.value = new AnnotationValue(tag, _byteReader);
                                break;
                            }
                            case 97: {
                                this.value = new ArrayValue(tag, _byteReader);
                            }
                        }
                    }

                    public class AnnotationValue
                    extends Value {
                        AnnotationValue(int _tag, ByteReader _byteReader) {
                            super(_tag);
                        }
                    }

                    public class ClassValue
                    extends Value {
                        ClassValue(int _tag, ByteReader _byteReader) {
                            super(_tag);
                        }
                    }

                    public class ArrayValue
                    extends Value {
                        ArrayValue(int _tag, ByteReader _byteReader) {
                            super(_tag);
                        }
                    }

                    public class EnumValue
                    extends Value {
                        EnumValue(int _tag, ByteReader _byteReader) {
                            super(_tag);
                        }
                    }

                    public class PrimitiveValue
                    extends Value {
                        private final int typeNameIndex;
                        private final int constNameIndex;

                        public PrimitiveValue(int _tag, ByteReader _byteReader) {
                            super(_tag);
                            this.typeNameIndex = _byteReader.u2();
                            this.constNameIndex = 0;
                        }

                        public int getConstNameIndex() {
                            return this.constNameIndex;
                        }

                        public int getTypeNameIndex() {
                            return this.typeNameIndex;
                        }
                    }

                    class Value {
                        int tag;

                        Value(int _tag) {
                            this.tag = _tag;
                        }
                    }
                }
            }
        }

        public class SyntheticEntry
        extends AttributePoolEntry {
            public SyntheticEntry(ByteReader _byteReader, int _nameIndex, int _length) {
                super(_byteReader, _nameIndex, _length);
            }
        }

        public class SourceFileEntry
        extends AttributePoolEntry {
            private final int sourceFileIndex;

            public SourceFileEntry(ByteReader _byteReader, int _nameIndex, int _length) {
                super(_byteReader, _nameIndex, _length);
                this.sourceFileIndex = _byteReader.u2();
            }

            public int getSourceFileIndex() {
                return this.sourceFileIndex;
            }

            public String getSourceFileName() {
                return ClassModel.this.constantPool.getUTF8Entry(this.sourceFileIndex).getUTF8();
            }
        }

        public class LocalVariableTypeTableEntry
        extends AttributePoolEntry {
            private byte[] bytes;

            public LocalVariableTypeTableEntry(ByteReader _byteReader, int _nameIndex, int _length) {
                super(_byteReader, _nameIndex, _length);
                this.bytes = _byteReader.bytes(_length);
            }

            public byte[] getBytes() {
                return this.bytes;
            }

            public String toString() {
                return new String(this.bytes);
            }
        }

        class StackMapTableEntry
        extends AttributePoolEntry {
            private byte[] bytes;

            StackMapTableEntry(ByteReader _byteReader, int _nameIndex, int _length) {
                super(_byteReader, _nameIndex, _length);
                this.bytes = _byteReader.bytes(_length);
            }

            byte[] getBytes() {
                return this.bytes;
            }

            public String toString() {
                return new String(this.bytes);
            }
        }

        public class OtherEntry
        extends AttributePoolEntry {
            private final byte[] bytes;

            public OtherEntry(ByteReader _byteReader, int _nameIndex, int _length) {
                super(_byteReader, _nameIndex, _length);
                this.bytes = _byteReader.bytes(_length);
            }

            public byte[] getBytes() {
                return this.bytes;
            }

            public String toString() {
                return new String(this.bytes);
            }
        }

        class BootstrapMethodsEntry
        extends AttributePoolEntry {
            private int numBootstrapMethods;
            BootstrapMethod[] bootstrapMethods;

            BootstrapMethodsEntry(ByteReader _byteReader, int _nameIndex, int _length) {
                super(_byteReader, _nameIndex, _length);
                this.numBootstrapMethods = _byteReader.u2();
                this.bootstrapMethods = new BootstrapMethod[this.numBootstrapMethods];
                for (int i = 0; i < this.numBootstrapMethods; ++i) {
                    this.bootstrapMethods[i] = new BootstrapMethod(_byteReader);
                }
            }

            int getNumBootstrapMethods() {
                return this.numBootstrapMethods;
            }

            class BootstrapMethod {
                int bootstrapMethodRef;
                int numBootstrapArguments;
                BootstrapArgument[] bootstrapArguments;

                public BootstrapMethod(ByteReader _byteReader) {
                    this.bootstrapMethodRef = _byteReader.u2();
                    this.numBootstrapArguments = _byteReader.u2();
                    this.bootstrapArguments = new BootstrapArgument[this.numBootstrapArguments];
                    for (int i = 0; i < this.numBootstrapArguments; ++i) {
                        this.bootstrapArguments[i] = new BootstrapArgument(_byteReader);
                    }
                }

                class BootstrapArgument {
                    int argument;

                    public BootstrapArgument(ByteReader _byteReader) {
                        this.argument = _byteReader.u2();
                    }
                }
            }
        }

        public class RealLocalVariableTableEntry
        extends PoolEntry<RealLocalVariableInfo>
        implements LocalVariableTableEntry<RealLocalVariableInfo> {
            public RealLocalVariableTableEntry(ByteReader _byteReader, int _nameIndex, int _length) {
                super(_byteReader, _nameIndex, _length);
                int localVariableTableLength = _byteReader.u2();
                for (int i = 0; i < localVariableTableLength; ++i) {
                    this.getPool().add(new RealLocalVariableInfo(_byteReader));
                }
            }

            @Override
            public RealLocalVariableInfo getVariable(int _pc, int _index) {
                RealLocalVariableInfo returnValue = null;
                for (RealLocalVariableInfo localVariableInfo : this.getPool()) {
                    if (_pc < localVariableInfo.getStart() - 1 || _pc > localVariableInfo.getStart() + localVariableInfo.getLength() || _index != localVariableInfo.getVariableIndex()) continue;
                    returnValue = localVariableInfo;
                    break;
                }
                return returnValue;
            }

            public String getVariableName(int _pc, int _index) {
                String returnValue = "unknown";
                RealLocalVariableInfo localVariableInfo = this.getVariable(_pc, _index);
                if (localVariableInfo != null) {
                    returnValue = ClassModel.convert(ClassModel.this.constantPool.getUTF8Entry(localVariableInfo.getDescriptorIndex()).getUTF8(), ClassModel.this.constantPool.getUTF8Entry(localVariableInfo.getNameIndex()).getUTF8());
                }
                return returnValue;
            }

            class RealLocalVariableInfo
            implements LocalVariableInfo {
                private final int descriptorIndex;
                private final int usageLength;
                private final int variableNameIndex;
                private final int start;
                private final int variableIndex;

                public RealLocalVariableInfo(ByteReader _byteReader) {
                    this.start = _byteReader.u2();
                    this.usageLength = _byteReader.u2();
                    this.variableNameIndex = _byteReader.u2();
                    this.descriptorIndex = _byteReader.u2();
                    this.variableIndex = _byteReader.u2();
                }

                public int getDescriptorIndex() {
                    return this.descriptorIndex;
                }

                @Override
                public int getLength() {
                    return this.usageLength;
                }

                public int getNameIndex() {
                    return this.variableNameIndex;
                }

                @Override
                public int getStart() {
                    return this.start;
                }

                @Override
                public int getVariableIndex() {
                    return this.variableIndex;
                }

                @Override
                public String getVariableName() {
                    return ClassModel.this.constantPool.getUTF8Entry(this.variableNameIndex).getUTF8();
                }

                @Override
                public String getVariableDescriptor() {
                    return ClassModel.this.constantPool.getUTF8Entry(this.descriptorIndex).getUTF8();
                }

                @Override
                public int getEnd() {
                    return this.start + this.usageLength;
                }

                @Override
                public boolean isArray() {
                    return this.getVariableDescriptor().startsWith("[");
                }
            }
        }

        public class SignatureEntry
        extends AttributePoolEntry {
            private final int signatureIndex;

            public SignatureEntry(ByteReader _byteReader, int _nameIndex, int _length) {
                super(_byteReader, _nameIndex, _length);
                this.signatureIndex = _byteReader.u2();
            }

            int getSignatureIndex() {
                return this.signatureIndex;
            }
        }

        public class EnclosingMethodEntry
        extends AttributePoolEntry {
            private final int enclosingClassIndex;
            private final int enclosingMethodIndex;

            public EnclosingMethodEntry(ByteReader _byteReader, int _nameIndex, int _length) {
                super(_byteReader, _nameIndex, _length);
                this.enclosingClassIndex = _byteReader.u2();
                this.enclosingMethodIndex = _byteReader.u2();
            }

            public int getClassIndex() {
                return this.enclosingClassIndex;
            }

            public int getMethodIndex() {
                return this.enclosingMethodIndex;
            }
        }

        public class LineNumberTableEntry
        extends PoolEntry<StartLineNumberPair> {
            public LineNumberTableEntry(ByteReader _byteReader, int _nameIndex, int _length) {
                super(_byteReader, _nameIndex, _length);
                int lineNumberTableLength = _byteReader.u2();
                for (int i = 0; i < lineNumberTableLength; ++i) {
                    this.getPool().add(new StartLineNumberPair(_byteReader));
                }
            }

            public int getSourceLineNumber(int _start, boolean _exact) {
                Iterator i = this.getPool().iterator();
                if (i.hasNext()) {
                    StartLineNumberPair from = (StartLineNumberPair)i.next();
                    while (i.hasNext()) {
                        StartLineNumberPair to = (StartLineNumberPair)i.next();
                        if (_exact ? _start == from.getStart() : _start >= from.getStart() && _start < to.getStart()) {
                            return from.getLineNumber();
                        }
                        from = to;
                    }
                    if (_exact ? _start == from.getStart() : _start >= from.getStart()) {
                        return from.getLineNumber();
                    }
                }
                return -1;
            }

            public class StartLineNumberPair {
                private final int lineNumber;
                private final int start;

                public StartLineNumberPair(ByteReader _byteReader) {
                    this.start = _byteReader.u2();
                    this.lineNumber = _byteReader.u2();
                }

                public int getLineNumber() {
                    return this.lineNumber;
                }

                public int getStart() {
                    return this.start;
                }
            }
        }

        public class InnerClassesEntry
        extends PoolEntry<InnerClassInfo> {
            public InnerClassesEntry(ByteReader _byteReader, int _nameIndex, int _length) {
                super(_byteReader, _nameIndex, _length);
                int innerClassesTableLength = _byteReader.u2();
                for (int i = 0; i < innerClassesTableLength; ++i) {
                    this.getPool().add(new InnerClassInfo(_byteReader));
                }
            }

            public class InnerClassInfo {
                private final int innerAccess;
                private final int innerIndex;
                private final int innerNameIndex;
                private final int outerIndex;

                public InnerClassInfo(ByteReader _byteReader) {
                    this.innerIndex = _byteReader.u2();
                    this.outerIndex = _byteReader.u2();
                    this.innerNameIndex = _byteReader.u2();
                    this.innerAccess = _byteReader.u2();
                }

                public int getInnerAccess() {
                    return this.innerAccess;
                }

                public int getInnerIndex() {
                    return this.innerIndex;
                }

                public int getInnerNameIndex() {
                    return this.innerNameIndex;
                }

                public int getOuterIndex() {
                    return this.outerIndex;
                }
            }
        }

        public class ExceptionEntry
        extends PoolEntry<Integer> {
            public ExceptionEntry(ByteReader _byteReader, int _nameIndex, int _length) {
                super(_byteReader, _nameIndex, _length);
                int exceptionTableLength = _byteReader.u2();
                for (int i = 0; i < exceptionTableLength; ++i) {
                    this.getPool().add(_byteReader.u2());
                }
            }
        }

        public abstract class PoolEntry<T>
        extends AttributePoolEntry
        implements Iterable<T> {
            private final List<T> pool;

            public List<T> getPool() {
                return this.pool;
            }

            public PoolEntry(ByteReader _byteReader, int _nameIndex, int _length) {
                super(_byteReader, _nameIndex, _length);
                this.pool = new ArrayList<T>();
            }

            @Override
            public Iterator<T> iterator() {
                return this.pool.iterator();
            }
        }

        public abstract class AttributePoolEntry {
            protected int length;
            protected int nameIndex;

            public AttributePoolEntry(ByteReader _byteReader, int _nameIndex, int _length) {
                this.nameIndex = _nameIndex;
                this.length = _length;
            }

            public AttributePool getAttributePool() {
                return null;
            }

            public int getLength() {
                return this.length;
            }

            public String getName() {
                return ClassModel.this.constantPool.getUTF8Entry(this.nameIndex).getUTF8();
            }

            public int getNameIndex() {
                return this.nameIndex;
            }
        }

        public class DeprecatedEntry
        extends AttributePoolEntry {
            public DeprecatedEntry(ByteReader _byteReader, int _nameIndex, int _length) {
                super(_byteReader, _nameIndex, _length);
            }
        }

        public class ConstantValueEntry
        extends AttributePoolEntry {
            private final int index;

            public ConstantValueEntry(ByteReader _byteReader, int _nameIndex, int _length) {
                super(_byteReader, _nameIndex, _length);
                this.index = _byteReader.u2();
            }

            public int getIndex() {
                return this.index;
            }
        }

        public class CodeEntry
        extends AttributePoolEntry {
            private final List<ExceptionPoolEntry> exceptionPoolEntries;
            private final AttributePool codeEntryAttributePool;
            private final byte[] code;
            private final int maxLocals;
            private final int maxStack;

            public CodeEntry(ByteReader _byteReader, int _nameIndex, int _length) {
                super(_byteReader, _nameIndex, _length);
                this.exceptionPoolEntries = new ArrayList<ExceptionPoolEntry>();
                this.maxStack = _byteReader.u2();
                this.maxLocals = _byteReader.u2();
                int codeLength = _byteReader.u4();
                this.code = _byteReader.bytes(codeLength);
                int exceptionTableLength = _byteReader.u2();
                for (int i = 0; i < exceptionTableLength; ++i) {
                    this.exceptionPoolEntries.add(new ExceptionPoolEntry(_byteReader));
                }
                this.codeEntryAttributePool = new AttributePool(_byteReader, this.getName());
            }

            @Override
            public AttributePool getAttributePool() {
                return this.codeEntryAttributePool;
            }

            public LineNumberTableEntry getLineNumberTableEntry() {
                return this.codeEntryAttributePool.getLineNumberTableEntry();
            }

            public int getMaxLocals() {
                return this.maxLocals;
            }

            public int getMaxStack() {
                return this.maxStack;
            }

            public byte[] getCode() {
                return this.code;
            }

            public List<ExceptionPoolEntry> getExceptionPoolEntries() {
                return this.exceptionPoolEntries;
            }

            public class ExceptionPoolEntry {
                private final int exceptionClassIndex;
                private final int end;
                private final int handler;
                private final int start;

                public ExceptionPoolEntry(ByteReader _byteReader) {
                    this.start = _byteReader.u2();
                    this.end = _byteReader.u2();
                    this.handler = _byteReader.u2();
                    this.exceptionClassIndex = _byteReader.u2();
                }

                public ConstantPool.ClassEntry getClassEntry() {
                    return ClassModel.this.constantPool.getClassEntry(this.exceptionClassIndex);
                }

                public int getClassIndex() {
                    return this.exceptionClassIndex;
                }

                public int getEnd() {
                    return this.end;
                }

                public int getHandler() {
                    return this.handler;
                }

                public int getStart() {
                    return this.start;
                }
            }
        }
    }

    public class ConstantPool
    implements Iterable<Entry> {
        private final List<Entry> entries = new ArrayList<Entry>();

        public ConstantPool(ByteReader _byteReader) {
            int size = _byteReader.u2();
            this.add(new EmptyEntry(_byteReader, 0));
            block16: for (int i = 1; i < size; ++i) {
                ConstantPoolType constantPoolType = ConstantPoolType.values()[_byteReader.u1()];
                switch (constantPoolType) {
                    case UTF8: {
                        this.add(new UTF8Entry(_byteReader, i));
                        continue block16;
                    }
                    case INTEGER: {
                        this.add(new IntegerEntry(_byteReader, i));
                        continue block16;
                    }
                    case FLOAT: {
                        this.add(new FloatEntry(_byteReader, i));
                        continue block16;
                    }
                    case LONG: {
                        this.add(new LongEntry(_byteReader, i));
                        this.add(new EmptyEntry(_byteReader, ++i));
                        continue block16;
                    }
                    case DOUBLE: {
                        this.add(new DoubleEntry(_byteReader, i));
                        this.add(new EmptyEntry(_byteReader, ++i));
                        continue block16;
                    }
                    case CLASS: {
                        this.add(new ClassEntry(_byteReader, i));
                        continue block16;
                    }
                    case STRING: {
                        this.add(new StringEntry(_byteReader, i));
                        continue block16;
                    }
                    case FIELD: {
                        this.add(new FieldEntry(_byteReader, i));
                        continue block16;
                    }
                    case METHOD: {
                        this.add(new MethodEntry(_byteReader, i));
                        continue block16;
                    }
                    case INTERFACEMETHOD: {
                        this.add(new InterfaceMethodEntry(_byteReader, i));
                        continue block16;
                    }
                    case NAMEANDTYPE: {
                        this.add(new NameAndTypeEntry(_byteReader, i));
                        continue block16;
                    }
                    case METHODHANDLE: {
                        this.add(new MethodHandleEntry(_byteReader, i));
                        continue block16;
                    }
                    case METHODTYPE: {
                        this.add(new MethodTypeEntry(_byteReader, i));
                        continue block16;
                    }
                    case INVOKEDYNAMIC: {
                        this.add(new InvokeDynamicEntry(_byteReader, i));
                        continue block16;
                    }
                    default: {
                        System.out.printf("slot %04x unexpected Constant constantPoolType = %s\n", new Object[]{i, constantPoolType});
                    }
                }
            }
        }

        public ClassEntry getClassEntry(int _index) {
            try {
                return (ClassEntry)this.entries.get(_index);
            }
            catch (ClassCastException e) {
                return null;
            }
        }

        public DoubleEntry getDoubleEntry(int _index) {
            try {
                return (DoubleEntry)this.entries.get(_index);
            }
            catch (ClassCastException e) {
                return null;
            }
        }

        public FieldEntry getFieldEntry(int _index) {
            try {
                return (FieldEntry)this.entries.get(_index);
            }
            catch (ClassCastException e) {
                return null;
            }
        }

        FieldEntry getFieldEntry(String _name) {
            for (Entry entry : this.entries) {
                String fieldName;
                if (!(entry instanceof FieldEntry) || !_name.equals(fieldName = ((FieldEntry)entry).getNameAndTypeEntry().getNameUTF8Entry().getUTF8())) continue;
                return (FieldEntry)entry;
            }
            return null;
        }

        public FloatEntry getFloatEntry(int _index) {
            try {
                return (FloatEntry)this.entries.get(_index);
            }
            catch (ClassCastException e) {
                return null;
            }
        }

        public IntegerEntry getIntegerEntry(int _index) {
            try {
                return (IntegerEntry)this.entries.get(_index);
            }
            catch (ClassCastException e) {
                return null;
            }
        }

        public InterfaceMethodEntry getInterfaceMethodEntry(int _index) {
            try {
                return (InterfaceMethodEntry)this.entries.get(_index);
            }
            catch (ClassCastException e) {
                return null;
            }
        }

        public LongEntry getLongEntry(int _index) {
            try {
                return (LongEntry)this.entries.get(_index);
            }
            catch (ClassCastException e) {
                return null;
            }
        }

        public MethodEntry getMethodEntry(int _index) {
            try {
                return (MethodEntry)this.entries.get(_index);
            }
            catch (ClassCastException e) {
                return null;
            }
        }

        public NameAndTypeEntry getNameAndTypeEntry(int _index) {
            try {
                return (NameAndTypeEntry)this.entries.get(_index);
            }
            catch (ClassCastException e) {
                return null;
            }
        }

        public StringEntry getStringEntry(int _index) {
            try {
                return (StringEntry)this.entries.get(_index);
            }
            catch (ClassCastException e) {
                return null;
            }
        }

        public UTF8Entry getUTF8Entry(int _index) {
            try {
                return (UTF8Entry)this.entries.get(_index);
            }
            catch (ClassCastException e) {
                return null;
            }
        }

        public void add(Entry _entry) {
            this.entries.add(_entry);
        }

        @Override
        public Iterator<Entry> iterator() {
            return this.entries.iterator();
        }

        public Entry get(int _index) {
            return this.entries.get(_index);
        }

        public String getDescription(Entry _entry) {
            StringBuilder sb = new StringBuilder();
            if (!(_entry instanceof EmptyEntry)) {
                if (_entry instanceof DoubleEntry) {
                    DoubleEntry doubleEntry = (DoubleEntry)_entry;
                    sb.append(doubleEntry.getDoubleValue());
                } else if (_entry instanceof FloatEntry) {
                    FloatEntry floatEntry = (FloatEntry)_entry;
                    sb.append(floatEntry.getFloatValue());
                } else if (_entry instanceof IntegerEntry) {
                    IntegerEntry integerEntry = (IntegerEntry)_entry;
                    sb.append(integerEntry.getIntValue());
                } else if (_entry instanceof LongEntry) {
                    LongEntry longEntry = (LongEntry)_entry;
                    sb.append(longEntry.getLongValue());
                } else if (_entry instanceof UTF8Entry) {
                    UTF8Entry utf8Entry = (UTF8Entry)_entry;
                    sb.append(utf8Entry.getUTF8());
                } else if (_entry instanceof StringEntry) {
                    StringEntry stringEntry = (StringEntry)_entry;
                    UTF8Entry utf8Entry = (UTF8Entry)this.get(stringEntry.getUTF8Index());
                    sb.append(utf8Entry.getUTF8());
                } else if (_entry instanceof ClassEntry) {
                    ClassEntry classEntry = (ClassEntry)_entry;
                    UTF8Entry utf8Entry = (UTF8Entry)this.get(classEntry.getNameIndex());
                    sb.append(utf8Entry.getUTF8());
                } else if (_entry instanceof NameAndTypeEntry) {
                    NameAndTypeEntry nameAndTypeEntry = (NameAndTypeEntry)_entry;
                    UTF8Entry utf8NameEntry = (UTF8Entry)this.get(nameAndTypeEntry.getNameIndex());
                    UTF8Entry utf8DescriptorEntry = (UTF8Entry)this.get(nameAndTypeEntry.getDescriptorIndex());
                    sb.append(utf8NameEntry.getUTF8() + "." + utf8DescriptorEntry.getUTF8());
                } else if (_entry instanceof MethodEntry) {
                    MethodEntry methodEntry = (MethodEntry)_entry;
                    ClassEntry classEntry = (ClassEntry)this.get(methodEntry.getClassIndex());
                    UTF8Entry utf8Entry = (UTF8Entry)this.get(classEntry.getNameIndex());
                    NameAndTypeEntry nameAndTypeEntry = (NameAndTypeEntry)this.get(methodEntry.getNameAndTypeIndex());
                    UTF8Entry utf8NameEntry = (UTF8Entry)this.get(nameAndTypeEntry.getNameIndex());
                    UTF8Entry utf8DescriptorEntry = (UTF8Entry)this.get(nameAndTypeEntry.getDescriptorIndex());
                    sb.append(ClassModel.convert(utf8DescriptorEntry.getUTF8(), utf8Entry.getUTF8() + "." + utf8NameEntry.getUTF8()));
                } else if (_entry instanceof InterfaceMethodEntry) {
                    InterfaceMethodEntry interfaceMethodEntry = (InterfaceMethodEntry)_entry;
                    ClassEntry classEntry = (ClassEntry)this.get(interfaceMethodEntry.getClassIndex());
                    UTF8Entry utf8Entry = (UTF8Entry)this.get(classEntry.getNameIndex());
                    NameAndTypeEntry nameAndTypeEntry = (NameAndTypeEntry)this.get(interfaceMethodEntry.getNameAndTypeIndex());
                    UTF8Entry utf8NameEntry = (UTF8Entry)this.get(nameAndTypeEntry.getNameIndex());
                    UTF8Entry utf8DescriptorEntry = (UTF8Entry)this.get(nameAndTypeEntry.getDescriptorIndex());
                    sb.append(ClassModel.convert(utf8DescriptorEntry.getUTF8(), utf8Entry.getUTF8() + "." + utf8NameEntry.getUTF8()));
                } else if (_entry instanceof FieldEntry) {
                    FieldEntry fieldEntry = (FieldEntry)_entry;
                    ClassEntry classEntry = (ClassEntry)this.get(fieldEntry.getClassIndex());
                    UTF8Entry utf8Entry = (UTF8Entry)this.get(classEntry.getNameIndex());
                    NameAndTypeEntry nameAndTypeEntry = (NameAndTypeEntry)this.get(fieldEntry.getNameAndTypeIndex());
                    UTF8Entry utf8NameEntry = (UTF8Entry)this.get(nameAndTypeEntry.getNameIndex());
                    UTF8Entry utf8DescriptorEntry = (UTF8Entry)this.get(nameAndTypeEntry.getDescriptorIndex());
                    sb.append(ClassModel.convert(utf8DescriptorEntry.getUTF8(), utf8Entry.getUTF8() + "." + utf8NameEntry.getUTF8()));
                }
            }
            return sb.toString();
        }

        public int[] getConstantPoolReferences(Entry _entry) {
            int[] references = new int[]{};
            if (_entry instanceof StringEntry) {
                StringEntry stringEntry = (StringEntry)_entry;
                references = new int[]{stringEntry.getUTF8Index()};
            } else if (_entry instanceof ClassEntry) {
                ClassEntry classEntry = (ClassEntry)_entry;
                references = new int[]{classEntry.getNameIndex()};
            } else if (_entry instanceof NameAndTypeEntry) {
                NameAndTypeEntry nameAndTypeEntry = (NameAndTypeEntry)_entry;
                references = new int[]{nameAndTypeEntry.getNameIndex(), nameAndTypeEntry.getDescriptorIndex()};
            } else if (_entry instanceof MethodEntry) {
                MethodEntry methodEntry = (MethodEntry)_entry;
                ClassEntry classEntry = (ClassEntry)this.get(methodEntry.getClassIndex());
                UTF8Entry utf8Entry = (UTF8Entry)this.get(classEntry.getNameIndex());
                NameAndTypeEntry nameAndTypeEntry = (NameAndTypeEntry)this.get(methodEntry.getNameAndTypeIndex());
                UTF8Entry utf8NameEntry = (UTF8Entry)this.get(nameAndTypeEntry.getNameIndex());
                UTF8Entry utf8DescriptorEntry = (UTF8Entry)this.get(nameAndTypeEntry.getDescriptorIndex());
                references = new int[]{methodEntry.getClassIndex(), classEntry.getNameIndex(), nameAndTypeEntry.getNameIndex(), nameAndTypeEntry.getDescriptorIndex()};
            } else if (_entry instanceof InterfaceMethodEntry) {
                InterfaceMethodEntry interfaceMethodEntry = (InterfaceMethodEntry)_entry;
                ClassEntry classEntry = (ClassEntry)this.get(interfaceMethodEntry.getClassIndex());
                UTF8Entry utf8Entry = (UTF8Entry)this.get(classEntry.getNameIndex());
                NameAndTypeEntry nameAndTypeEntry = (NameAndTypeEntry)this.get(interfaceMethodEntry.getNameAndTypeIndex());
                UTF8Entry utf8NameEntry = (UTF8Entry)this.get(nameAndTypeEntry.getNameIndex());
                UTF8Entry utf8DescriptorEntry = (UTF8Entry)this.get(nameAndTypeEntry.getDescriptorIndex());
                references = new int[]{interfaceMethodEntry.getClassIndex(), classEntry.getNameIndex(), nameAndTypeEntry.getNameIndex(), nameAndTypeEntry.getDescriptorIndex()};
            } else if (_entry instanceof FieldEntry) {
                FieldEntry fieldEntry = (FieldEntry)_entry;
                ClassEntry classEntry = (ClassEntry)this.get(fieldEntry.getClassIndex());
                UTF8Entry utf8Entry = (UTF8Entry)this.get(classEntry.getNameIndex());
                NameAndTypeEntry nameAndTypeEntry = (NameAndTypeEntry)this.get(fieldEntry.getNameAndTypeIndex());
                UTF8Entry utf8NameEntry = (UTF8Entry)this.get(nameAndTypeEntry.getNameIndex());
                UTF8Entry utf8DescriptorEntry = (UTF8Entry)this.get(nameAndTypeEntry.getDescriptorIndex());
                references = new int[]{fieldEntry.getClassIndex(), classEntry.getNameIndex(), nameAndTypeEntry.getNameIndex(), nameAndTypeEntry.getDescriptorIndex()};
            }
            return references;
        }

        public String getType(Entry _entry) {
            StringBuffer sb = new StringBuffer();
            if (_entry instanceof EmptyEntry) {
                sb.append("empty");
            } else if (_entry instanceof DoubleEntry) {
                sb.append("double");
            } else if (_entry instanceof FloatEntry) {
                sb.append("float");
            } else if (_entry instanceof IntegerEntry) {
                sb.append("int");
            } else if (_entry instanceof LongEntry) {
                sb.append("long");
            } else if (_entry instanceof UTF8Entry) {
                sb.append("utf8");
            } else if (_entry instanceof StringEntry) {
                sb.append("string");
            } else if (_entry instanceof ClassEntry) {
                sb.append("class");
            } else if (_entry instanceof NameAndTypeEntry) {
                sb.append("name/type");
            } else if (_entry instanceof MethodEntry) {
                sb.append("method");
            } else if (_entry instanceof InterfaceMethodEntry) {
                sb.append("interface method");
            } else if (_entry instanceof FieldEntry) {
                sb.append("field");
            }
            return sb.toString();
        }

        public Object getConstantEntry(int _constantPoolIndex) {
            Entry entry = this.get(_constantPoolIndex);
            Object object = null;
            switch (entry.getConstantPoolType()) {
                case FLOAT: {
                    object = Float.valueOf(((FloatEntry)entry).getFloatValue());
                    break;
                }
                case DOUBLE: {
                    object = ((DoubleEntry)entry).getDoubleValue();
                    break;
                }
                case INTEGER: {
                    object = ((IntegerEntry)entry).getIntValue();
                    break;
                }
                case LONG: {
                    object = ((LongEntry)entry).getLongValue();
                    break;
                }
                case STRING: {
                    object = ((StringEntry)entry).getStringUTF8Entry().getUTF8();
                }
            }
            return object;
        }

        public class UTF8Entry
        extends Entry {
            private final String UTF8;

            public UTF8Entry(ByteReader _byteReader, int _slot) {
                super(_byteReader, _slot, ConstantPoolType.UTF8);
                this.UTF8 = _byteReader.utf8();
            }

            public String getUTF8() {
                return this.UTF8;
            }
        }

        public class StringEntry
        extends Entry {
            private final int utf8Index;

            public StringEntry(ByteReader _byteReader, int _slot) {
                super(_byteReader, _slot, ConstantPoolType.STRING);
                this.utf8Index = _byteReader.u2();
            }

            public int getUTF8Index() {
                return this.utf8Index;
            }

            public UTF8Entry getStringUTF8Entry() {
                return ConstantPool.this.getUTF8Entry(this.utf8Index);
            }
        }

        public abstract class ReferenceEntry
        extends Entry {
            protected int referenceClassIndex;
            protected int nameAndTypeIndex;
            protected int argCount;

            public ReferenceEntry(ByteReader _byteReader, int _slot, ConstantPoolType _constantPoolType) {
                super(_byteReader, _slot, _constantPoolType);
                this.argCount = -1;
                this.referenceClassIndex = _byteReader.u2();
                this.nameAndTypeIndex = _byteReader.u2();
            }

            public ClassEntry getClassEntry() {
                return ConstantPool.this.getClassEntry(this.referenceClassIndex);
            }

            public int getClassIndex() {
                return this.referenceClassIndex;
            }

            public NameAndTypeEntry getNameAndTypeEntry() {
                return ConstantPool.this.getNameAndTypeEntry(this.nameAndTypeIndex);
            }

            public int getNameAndTypeIndex() {
                return this.nameAndTypeIndex;
            }

            public boolean same(Entry _entry) {
                if (_entry instanceof ReferenceEntry) {
                    ReferenceEntry entry = (ReferenceEntry)_entry;
                    return this.referenceClassIndex == entry.referenceClassIndex && this.nameAndTypeIndex == entry.nameAndTypeIndex;
                }
                return false;
            }

            public class Type {
                private int arrayDimensions = 0;
                private String type;

                public Type(String _type) {
                    this.type = _type;
                    while (this.type.charAt(this.arrayDimensions) == '[') {
                        ++this.arrayDimensions;
                    }
                    this.type = this.type.substring(this.arrayDimensions);
                }

                public String getType() {
                    return this.type;
                }

                public boolean isVoid() {
                    return this.type.equals("V");
                }

                public boolean isArray() {
                    return this.arrayDimensions > 0;
                }

                public int getArrayDimensions() {
                    return this.arrayDimensions;
                }
            }
        }

        public abstract class MethodReferenceEntry
        extends ReferenceEntry {
            private Arg[] args;
            private ReferenceEntry.Type returnType;

            public int hashCode() {
                NameAndTypeEntry nameAndTypeEntry = this.getNameAndTypeEntry();
                return (nameAndTypeEntry.getNameIndex() * 31 + nameAndTypeEntry.getDescriptorIndex()) * 31 + this.getClassIndex();
            }

            public boolean equals(Object _other) {
                if (_other == null || !(_other instanceof MethodReferenceEntry)) {
                    return false;
                }
                MethodReferenceEntry otherMethodReferenceEntry = (MethodReferenceEntry)_other;
                return otherMethodReferenceEntry.getNameAndTypeEntry().getNameIndex() == this.getNameAndTypeEntry().getNameIndex() && otherMethodReferenceEntry.getNameAndTypeEntry().getDescriptorIndex() == this.getNameAndTypeEntry().getDescriptorIndex() && otherMethodReferenceEntry.getClassIndex() == this.getClassIndex();
            }

            public MethodReferenceEntry(ByteReader byteReader, int slot, ConstantPoolType constantPoolType) {
                super(byteReader, slot, constantPoolType);
                this.args = null;
                this.returnType = null;
            }

            public int getStackProduceCount() {
                return this.getReturnType().isVoid() ? 0 : 1;
            }

            public ReferenceEntry.Type getReturnType() {
                if (this.returnType == null) {
                    this.getArgs();
                }
                return this.returnType;
            }

            public Arg[] getArgs() {
                if (this.args == null || this.returnType == null) {
                    ArrayList<Arg> argList = new ArrayList<Arg>();
                    NameAndTypeEntry nameAndTypeEntry = this.getNameAndTypeEntry();
                    String signature = nameAndTypeEntry.getDescriptorUTF8Entry().getUTF8();
                    SignatureParseState state = SignatureParseState.skipping;
                    int start = 0;
                    int pos = 0;
                    while (state != SignatureParseState.done) {
                        char ch = signature.charAt(pos);
                        switch (ch) {
                            case '(': {
                                state = SignatureParseState.counting;
                                break;
                            }
                            case ')': {
                                state = SignatureParseState.done;
                                this.returnType = new ReferenceEntry.Type(signature.substring(pos + 1));
                                break;
                            }
                            case '[': {
                                switch (state) {
                                    case counting: {
                                        state = SignatureParseState.inArray;
                                        start = pos;
                                    }
                                }
                                break;
                            }
                            case 'L': {
                                switch (state) {
                                    case counting: {
                                        start = pos;
                                    }
                                    case inArray: {
                                        state = SignatureParseState.inclass;
                                    }
                                }
                                break;
                            }
                            case ';': {
                                switch (state) {
                                    case inclass: {
                                        argList.add(new Arg(signature, start, pos, argList.size()));
                                        state = SignatureParseState.counting;
                                    }
                                }
                                break;
                            }
                            default: {
                                switch (state) {
                                    case counting: {
                                        start = pos;
                                    }
                                    case inArray: {
                                        argList.add(new Arg(signature, start, pos, argList.size()));
                                    }
                                }
                            }
                        }
                        ++pos;
                    }
                    this.args = argList.toArray(new Arg[0]);
                }
                return this.args;
            }

            public int getStackConsumeCount() {
                return this.getArgs().length;
            }

            public class Arg
            extends ReferenceEntry.Type {
                private final int argc;

                Arg(String _signature, int _start, int _pos, int _argc) {
                    super(_signature.substring(_start, _pos + 1));
                    this.argc = _argc;
                }

                int getArgc() {
                    return this.argc;
                }
            }
        }

        class InvokeDynamicEntry
        extends Entry {
            private int bootstrapMethodAttrIndex;
            private int nameAndTypeIndex;

            InvokeDynamicEntry(ByteReader _byteReader, int _slot) {
                super(_byteReader, _slot, ConstantPoolType.INVOKEDYNAMIC);
                this.bootstrapMethodAttrIndex = _byteReader.u2();
                this.nameAndTypeIndex = _byteReader.u2();
            }

            int getBootstrapMethodAttrIndex() {
                return this.bootstrapMethodAttrIndex;
            }

            int getNameAndTypeIndex() {
                return this.nameAndTypeIndex;
            }
        }

        class MethodHandleEntry
        extends Entry {
            private int referenceKind;
            private int referenceIndex;

            MethodHandleEntry(ByteReader _byteReader, int _slot) {
                super(_byteReader, _slot, ConstantPoolType.METHODHANDLE);
                this.referenceKind = _byteReader.u1();
                this.referenceIndex = _byteReader.u2();
            }

            int getReferenceIndex() {
                return this.referenceIndex;
            }

            int getReferenceKind() {
                return this.referenceKind;
            }
        }

        class MethodTypeEntry
        extends Entry {
            private int descriptorIndex;

            MethodTypeEntry(ByteReader _byteReader, int _slot) {
                super(_byteReader, _slot, ConstantPoolType.METHODTYPE);
                this.descriptorIndex = _byteReader.u2();
            }

            int getDescriptorIndex() {
                return this.descriptorIndex;
            }

            UTF8Entry getDescriptorUTF8Entry() {
                return ConstantPool.this.getUTF8Entry(this.descriptorIndex);
            }
        }

        public class NameAndTypeEntry
        extends Entry {
            private final int descriptorIndex;
            private final int nameIndex;

            public NameAndTypeEntry(ByteReader _byteReader, int _slot) {
                super(_byteReader, _slot, ConstantPoolType.NAMEANDTYPE);
                this.nameIndex = _byteReader.u2();
                this.descriptorIndex = _byteReader.u2();
            }

            public int getDescriptorIndex() {
                return this.descriptorIndex;
            }

            public UTF8Entry getDescriptorUTF8Entry() {
                return ConstantPool.this.getUTF8Entry(this.descriptorIndex);
            }

            public int getNameIndex() {
                return this.nameIndex;
            }

            public UTF8Entry getNameUTF8Entry() {
                return ConstantPool.this.getUTF8Entry(this.nameIndex);
            }
        }

        public class MethodEntry
        extends MethodReferenceEntry {
            public MethodEntry(ByteReader _byteReader, int _slot) {
                super(_byteReader, _slot, ConstantPoolType.METHOD);
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append(this.getClassEntry().getNameUTF8Entry().getUTF8());
                sb.append(".");
                sb.append(this.getNameAndTypeEntry().getNameUTF8Entry().getUTF8());
                sb.append(this.getNameAndTypeEntry().getDescriptorUTF8Entry().getUTF8());
                return sb.toString();
            }
        }

        public class LongEntry
        extends Entry {
            private final long longValue;

            public LongEntry(ByteReader _byteReader, int _slot) {
                super(_byteReader, _slot, ConstantPoolType.LONG);
                this.longValue = _byteReader.u8();
            }

            public long getLongValue() {
                return this.longValue;
            }
        }

        public class InterfaceMethodEntry
        extends MethodReferenceEntry {
            InterfaceMethodEntry(ByteReader _byteReader, int _slot) {
                super(_byteReader, _slot, ConstantPoolType.INTERFACEMETHOD);
            }
        }

        public class IntegerEntry
        extends Entry {
            private final int intValue;

            public IntegerEntry(ByteReader _byteReader, int _slot) {
                super(_byteReader, _slot, ConstantPoolType.INTEGER);
                this.intValue = _byteReader.u4();
            }

            public int getIntValue() {
                return this.intValue;
            }
        }

        public class FloatEntry
        extends Entry {
            private final float floatValue;

            public FloatEntry(ByteReader _byteReader, int _slot) {
                super(_byteReader, _slot, ConstantPoolType.FLOAT);
                this.floatValue = _byteReader.f4();
            }

            public float getFloatValue() {
                return this.floatValue;
            }
        }

        public class FieldEntry
        extends ReferenceEntry {
            public FieldEntry(ByteReader _byteReader, int _slot) {
                super(_byteReader, _slot, ConstantPoolType.FIELD);
            }
        }

        public class EmptyEntry
        extends Entry {
            public EmptyEntry(ByteReader _byteReader, int _slot) {
                super(_byteReader, _slot, ConstantPoolType.EMPTY);
            }
        }

        public class DoubleEntry
        extends Entry {
            private final double doubleValue;

            public DoubleEntry(ByteReader _byteReader, int _slot) {
                super(_byteReader, _slot, ConstantPoolType.DOUBLE);
                this.doubleValue = _byteReader.d8();
            }

            public double getDoubleValue() {
                return this.doubleValue;
            }
        }

        public class ClassEntry
        extends Entry {
            private final int nameIndex;

            public ClassEntry(ByteReader _byteReader, int _slot) {
                super(_byteReader, _slot, ConstantPoolType.CLASS);
                this.nameIndex = _byteReader.u2();
            }

            public int getNameIndex() {
                return this.nameIndex;
            }

            public UTF8Entry getNameUTF8Entry() {
                return ConstantPool.this.getUTF8Entry(this.nameIndex);
            }
        }

        public abstract class Entry {
            private final ConstantPoolType constantPoolType;
            private final int slot;

            public Entry(ByteReader _byteReader, int _slot, ConstantPoolType _constantPoolType) {
                this.constantPoolType = _constantPoolType;
                this.slot = _slot;
            }

            public ConstantPoolType getConstantPoolType() {
                return this.constantPoolType;
            }

            public int getSlot() {
                return this.slot;
            }

            public ClassModel getOwnerClassModel() {
                return ClassModel.this;
            }
        }
    }

    private static enum SignatureParseState {
        skipping,
        counting,
        inclass,
        inArray,
        done;

    }

    public static enum Access {
        PUBLIC(1),
        PRIVATE(2),
        PROTECTED(4),
        STATIC(8),
        FINAL(16),
        ACC_SYNCHRONIZED(32),
        ACC_VOLATILE(64),
        BRIDGE(64),
        TRANSIENT(128),
        VARARGS(128),
        NATIVE(256),
        INTERFACE(512),
        ABSTRACT(1024),
        SUPER(32),
        STRICT(2048),
        ANNOTATION(8192),
        ACC_ENUM(16384);

        int bits;

        private Access(int _bits) {
            this.bits = _bits;
        }

        public boolean bitIsSet(int _accessFlags) {
            return (this.bits & _accessFlags) == this.bits;
        }

        public String convert(int _accessFlags) {
            StringBuffer stringBuffer = new StringBuffer();
            for (Access access : Access.values()) {
                if (!access.bitIsSet(_accessFlags)) continue;
                stringBuffer.append(" " + access.name().toLowerCase());
            }
            return stringBuffer.toString();
        }
    }

    public static enum ConstantPoolType {
        EMPTY,
        UTF8,
        UNICODE,
        INTEGER,
        FLOAT,
        LONG,
        DOUBLE,
        CLASS,
        STRING,
        FIELD,
        METHOD,
        INTERFACEMETHOD,
        NAMEANDTYPE,
        UNUSED13,
        UNUSED14,
        METHODHANDLE,
        METHODTYPE,
        UNUSED17,
        INVOKEDYNAMIC;

    }

    public static class MethodDescription {
        private final String className;
        private final String methodName;
        private final String type;
        private final String[] args;

        public MethodDescription(String _className, String _methodName, String _type, String[] _args) {
            this.methodName = _methodName;
            this.className = _className;
            this.type = _type;
            this.args = _args;
        }

        public String[] getArgs() {
            return this.args;
        }

        public String getType() {
            return this.type;
        }

        public String getClassName() {
            return this.className;
        }

        public String getMethodName() {
            return this.methodName;
        }
    }

    public static interface LocalVariableTableEntry<T extends LocalVariableInfo>
    extends Iterable<T> {
        public LocalVariableInfo getVariable(int var1, int var2);
    }

    public static interface LocalVariableInfo {
        public int getStart();

        public boolean isArray();

        public int getEnd();

        public String getVariableName();

        public String getVariableDescriptor();

        public int getVariableIndex();

        public int getLength();
    }
}

