/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi.internal.kernel;

import com.aparapi.Config;
import com.aparapi.Kernel;
import com.aparapi.device.Device;
import com.aparapi.internal.kernel.KernelDeviceProfile;
import com.aparapi.internal.kernel.ProfilingEvent;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class KernelProfile {
    private static final double MILLION = 1000000.0;
    private static Logger logger = Logger.getLogger(Config.getLoggerName());
    private final Class<? extends Kernel> kernelClass;
    private LinkedHashMap<Device, KernelDeviceProfile> deviceProfiles = new LinkedHashMap();
    private Device currentDevice;
    private Device lastDevice;
    private KernelDeviceProfile currentDeviceProfile;

    public KernelProfile(Class<? extends Kernel> _kernelClass) {
        this.kernelClass = _kernelClass;
    }

    public double getLastExecutionTime() {
        KernelDeviceProfile lastDeviceProfile = this.getLastDeviceProfile();
        return lastDeviceProfile == null ? Double.NaN : lastDeviceProfile.getLastElapsedTime(ProfilingEvent.START, ProfilingEvent.EXECUTED) / 1000000.0;
    }

    public double getLastConversionTime() {
        KernelDeviceProfile lastDeviceProfile = this.getLastDeviceProfile();
        return lastDeviceProfile == null ? Double.NaN : lastDeviceProfile.getLastElapsedTime(ProfilingEvent.START, ProfilingEvent.PREPARE_EXECUTE) / 1000000.0;
    }

    public double getAccumulatedTotalTime() {
        KernelDeviceProfile lastDeviceProfile = this.getLastDeviceProfile();
        if (lastDeviceProfile == null) {
            return Double.NaN;
        }
        return lastDeviceProfile.getCumulativeElapsedTimeAll() / 1000000.0;
    }

    public KernelDeviceProfile getLastDeviceProfile() {
        return this.deviceProfiles.get(this.currentDevice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onStart(Device device) {
        this.currentDevice = device;
        LinkedHashMap<Device, KernelDeviceProfile> linkedHashMap = this.deviceProfiles;
        synchronized (linkedHashMap) {
            this.currentDeviceProfile = this.deviceProfiles.get(device);
            if (this.currentDeviceProfile == null) {
                this.currentDeviceProfile = new KernelDeviceProfile(this.kernelClass, device);
                this.deviceProfiles.put(device, this.currentDeviceProfile);
            }
        }
        this.currentDeviceProfile.onEvent(ProfilingEvent.START);
    }

    void onEvent(ProfilingEvent event) {
        switch (event) {
            case CLASS_MODEL_BUILT: 
            case OPENCL_GENERATED: 
            case INIT_JNI: 
            case OPENCL_COMPILED: 
            case PREPARE_EXECUTE: 
            case EXECUTED: {
                if (this.currentDeviceProfile == null) {
                    logger.log(Level.SEVERE, "Error in KernelProfile, no currentDevice (synchronization error?");
                }
                this.currentDeviceProfile.onEvent(event);
                break;
            }
            case START: {
                throw new IllegalArgumentException("must use onStart(Device) to start profiling");
            }
            default: {
                throw new IllegalArgumentException("Unhandled event " + (Object)((Object)event));
            }
        }
    }

    void onFinishedExecution() {
        this.reset();
    }

    private void reset() {
        this.lastDevice = this.currentDevice;
        this.currentDevice = null;
        this.currentDeviceProfile = null;
    }

    public Collection<Device> getDevices() {
        return this.deviceProfiles.keySet();
    }

    public Collection<KernelDeviceProfile> getDeviceProfiles() {
        return this.deviceProfiles.values();
    }

    public KernelDeviceProfile getDeviceProfile(Device device) {
        return this.deviceProfiles.get(device);
    }
}

