/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi.internal.kernel;

import com.aparapi.Kernel;
import com.aparapi.device.Device;
import com.aparapi.internal.kernel.KernelManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

public class KernelPreferences {
    private final Class<? extends Kernel> kernelClass;
    private final KernelManager manager;
    private volatile LinkedList<Device> preferredDevices = null;
    private final LinkedHashSet<Device> failedDevices = new LinkedHashSet();

    public KernelPreferences(KernelManager manager, Class<? extends Kernel> kernelClass) {
        this.kernelClass = kernelClass;
        this.manager = manager;
    }

    public Class<? extends Kernel> getKernelClass() {
        return this.kernelClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Device> getPreferredDevices(Kernel kernel) {
        ArrayList<Device> copy;
        this.maybeSetUpDefaultPreferredDevices();
        if (kernel == null) {
            return Collections.unmodifiableList(this.preferredDevices);
        }
        ArrayList<Device> localPreferredDevices = new ArrayList<Device>();
        LinkedList<Device> linkedList = this.preferredDevices;
        synchronized (linkedList) {
            copy = new ArrayList<Device>(this.preferredDevices);
        }
        for (Device device : copy) {
            if (!kernel.isAllowDevice(device)) continue;
            localPreferredDevices.add(device);
        }
        return Collections.unmodifiableList(localPreferredDevices);
    }

    synchronized void setPreferredDevices(LinkedHashSet<Device> _preferredDevices) {
        if (this.preferredDevices != null) {
            this.preferredDevices.clear();
            this.preferredDevices.addAll(_preferredDevices);
        } else {
            this.preferredDevices = new LinkedList<Device>(_preferredDevices);
        }
        this.failedDevices.clear();
    }

    public Device getPreferredDevice(Kernel kernel) {
        List<Device> localPreferredDevices = this.getPreferredDevices(kernel);
        return localPreferredDevices.isEmpty() ? null : localPreferredDevices.get(0);
    }

    synchronized void markPreferredDeviceFailed() {
        if (this.preferredDevices.size() > 0) {
            this.failedDevices.add(this.preferredDevices.remove(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeSetUpDefaultPreferredDevices() {
        if (this.preferredDevices == null) {
            KernelPreferences kernelPreferences = this;
            synchronized (kernelPreferences) {
                if (this.preferredDevices == null) {
                    this.preferredDevices = new LinkedList<Device>(this.manager.getDefaultPreferences().getPreferredDevices(null));
                }
            }
        }
    }

    public List<Device> getFailedDevices() {
        return new ArrayList<Device>(this.failedDevices);
    }
}

