/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi.internal.kernel;

import com.aparapi.Config;
import com.aparapi.Kernel;
import com.aparapi.device.Device;
import com.aparapi.internal.kernel.ProfilingEvent;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class KernelDeviceProfile {
    private static Logger logger = Logger.getLogger(Config.getLoggerName());
    private static final double MILLION = 1000000.0;
    private static final int TABLE_COLUMN_HEADER_WIDTH = 21;
    private static final int TABLE_COLUMN_COUNT_WIDTH = 8;
    private static final int TABLE_COLUMN_WIDTH;
    private static String tableHeader;
    private final Class<? extends Kernel> kernel;
    private final Device device;
    private long[] currentTimes = new long[ProfilingEvent.values().length];
    private long[] accumulatedTimes = new long[ProfilingEvent.values().length];
    private ProfilingEvent lastEvent = null;
    private final DecimalFormat format;
    private long invocationCount = 0L;

    public KernelDeviceProfile(Class<? extends Kernel> kernel, Device device) {
        this.kernel = kernel;
        this.device = device;
        this.format = (DecimalFormat)DecimalFormat.getNumberInstance();
        this.format.setMinimumFractionDigits(3);
        this.format.setMaximumFractionDigits(3);
    }

    public void onEvent(ProfilingEvent event) {
        int i;
        if (event == ProfilingEvent.START) {
            if (this.lastEvent != null) {
                logger.log(Level.SEVERE, "ProfilingEvent.START encountered without ProfilingEvent.EXECUTED");
            } else if (this.lastEvent == ProfilingEvent.START) {
                logger.log(Level.SEVERE, "Duplicate event ProfilingEvent.START");
            }
            Arrays.fill(this.currentTimes, 0L);
            ++this.invocationCount;
        } else if (this.lastEvent == null) {
            if (event != ProfilingEvent.EXECUTED) {
                logger.log(Level.SEVERE, "ProfilingEvent.START was not invoked prior to ProfilingEvent." + (Object)((Object)event));
            }
        } else {
            for (i = this.lastEvent.ordinal() + 1; i < event.ordinal(); ++i) {
                this.currentTimes[i] = this.currentTimes[i - 1];
            }
        }
        this.currentTimes[event.ordinal()] = System.nanoTime();
        if (event == ProfilingEvent.EXECUTED) {
            i = 1;
            while (i < this.currentTimes.length) {
                long elapsed = this.currentTimes[i] - this.currentTimes[i - 1];
                if (elapsed < 0L) {
                    logger.log(Level.SEVERE, "negative elapsed time for event " + (Object)((Object)event));
                    break;
                }
                int n = i++;
                this.accumulatedTimes[n] = this.accumulatedTimes[n] + elapsed;
            }
        }
        this.lastEvent = event;
        if (event == ProfilingEvent.EXECUTED) {
            this.lastEvent = null;
        }
    }

    public double getLastElapsedTime(ProfilingEvent stage) {
        if (stage == ProfilingEvent.START) {
            return 0.0;
        }
        return (double)(this.currentTimes[stage.ordinal()] - this.currentTimes[stage.ordinal() - 1]) / 1000000.0;
    }

    public double getLastElapsedTime(ProfilingEvent from, ProfilingEvent to) {
        return (double)(this.currentTimes[to.ordinal()] - this.currentTimes[from.ordinal()]) / 1000000.0;
    }

    public double getCumulativeElapsedTime(ProfilingEvent stage) {
        return (double)this.accumulatedTimes[stage.ordinal()] / 1000000.0;
    }

    public double getCumulativeElapsedTimeAll() {
        double sum = 0.0;
        for (int i = 1; i <= ProfilingEvent.EXECUTED.ordinal(); ++i) {
            sum += (double)this.accumulatedTimes[i];
        }
        return sum;
    }

    public static synchronized String getTableHeader() {
        if (tableHeader == null) {
            int length = ProfilingEvent.values().length;
            StringBuilder builder = new StringBuilder(150);
            KernelDeviceProfile.appendRowHeaders(builder, "Device", "Count");
            for (int i = 1; i < length; ++i) {
                ProfilingEvent stage = ProfilingEvent.values()[i];
                String heading = stage.name();
                KernelDeviceProfile.appendCell(builder, heading);
            }
            builder.append("  ").append("Total");
            tableHeader = builder.toString();
        }
        return tableHeader;
    }

    public String getLastAsTableRow() {
        double total = 0.0;
        StringBuilder builder = new StringBuilder(150);
        KernelDeviceProfile.appendRowHeaders(builder, this.device.getShortDescription(), String.valueOf(this.invocationCount));
        for (int i = 1; i < this.currentTimes.length; ++i) {
            ProfilingEvent stage = ProfilingEvent.values()[i];
            double time = this.getLastElapsedTime(stage);
            total += time;
            String formatted = this.format.format(time);
            KernelDeviceProfile.appendCell(builder, formatted);
        }
        builder.append("  ").append(this.format.format(total));
        return builder.toString();
    }

    public String getCumulativeAsTableRow() {
        return this.internalCumulativeAsTableRow(false);
    }

    public String getAverageAsTableRow() {
        return this.internalCumulativeAsTableRow(true);
    }

    private String internalCumulativeAsTableRow(boolean mean) {
        double total = 0.0;
        double count = mean ? (double)this.invocationCount : 1.0;
        StringBuilder builder = new StringBuilder(150);
        KernelDeviceProfile.appendRowHeaders(builder, this.device.getShortDescription(), String.valueOf(this.invocationCount));
        for (int i = 1; i < this.currentTimes.length; ++i) {
            ProfilingEvent stage = ProfilingEvent.values()[i];
            double time = this.getCumulativeElapsedTime(stage);
            if (mean) {
                time /= count;
            }
            total += time;
            String formatted = this.format.format(time);
            KernelDeviceProfile.appendCell(builder, formatted);
        }
        builder.append("  ").append(this.format.format(total));
        return builder.toString();
    }

    private static void appendRowHeaders(StringBuilder builder, String device, String count) {
        int i;
        if (device.length() > 20) {
            device = device.substring(0, 20);
        }
        builder.append(device);
        int padding = 21 - device.length();
        for (i = 0; i < padding; ++i) {
            builder.append(' ');
        }
        builder.append(count);
        padding = 8 - count.length();
        for (i = 0; i < padding; ++i) {
            builder.append(' ');
        }
    }

    private static void appendCell(StringBuilder builder, String cell) {
        int padding = TABLE_COLUMN_WIDTH - cell.length();
        for (int paddingIndex = 0; paddingIndex < padding; ++paddingIndex) {
            builder.append(' ');
        }
        builder.append(cell);
    }

    public String toString() {
        return "KernelDeviceProfile{" + this.kernel.toString() + ", " + this.device.getShortDescription() + "}";
    }

    static {
        tableHeader = null;
        assert (ProfilingEvent.START.ordinal() == 0) : "ProfilingEvent.START.ordinal() != 0";
        int max = 0;
        for (ProfilingEvent event : ProfilingEvent.values()) {
            max = Math.max(max, event.name().length());
        }
        TABLE_COLUMN_WIDTH = max + 1;
    }
}

