/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi.internal.instruction;

import com.aparapi.internal.instruction.BranchSet;
import com.aparapi.internal.instruction.Instruction;
import com.aparapi.internal.model.ClassModel;
import com.aparapi.internal.model.MethodModel;
import com.aparapi.internal.reader.ByteReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class InstructionSet {

    public static class FakeGoto
    extends UnconditionalBranch {
        public FakeGoto(MethodModel _methodPoolEntry, Instruction _target) {
            super(_methodPoolEntry, ByteCode.FAKEGOTO, _target);
        }

        @Override
        public String getDescription() {
            return "FAKE goto";
        }
    }

    public static class MultiAssignInstruction
    extends Instruction {
        private final Instruction from;
        private final Instruction to;
        private final Instruction common;

        public MultiAssignInstruction(MethodModel method, Instruction _common, Instruction _from, Instruction _to) {
            super(method, ByteCode.MULTI_ASSIGN, -1);
            this.common = _common;
            this.from = _from;
            this.to = _to;
        }

        @Override
        public String getDescription() {
            return "MULTIASSIGN! " + (Object)((Object)this.getByteCode());
        }

        public Instruction getTo() {
            return this.to;
        }

        public Instruction getFrom() {
            return this.from;
        }

        public Instruction getCommon() {
            return this.common;
        }
    }

    public static class FieldArrayElementIncrement
    extends Instruction {
        private final AssignToArrayElement assignToArrayElement;
        private final boolean isPre;
        private final boolean isInc;

        public FieldArrayElementIncrement(MethodModel method, AssignToArrayElement _assignToArrayElement, boolean _isInc, boolean _isPre) {
            super(method, ByteCode.FIELD_ARRAY_ELEMENT_INCREMENT, -1);
            this.assignToArrayElement = _assignToArrayElement;
            this.isPre = _isPre;
            this.isInc = _isInc;
        }

        @Override
        public String getDescription() {
            return "FIELD ARRAY ELEMENT INCREMENT! " + (Object)((Object)this.getByteCode());
        }

        public AssignToArrayElement getAssignToArrayElement() {
            return this.assignToArrayElement;
        }

        public boolean isPre() {
            return this.isPre;
        }

        public boolean isInc() {
            return this.isInc;
        }
    }

    public static class FieldArrayElementAssign
    extends Instruction {
        private final AssignToArrayElement assignToArrayElement;
        private final Instruction rhs;

        public FieldArrayElementAssign(MethodModel method, AssignToArrayElement _assignToArrayElement, Instruction _rhs) {
            super(method, ByteCode.FIELD_ARRAY_ELEMENT_ASSIGN, -1);
            this.assignToArrayElement = _assignToArrayElement;
            this.rhs = _rhs;
        }

        @Override
        public String getDescription() {
            return "FIELD ARRAY ELEMENT INCREMENT! " + (Object)((Object)this.getByteCode());
        }

        public AssignToArrayElement getAssignToArrayElement() {
            return this.assignToArrayElement;
        }

        public Instruction getRhs() {
            return this.rhs;
        }
    }

    public static class InlineAssignInstruction
    extends Instruction {
        private final AssignToLocalVariable assignToLocalVariable;
        private final Instruction rhs;

        public InlineAssignInstruction(MethodModel method, AssignToLocalVariable _assignToLocalVariable, Instruction _rhs) {
            super(method, ByteCode.INLINE_ASSIGN, -1);
            this.assignToLocalVariable = _assignToLocalVariable;
            this.rhs = _rhs;
        }

        @Override
        public String getDescription() {
            return "INLINE ASSIGN! " + (Object)((Object)this.getByteCode());
        }

        public AssignToLocalVariable getAssignToLocalVariable() {
            return this.assignToLocalVariable;
        }

        public Instruction getRhs() {
            return this.rhs;
        }
    }

    public static class IncrementInstruction
    extends Instruction {
        private final Instruction fieldOrVariable;
        private final boolean isInc;
        private final boolean isPre;

        public Instruction getFieldOrVariableReference() {
            return this.fieldOrVariable;
        }

        public boolean isPre() {
            return this.isPre;
        }

        public IncrementInstruction(MethodModel method, Instruction _fieldOrVariable, boolean _isInc, boolean _isPre) {
            super(method, ByteCode.INCREMENT, -1);
            this.fieldOrVariable = _fieldOrVariable;
            this.isPre = _isPre;
            this.isInc = _isInc;
        }

        @Override
        public String getDescription() {
            return "INCREMENT Local Variable! " + (Object)((Object)this.getByteCode());
        }

        public boolean isInc() {
            return this.isInc;
        }

        @Override
        public Instruction getStartInstruction() {
            return this.fieldOrVariable.getStartInstruction();
        }
    }

    public static class CloneInstruction
    extends Instruction {
        private final Instruction cloning;

        public CloneInstruction(MethodModel method, Instruction _cloning) {
            super(method, ByteCode.CLONE, -1);
            this.cloning = _cloning;
        }

        @Override
        public String getDescription() {
            return "CLONE! " + (Object)((Object)this.getByteCode());
        }

        @Override
        public int getStackConsumeCount() {
            return this.cloning.getStackConsumeCount();
        }

        @Override
        public int getStackProduceCount() {
            return this.cloning.getStackProduceCount();
        }

        @Override
        public Instruction getReal() {
            return this.cloning;
        }
    }

    public static interface Unary
    extends HasOperator {
        public Instruction getUnary();
    }

    public static interface Binary
    extends HasOperator {
        public Instruction getLhs();

        public Instruction getRhs();
    }

    public static interface HasOperator {
        public Operator getOperator();
    }

    public static interface ConstantPoolEntryConstant
    extends Constant {
        public int getConstantPoolIndex();

        public ClassModel.ConstantPool.Entry getConstantPoolEntry();
    }

    public static interface Constant<T> {
        public T getValue();
    }

    public static interface AssignToLocalVariable
    extends LocalVariableTableIndexAccessor {
        public boolean isDeclaration();
    }

    public static interface AccessLocalVariable
    extends LocalVariableTableIndexAccessor {
    }

    public static interface LocalVariableTableIndexAccessor {
        public int getLocalVariableTableIndex();

        public ClassModel.LocalVariableInfo getLocalVariableInfo();
    }

    public static interface AssignToInstanceField
    extends AssignToField {
        public Instruction getInstance();
    }

    public static interface AccessInstanceField
    extends AccessField {
        public Instruction getInstance();
    }

    public static interface AssignToField
    extends FieldReference {
        public Instruction getValueToAssign();
    }

    public static interface AccessField
    extends FieldReference {
    }

    public static interface FieldReference {
        public int getConstantPoolFieldIndex();

        public ClassModel.ConstantPool.FieldEntry getConstantPoolFieldEntry();
    }

    public static interface New {
    }

    public static interface InterfaceConstantPoolMethodIndexAccessor {
        public int getConstantPoolInterfaceMethodIndex();

        public ClassModel.ConstantPool.InterfaceMethodEntry getConstantPoolInterfaceMethodEntry();

        public Instruction getInstanceReference();

        public int getArgs();

        public Instruction getArg(int var1);
    }

    public static interface VirtualMethodCall
    extends MethodCall {
        public Instruction getInstanceReference();
    }

    public static interface MethodCall {
        public int getConstantPoolMethodIndex();

        public ClassModel.ConstantPool.MethodEntry getConstantPoolMethodEntry();

        public Instruction getArg(int var1);
    }

    public static abstract class Switch
    extends Branch {
        protected int[] offsets;
        protected Instruction[] targets;

        public Switch(MethodModel _methodPoolEntry, ByteCode _code, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, _code, _byteReader, _wide);
        }

        public Instruction getTarget(int _index) {
            return this.targets[_index];
        }

        public void setTarget(int _index, Instruction _instruction) {
            this.targets[_index] = _instruction;
        }

        public int getAbsolute(int _index) {
            return this.getThisPC() + this.offsets[_index];
        }

        public int getOffset(int _index) {
            return this.offsets[_index];
        }

        public int[] getOffsets() {
            return this.offsets;
        }

        public int getSize() {
            return this.offsets.length;
        }
    }

    public static abstract class Return
    extends Instruction {
        public Return(MethodModel _methodPoolEntry, ByteCode _byteCode, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, _byteCode, _byteReader, _wide);
        }
    }

    public static abstract class Index16
    extends Index {
        public Index16(MethodModel _methodPoolEntry, ByteCode _byteCode, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, _byteCode, _byteReader, _wide);
            this.index = _byteReader.u2();
        }
    }

    public static abstract class Index08
    extends Index {
        public Index08(MethodModel _methodPoolEntry, ByteCode _byteCode, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, _byteCode, _byteReader, _wide);
            this.index = _wide ? _byteReader.u2() : _byteReader.u1();
        }
    }

    public static abstract class IndexConst
    extends Index {
        public IndexConst(MethodModel _methodPoolEntry, ByteCode _byteCode, ByteReader _byteReader, boolean _wide, int _index) {
            super(_methodPoolEntry, _byteCode, _byteReader, _wide);
            this.index = _index;
        }
    }

    public static abstract class Index
    extends Instruction {
        protected int index;

        public Index(MethodModel _methodPoolEntry, ByteCode _byteCode, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, _byteCode, _byteReader, _wide);
        }
    }

    public static class I_END
    extends Instruction {
        public I_END(MethodModel method, int _pc) {
            super(method, ByteCode.NONE, _pc);
        }

        @Override
        public String getDescription() {
            return "END";
        }
    }

    public static class I_WIDE
    extends Instruction {
        private boolean iinc;
        private int increment;
        private final int index;
        private final int wideopcode;

        public I_WIDE(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.WIDE, _byteReader, _wide);
            this.wideopcode = _byteReader.u1();
            this.index = _byteReader.u2();
            if (this.wideopcode >= 21 && this.wideopcode <= 25 || this.wideopcode >= 54 && this.wideopcode <= 58 || this.wideopcode == 169) {
                this.iinc = false;
            } else {
                this.increment = _byteReader.u2();
                this.iinc = true;
            }
        }

        @Override
        public String getDescription() {
            return "help";
        }

        public int getIncrement() {
            return this.increment;
        }

        public int getIndex() {
            return this.index;
        }

        public int getWideopcode() {
            return this.wideopcode;
        }

        public boolean isiinc() {
            return this.iinc;
        }
    }

    public static class I_TABLESWITCH
    extends Switch {
        private final int high;
        private final int low;

        public I_TABLESWITCH(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.TABLESWITCH, _byteReader, _wide);
            int operandStart = _byteReader.getOffset();
            int padLength = operandStart % 4 == 0 ? 0 : 4 - operandStart % 4;
            _byteReader.bytes(padLength);
            this.offset = _byteReader.u4();
            this.low = _byteReader.u4();
            this.high = _byteReader.u4();
            this.offsets = new int[this.high - this.low + 1];
            for (int i = this.low; i <= this.high; ++i) {
                this.offsets[i - this.low] = _byteReader.u4();
            }
        }

        @Override
        public String getDescription() {
            return "help!";
        }

        public int getHigh() {
            return this.high;
        }

        public int getLow() {
            return this.low;
        }
    }

    public static class I_SWAP
    extends Instruction {
        public I_SWAP(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.SWAP, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "swap top 2 items";
        }
    }

    public static class I_SIPUSH
    extends ImmediateConstant<Integer> {
        public I_SIPUSH(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.SIPUSH, _byteReader, _wide);
            this.value = _byteReader.u2();
        }

        @Override
        public String getDescription() {
            return "push (short)";
        }
    }

    public static class I_SASTORE
    extends AssignToArrayElement {
        public I_SASTORE(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.SASTORE, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "pop short into arrayref[index]";
        }
    }

    public static class I_SALOAD
    extends AccessArrayElement {
        public I_SALOAD(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.SALOAD, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "push short from arrayref and index";
        }
    }

    public static class I_RETURN
    extends Return {
        public I_RETURN(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.RETURN, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "return void";
        }
    }

    public static class I_RET
    extends Index08
    implements AssignToLocalVariable {
        public I_RET(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.RET, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "return to pc in local var index 08 bit";
        }

        @Override
        public ClassModel.LocalVariableInfo getLocalVariableInfo() {
            return this.method.getLocalVariableTableEntry().getVariable(this.getThisPC() + this.getLength(), this.getLocalVariableTableIndex());
        }

        @Override
        public boolean isDeclaration() {
            return this.method.getLocalVariableTableEntry().getVariable(this.getThisPC() + this.getLength(), this.getLocalVariableTableIndex()).getStart() == this.getThisPC() + this.getLength();
        }

        @Override
        public int getLocalVariableTableIndex() {
            return this.index;
        }
    }

    public static class I_PUTSTATIC
    extends Index16
    implements AssignToField {
        public I_PUTSTATIC(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.PUTSTATIC, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "pop stack value into 16 bit constant index as field";
        }

        @Override
        public int getConstantPoolFieldIndex() {
            return this.index;
        }

        @Override
        public ClassModel.ConstantPool.FieldEntry getConstantPoolFieldEntry() {
            return this.method.getConstantPool().getFieldEntry(this.getConstantPoolFieldIndex());
        }

        @Override
        public int getStackConsumeCount() {
            return 1;
        }

        @Override
        public int getStackProduceCount() {
            return 0;
        }

        @Override
        public Instruction getValueToAssign() {
            return this.getLastChild();
        }
    }

    public static class I_PUTFIELD
    extends Index16
    implements AssignToInstanceField {
        public I_PUTFIELD(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.PUTFIELD, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "pop stack value into field referenced by 16 bit constant index";
        }

        @Override
        public int getConstantPoolFieldIndex() {
            return this.index;
        }

        @Override
        public ClassModel.ConstantPool.FieldEntry getConstantPoolFieldEntry() {
            return this.method.getConstantPool().getFieldEntry(this.getConstantPoolFieldIndex());
        }

        @Override
        public int getStackConsumeCount() {
            return 2;
        }

        @Override
        public int getStackProduceCount() {
            return 0;
        }

        @Override
        public Instruction getInstance() {
            return this.getFirstChild();
        }

        @Override
        public Instruction getValueToAssign() {
            return this.getLastChild();
        }
    }

    public static class I_POP2
    extends Instruction {
        public I_POP2(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.POP2, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "pop 2 items";
        }
    }

    public static class I_POP
    extends Instruction {
        public I_POP(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.POP, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "pop one item";
        }
    }

    public static class I_NOP
    extends Instruction {
        public I_NOP(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.NOP, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "no op";
        }
    }

    public static class I_NEWARRAY
    extends Instruction
    implements New {
        private final int type;

        public I_NEWARRAY(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.NEWARRAY, _byteReader, _wide);
            this.type = _byteReader.u1();
        }

        @Override
        public String getDescription() {
            return "new array simple type";
        }

        public int getType() {
            return this.type;
        }
    }

    public static class I_NEW
    extends Index16
    implements New {
        public I_NEW(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.NEW, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "new";
        }
    }

    public static class I_MULTIANEWARRAY
    extends Index16
    implements New {
        private final int dimensions;

        public I_MULTIANEWARRAY(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.MULTIANEWARRAY, _byteReader, _wide);
            this.dimensions = _byteReader.u1();
        }

        @Override
        public String getDescription() {
            return "create a multi dimension array of refernce types ";
        }

        public int getDimensions() {
            return this.dimensions;
        }
    }

    public static class I_MONITOREXIT
    extends Instruction {
        public I_MONITOREXIT(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.MONITOREXIT, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "pop reference and dec monitor";
        }
    }

    public static class I_MONITORENTER
    extends Instruction {
        public I_MONITORENTER(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.MONITORENTER, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "pop reference and inc monitor";
        }
    }

    public static class I_LXOR
    extends BinaryOperator {
        public I_LXOR(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.LXOR, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "xor top two longs";
        }
    }

    public static class I_LUSHR
    extends BinaryOperator {
        public I_LUSHR(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.LUSHR, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "shift right top long unsigned";
        }
    }

    public static class I_LSUB
    extends BinaryOperator {
        public I_LSUB(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.LSUB, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "sub top two longs";
        }
    }

    public static class I_LSTORE_3
    extends LocalVariableConstIndexStore {
        public I_LSTORE_3(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.LSTORE_3, _byteReader, _wide, 3);
        }
    }

    public static class I_LSTORE_2
    extends LocalVariableConstIndexStore {
        public I_LSTORE_2(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.LSTORE_2, _byteReader, _wide, 2);
        }
    }

    public static class I_LSTORE_1
    extends LocalVariableConstIndexStore {
        public I_LSTORE_1(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.LSTORE_1, _byteReader, _wide, 1);
        }
    }

    public static class I_LSTORE_0
    extends LocalVariableConstIndexStore {
        public I_LSTORE_0(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.LSTORE_0, _byteReader, _wide, 0);
        }
    }

    public static class I_LSTORE
    extends LocalVariableIndex08Store {
        public I_LSTORE(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.LSTORE, _byteReader, _wide);
        }
    }

    public static class I_LSHR
    extends BinaryOperator {
        public I_LSHR(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.LSHR, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "shift right top long";
        }
    }

    public static class I_LSHL
    extends BinaryOperator {
        public I_LSHL(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.LSHL, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "shift left top long";
        }
    }

    public static class I_LRETURN
    extends Return {
        public I_LRETURN(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.LRETURN, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "return popped long";
        }
    }

    public static class I_LREM
    extends BinaryOperator {
        public I_LREM(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.LREM, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "rem top two longs";
        }
    }

    public static class I_LOR
    extends BinaryOperator {
        public I_LOR(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.LOR, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "or top two longs";
        }
    }

    public static class I_LOOKUPSWITCH
    extends Switch {
        private final int[] matches;
        private final int npairs;

        public I_LOOKUPSWITCH(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.LOOKUPSWITCH, _byteReader, _wide);
            int operandStart = _byteReader.getOffset();
            int padLength = operandStart % 4 == 0 ? 0 : 4 - operandStart % 4;
            _byteReader.bytes(padLength);
            this.offset = _byteReader.u4();
            this.npairs = _byteReader.u4();
            this.offsets = new int[this.npairs];
            this.matches = new int[this.npairs];
            for (int i = 0; i < this.npairs; ++i) {
                this.matches[i] = _byteReader.u4();
                this.offsets[i] = _byteReader.u4();
            }
        }

        @Override
        public String getDescription() {
            return "help!";
        }

        public int[] getMatches() {
            return this.matches;
        }

        public int getNpairs() {
            return this.npairs;
        }
    }

    public static class I_LNEG
    extends UnaryOperator {
        public I_LNEG(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.LNEG, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "neg top long";
        }
    }

    public static class I_LMUL
    extends BinaryOperator {
        public I_LMUL(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.LMUL, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "mul top two longs";
        }
    }

    public static class I_LLOAD_3
    extends LocalVariableConstIndexLoad {
        public I_LLOAD_3(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.LLOAD_3, _byteReader, _wide, 3);
        }
    }

    public static class I_LLOAD_2
    extends LocalVariableConstIndexLoad {
        public I_LLOAD_2(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.LLOAD_2, _byteReader, _wide, 2);
        }
    }

    public static class I_LLOAD_1
    extends LocalVariableConstIndexLoad {
        public I_LLOAD_1(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.LLOAD_1, _byteReader, _wide, 1);
        }
    }

    public static class I_LLOAD_0
    extends LocalVariableConstIndexLoad {
        public I_LLOAD_0(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.LLOAD_0, _byteReader, _wide, 0);
        }
    }

    public static class I_LLOAD
    extends LocalVariableIndex08Load {
        public I_LLOAD(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.LLOAD, _byteReader, _wide);
        }
    }

    public static class I_LDIV
    extends BinaryOperator {
        public I_LDIV(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.LDIV, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "div top two longs";
        }
    }

    public static class I_LDC2_W
    extends Index16
    implements ConstantPoolEntryConstant {
        public I_LDC2_W(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.LDC2_W, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "push long/double constant at 16 bit index";
        }

        @Override
        public int getConstantPoolIndex() {
            return this.index;
        }

        @Override
        public ClassModel.ConstantPool.Entry getConstantPoolEntry() {
            return this.method.getConstantPool().get(this.getConstantPoolIndex());
        }

        public Object getValue() {
            return this.method.getConstantPool().getConstantEntry(this.getConstantPoolIndex());
        }
    }

    public static class I_LDC_W
    extends Index16
    implements ConstantPoolEntryConstant {
        public I_LDC_W(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.LDC_W, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "push constant at 16 bit index";
        }

        @Override
        public int getConstantPoolIndex() {
            return this.index;
        }

        public Object getValue() {
            return this.method.getConstantPool().getConstantEntry(this.getConstantPoolIndex());
        }

        @Override
        public ClassModel.ConstantPool.Entry getConstantPoolEntry() {
            return this.method.getConstantPool().get(this.getConstantPoolIndex());
        }
    }

    public static class I_LDC
    extends Index08
    implements ConstantPoolEntryConstant {
        public I_LDC(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.LDC, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "push constant at 08 bit index";
        }

        public Object getValue() {
            return this.method.getConstantPool().getConstantEntry(this.getConstantPoolIndex());
        }

        @Override
        public int getConstantPoolIndex() {
            return this.index;
        }

        @Override
        public ClassModel.ConstantPool.Entry getConstantPoolEntry() {
            return this.method.getConstantPool().get(this.getConstantPoolIndex());
        }
    }

    public static class I_LCONST_1
    extends BytecodeEncodedConstant<Long> {
        public I_LCONST_1(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.LCONST_1, _byteReader, _wide, 1L);
        }

        @Override
        public String getDescription() {
            return "push (long) 1";
        }
    }

    public static class I_LCONST_0
    extends BytecodeEncodedConstant<Long> {
        public I_LCONST_0(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.LCONST_0, _byteReader, _wide, 0L);
        }

        @Override
        public String getDescription() {
            return "push (long) 0";
        }
    }

    public static class I_LCMP
    extends BinaryOperator {
        public I_LCMP(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.LCMP, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "push result of long comparison";
        }
    }

    public static class I_LASTORE
    extends AssignToArrayElement {
        public I_LASTORE(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.LASTORE, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "pop long into arrayref[index]";
        }
    }

    public static class I_LAND
    extends BinaryOperator {
        public I_LAND(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.LAND, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "and top two longs";
        }
    }

    public static class I_LALOAD
    extends AccessArrayElement {
        public I_LALOAD(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.LALOAD, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "push long from arrayref and index";
        }
    }

    public static class I_LADD
    extends BinaryOperator {
        public I_LADD(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.LADD, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "add top two longs";
        }
    }

    public static class I_L2I
    extends CastOperator {
        public I_L2I(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.L2I, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "pop long push int";
        }
    }

    public static class I_L2F
    extends CastOperator {
        public I_L2F(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.L2F, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "pop long push float";
        }
    }

    public static class I_L2D
    extends CastOperator {
        public I_L2D(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.L2D, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "pop long push double";
        }
    }

    public static class I_JSR_W
    extends Branch32 {
        public I_JSR_W(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.JSR_W, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "subroutine";
        }
    }

    public static class I_JSR
    extends UnconditionalBranch16 {
        public I_JSR(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.JSR, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "jump to subroutine ";
        }
    }

    public static class I_IXOR
    extends BinaryOperator {
        public I_IXOR(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.IXOR, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "xor top two ints";
        }
    }

    public static class I_IUSHR
    extends BinaryOperator {
        public I_IUSHR(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.IUSHR, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "shift right top int unsigned";
        }
    }

    public static class I_ISUB
    extends BinaryOperator {
        public I_ISUB(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.ISUB, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "sub top two ints";
        }
    }

    public static class I_ISTORE_3
    extends LocalVariableConstIndexStore {
        public I_ISTORE_3(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.ISTORE_3, _byteReader, _wide, 3);
        }
    }

    public static class I_ISTORE_2
    extends LocalVariableConstIndexStore {
        public I_ISTORE_2(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.ISTORE_2, _byteReader, _wide, 2);
        }
    }

    public static class I_ISTORE_1
    extends LocalVariableConstIndexStore {
        public I_ISTORE_1(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.ISTORE_1, _byteReader, _wide, 1);
        }
    }

    public static class I_ISTORE_0
    extends LocalVariableConstIndexStore {
        public I_ISTORE_0(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.ISTORE_0, _byteReader, _wide, 0);
        }
    }

    public static class I_ISTORE
    extends LocalVariableIndex08Store {
        public I_ISTORE(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.ISTORE, _byteReader, _wide);
        }
    }

    public static class I_ISHR
    extends BinaryOperator {
        public I_ISHR(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.ISHR, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "shift right top int";
        }
    }

    public static class I_ISHL
    extends BinaryOperator {
        public I_ISHL(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.ISHL, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "shift left top int";
        }
    }

    public static class I_IRETURN
    extends Return {
        public I_IRETURN(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.IRETURN, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "return popped int";
        }
    }

    public static class I_IREM
    extends BinaryOperator {
        public I_IREM(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.IREM, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "rem top two ints";
        }
    }

    public static class I_IOR
    extends BinaryOperator {
        public I_IOR(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.IOR, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "or top two ints";
        }
    }

    public static class I_INVOKEVIRTUAL
    extends Index16
    implements VirtualMethodCall {
        public I_INVOKEVIRTUAL(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.INVOKEVIRTUAL, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "pop object reference and args and call the method referenced by 16 bit constant index";
        }

        @Override
        public int getConstantPoolMethodIndex() {
            return this.index;
        }

        @Override
        public ClassModel.ConstantPool.MethodEntry getConstantPoolMethodEntry() {
            return this.method.getConstantPool().getMethodEntry(this.getConstantPoolMethodIndex());
        }

        @Override
        public Instruction getArg(int _arg) {
            Instruction child = this.getFirstChild();
            while (true) {
                int n = ++_arg;
                --_arg;
                if (n == 0) break;
                child = child.getNextExpr();
            }
            return child;
        }

        @Override
        public Instruction getInstanceReference() {
            return this.getFirstChild();
        }

        @Override
        public int getStackConsumeCount() {
            return this.getConstantPoolMethodEntry().getStackConsumeCount() + 1;
        }

        @Override
        public int getStackProduceCount() {
            return this.getConstantPoolMethodEntry().getStackProduceCount();
        }
    }

    public static class I_INVOKESTATIC
    extends Index16
    implements MethodCall {
        public I_INVOKESTATIC(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.INVOKESTATIC, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "pop args and call the  static method referenced by 16 bit constant index";
        }

        @Override
        public int getConstantPoolMethodIndex() {
            return this.index;
        }

        @Override
        public ClassModel.ConstantPool.MethodEntry getConstantPoolMethodEntry() {
            return this.method.getConstantPool().getMethodEntry(this.getConstantPoolMethodIndex());
        }

        @Override
        public Instruction getArg(int _arg) {
            Instruction child = this.getFirstChild();
            while (_arg-- != 0) {
                child = child.getNextExpr();
            }
            return child;
        }

        @Override
        public int getStackConsumeCount() {
            return this.getConstantPoolMethodEntry().getStackConsumeCount();
        }

        @Override
        public int getStackProduceCount() {
            return this.getConstantPoolMethodEntry().getStackProduceCount();
        }
    }

    public static class I_INVOKESPECIAL
    extends Index16
    implements VirtualMethodCall {
        public I_INVOKESPECIAL(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.INVOKESPECIAL, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "pop object reference and args and call the special method referenced by 16 bit constant index";
        }

        @Override
        public int getConstantPoolMethodIndex() {
            return this.index;
        }

        @Override
        public ClassModel.ConstantPool.MethodEntry getConstantPoolMethodEntry() {
            return this.method.getConstantPool().getMethodEntry(this.getConstantPoolMethodIndex());
        }

        @Override
        public Instruction getArg(int _arg) {
            Instruction child = this.getFirstChild();
            while (true) {
                int n = ++_arg;
                --_arg;
                if (n == 0) break;
                child = child.getNextExpr();
            }
            return child;
        }

        @Override
        public Instruction getInstanceReference() {
            return this.getFirstChild();
        }

        @Override
        public int getStackConsumeCount() {
            return this.getConstantPoolMethodEntry().getStackConsumeCount() + 1;
        }

        @Override
        public int getStackProduceCount() {
            return this.getConstantPoolMethodEntry().getStackProduceCount();
        }
    }

    public static class I_INVOKEDYNAMIC
    extends Index16
    implements InterfaceConstantPoolMethodIndexAccessor {
        private final int args;

        public I_INVOKEDYNAMIC(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.INVOKEDYNAMIC, _byteReader, _wide);
            this.args = _byteReader.u1();
            int zeroByte = _byteReader.u1();
        }

        @Override
        public int getArgs() {
            return this.args;
        }

        @Override
        public String getDescription() {
            return "pop args and call the invoke dynamic method referenced by 16 bit constant index";
        }

        @Override
        public int getConstantPoolInterfaceMethodIndex() {
            return this.index;
        }

        @Override
        public ClassModel.ConstantPool.InterfaceMethodEntry getConstantPoolInterfaceMethodEntry() {
            return this.method.getConstantPool().getInterfaceMethodEntry(this.getConstantPoolInterfaceMethodIndex());
        }

        @Override
        public Instruction getArg(int _arg) {
            Instruction child = this.getFirstChild();
            while (true) {
                int n = ++_arg;
                --_arg;
                if (n == 0) break;
                child = child.getNextExpr();
            }
            return child;
        }

        @Override
        public Instruction getInstanceReference() {
            return this.getFirstChild();
        }

        @Override
        public int getStackConsumeCount() {
            return this.getConstantPoolInterfaceMethodEntry().getStackConsumeCount() + 1;
        }

        @Override
        public int getStackProduceCount() {
            return this.getConstantPoolInterfaceMethodEntry().getStackProduceCount();
        }
    }

    public static class I_INVOKEINTERFACE
    extends Index16
    implements InterfaceConstantPoolMethodIndexAccessor {
        private final int args;

        public I_INVOKEINTERFACE(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.INVOKEINTERFACE, _byteReader, _wide);
            this.args = _byteReader.u1();
            int zeroByte = _byteReader.u1();
        }

        @Override
        public int getArgs() {
            return this.args;
        }

        @Override
        public String getDescription() {
            return "pop args and call the interface method referenced by 16 bit constant index";
        }

        @Override
        public int getConstantPoolInterfaceMethodIndex() {
            return this.index;
        }

        @Override
        public ClassModel.ConstantPool.InterfaceMethodEntry getConstantPoolInterfaceMethodEntry() {
            return this.method.getConstantPool().getInterfaceMethodEntry(this.getConstantPoolInterfaceMethodIndex());
        }

        @Override
        public Instruction getArg(int _arg) {
            Instruction child = this.getFirstChild();
            while (true) {
                int n = ++_arg;
                --_arg;
                if (n == 0) break;
                child = child.getNextExpr();
            }
            return child;
        }

        @Override
        public Instruction getInstanceReference() {
            return this.getFirstChild();
        }

        @Override
        public int getStackConsumeCount() {
            return this.getConstantPoolInterfaceMethodEntry().getStackConsumeCount() + 1;
        }

        @Override
        public int getStackProduceCount() {
            return this.getConstantPoolInterfaceMethodEntry().getStackProduceCount();
        }
    }

    public static class I_INSTANCEOF
    extends Index16 {
        public I_INSTANCEOF(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.INSTANCEOF, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "pop reference check against the constant accessed 16 bit push 1 if same";
        }
    }

    public static class I_INEG
    extends UnaryOperator {
        public I_INEG(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.INEG, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "neg top int";
        }
    }

    public static class I_IMUL
    extends BinaryOperator {
        public I_IMUL(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.IMUL, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "mul top two ints";
        }
    }

    public static class I_ILOAD_3
    extends LocalVariableConstIndexLoad {
        public I_ILOAD_3(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.ILOAD_3, _byteReader, _wide, 3);
        }
    }

    public static class I_ILOAD_2
    extends LocalVariableConstIndexLoad {
        public I_ILOAD_2(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.ILOAD_2, _byteReader, _wide, 2);
        }
    }

    public static class I_ILOAD_1
    extends LocalVariableConstIndexLoad {
        public I_ILOAD_1(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.ILOAD_1, _byteReader, _wide, 1);
        }
    }

    public static class I_ILOAD_0
    extends LocalVariableConstIndexLoad {
        public I_ILOAD_0(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.ILOAD_0, _byteReader, _wide, 0);
        }
    }

    public static class I_ILOAD
    extends LocalVariableIndex08Load {
        public I_ILOAD(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.ILOAD, _byteReader, _wide);
        }
    }

    public static class I_IINC
    extends Index08 {
        private int delta;
        private final boolean wide;

        public I_IINC(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.IINC, _byteReader, _wide);
            this.wide = _wide;
            this.delta = this.wide ? _byteReader.u2() : _byteReader.u1();
        }

        @Override
        public String getDescription() {
            return "inc var index 08 bit by byte";
        }

        public ClassModel.LocalVariableInfo getLocalVariableInfo() {
            return this.method.getLocalVariableTableEntry().getVariable(this.getThisPC(), this.getLocalVariableTableIndex());
        }

        public int getLocalVariableTableIndex() {
            return this.index;
        }

        public int getDelta() {
            return this.delta;
        }

        public boolean isInc() {
            return this.getAdjust() > 0;
        }

        public int getAdjust() {
            int adjust = this.delta;
            if (this.wide) {
                if (adjust > Short.MAX_VALUE) {
                    adjust = -65536 + adjust;
                }
            } else if (adjust > 127) {
                adjust = -256 + adjust;
            }
            return adjust;
        }
    }

    public static class I_IFNULL
    extends ConditionalBranch16 {
        public I_IFNULL(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.IFNULL, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "branch if null";
        }
    }

    public static class I_IFNONNULL
    extends ConditionalBranch16 {
        public I_IFNONNULL(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.IFNONNULL, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "branch if non null";
        }
    }

    public static class I_IFNE
    extends IfUnary {
        public I_IFNE(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.IFNE, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "branch if stack top int != 0";
        }
    }

    public static class I_IFLT
    extends IfUnary {
        public I_IFLT(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.IFLT, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "branch if stack top int < 0";
        }
    }

    public static class I_IFLE
    extends IfUnary {
        public I_IFLE(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.IFLE, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "branch if stack top int <= 0";
        }
    }

    public static class I_IFGT
    extends IfUnary {
        public I_IFGT(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.IFGT, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "branch if stack top int > 0";
        }
    }

    public static class I_IFGE
    extends IfUnary {
        public I_IFGE(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.IFGE, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "branch if stack top int >= 0";
        }
    }

    public static class I_IFEQ
    extends IfUnary {
        public I_IFEQ(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.IFEQ, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "branch if stack top int == 0";
        }
    }

    public static class I_IF_ICMPNE
    extends If {
        public I_IF_ICMPNE(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.IF_ICMPNE, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "branch if stack top ints !=";
        }
    }

    public static class I_IF_ICMPLT
    extends If {
        public I_IF_ICMPLT(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.IF_ICMPLT, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "branch if stack top ints < ";
        }
    }

    public static class I_IF_ICMPLE
    extends If {
        public I_IF_ICMPLE(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.IF_ICMPLE, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "branch if stack top ints <=";
        }
    }

    public static class I_IF_ICMPGT
    extends If {
        public I_IF_ICMPGT(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.IF_ICMPGT, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "branch if stack top ints > ";
        }
    }

    public static class I_IF_ICMPGE
    extends If {
        public I_IF_ICMPGE(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.IF_ICMPGE, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "branch if stack top ints >=";
        }
    }

    public static class I_IF_ICMPEQ
    extends If {
        public I_IF_ICMPEQ(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.IF_ICMPEQ, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "branch if stack top ints ==";
        }
    }

    public static class I_IF_ACMPNE
    extends If {
        public I_IF_ACMPNE(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.IF_ACMPNE, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "branch if stack top references !=";
        }
    }

    public static class I_IF_ACMPEQ
    extends If {
        public I_IF_ACMPEQ(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.IF_ACMPEQ, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "branch if stack top references ==";
        }
    }

    public static class I_IDIV
    extends BinaryOperator {
        public I_IDIV(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.IDIV, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "div top two ints";
        }
    }

    public static class I_ICONST_M1
    extends BytecodeEncodedConstant<Integer> {
        public I_ICONST_M1(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.ICONST_M1, _byteReader, _wide, -1);
        }

        @Override
        public String getDescription() {
            return "push (int)-1";
        }
    }

    public static class I_ICONST_5
    extends BytecodeEncodedConstant<Integer> {
        public I_ICONST_5(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.ICONST_5, _byteReader, _wide, 5);
        }

        @Override
        public String getDescription() {
            return "push (int) 5";
        }
    }

    public static class I_ICONST_4
    extends BytecodeEncodedConstant<Integer> {
        public I_ICONST_4(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.ICONST_4, _byteReader, _wide, 4);
        }

        @Override
        public String getDescription() {
            return "push (int) 4";
        }
    }

    public static class I_ICONST_3
    extends BytecodeEncodedConstant<Integer> {
        public I_ICONST_3(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.ICONST_3, _byteReader, _wide, 3);
        }

        @Override
        public String getDescription() {
            return "push (int) 3";
        }
    }

    public static class I_ICONST_2
    extends BytecodeEncodedConstant<Integer> {
        public I_ICONST_2(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.ICONST_2, _byteReader, _wide, 2);
        }

        @Override
        public String getDescription() {
            return "push (int) 2";
        }
    }

    public static class I_ICONST_1
    extends BytecodeEncodedConstant<Integer> {
        public I_ICONST_1(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.ICONST_1, _byteReader, _wide, 1);
        }

        @Override
        public String getDescription() {
            return "push (int) 1";
        }
    }

    public static class I_ICONST_0
    extends BytecodeEncodedConstant<Integer> {
        public I_ICONST_0(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.ICONST_0, _byteReader, _wide, 0);
        }

        @Override
        public String getDescription() {
            return "push (int) 0";
        }
    }

    public static class I_IASTORE
    extends AssignToArrayElement {
        public I_IASTORE(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.IASTORE, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "pop int into arrayref[index]";
        }
    }

    public static class I_IAND
    extends BinaryOperator {
        public I_IAND(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.IAND, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "and top two ints";
        }
    }

    public static class I_IALOAD
    extends AccessArrayElement {
        public I_IALOAD(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.IALOAD, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "push int from arrayref and index";
        }
    }

    public static class I_IADD
    extends BinaryOperator {
        public I_IADD(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.IADD, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "add top two ints";
        }
    }

    public static class I_I2S
    extends CastOperator {
        public I_I2S(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.I2S, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "pop int push short";
        }
    }

    public static class I_I2L
    extends CastOperator {
        public I_I2L(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.I2L, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "pop int push long";
        }
    }

    public static class I_I2F
    extends CastOperator {
        public I_I2F(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.I2F, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "pop int push float";
        }
    }

    public static class I_I2D
    extends CastOperator {
        public I_I2D(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.I2D, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "pop int push double";
        }
    }

    public static class I_I2C
    extends CastOperator {
        public I_I2C(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.I2C, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "pop int push char";
        }
    }

    public static class I_I2B
    extends CastOperator {
        public I_I2B(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.I2B, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "pop int push byte";
        }
    }

    public static class I_GOTO_W
    extends Branch32 {
        public I_GOTO_W(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.GOTO_W, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "goto wide branch";
        }
    }

    public static class I_GOTO
    extends UnconditionalBranch16 {
        public I_GOTO(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.GOTO, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "branch ";
        }
    }

    public static class I_GETSTATIC
    extends Index16
    implements AccessField {
        public I_GETSTATIC(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.GETSTATIC, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "push  static field value at 16 bit constant index";
        }

        @Override
        public int getConstantPoolFieldIndex() {
            return this.index;
        }

        @Override
        public ClassModel.ConstantPool.FieldEntry getConstantPoolFieldEntry() {
            return this.method.getConstantPool().getFieldEntry(this.getConstantPoolFieldIndex());
        }

        @Override
        public int getStackConsumeCount() {
            return 0;
        }

        @Override
        public int getStackProduceCount() {
            return 1;
        }
    }

    public static class I_GETFIELD
    extends Index16
    implements AccessInstanceField {
        public I_GETFIELD(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.GETFIELD, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "push value from field referenced by 16 bit constant index";
        }

        @Override
        public int getConstantPoolFieldIndex() {
            return this.index;
        }

        @Override
        public ClassModel.ConstantPool.FieldEntry getConstantPoolFieldEntry() {
            return this.method.getConstantPool().getFieldEntry(this.getConstantPoolFieldIndex());
        }

        @Override
        public Instruction getInstance() {
            return this.getFirstChild();
        }

        @Override
        public int getStackConsumeCount() {
            return 1;
        }

        @Override
        public int getStackProduceCount() {
            return 1;
        }
    }

    public static class I_FSUB
    extends BinaryOperator {
        public I_FSUB(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.FSUB, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "sub top two floats";
        }
    }

    public static class I_FSTORE_3
    extends LocalVariableConstIndexStore {
        public I_FSTORE_3(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.FSTORE_3, _byteReader, _wide, 3);
        }
    }

    public static class I_FSTORE_2
    extends LocalVariableConstIndexStore {
        I_FSTORE_2(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.FSTORE_2, _byteReader, _wide, 2);
        }
    }

    public static class I_FSTORE_1
    extends LocalVariableConstIndexStore {
        public I_FSTORE_1(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.FSTORE_1, _byteReader, _wide, 1);
        }
    }

    public static class I_FSTORE_0
    extends LocalVariableConstIndexStore {
        public I_FSTORE_0(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.FSTORE_0, _byteReader, _wide, 0);
        }
    }

    public static class I_FSTORE
    extends LocalVariableIndex08Store {
        public I_FSTORE(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.FSTORE, _byteReader, _wide);
        }
    }

    public static class I_FRETURN
    extends Return {
        public I_FRETURN(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.FRETURN, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "return popped float";
        }
    }

    public static class I_FREM
    extends BinaryOperator {
        public I_FREM(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.FREM, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "rem top two floats";
        }
    }

    public static class I_FNEG
    extends UnaryOperator {
        public I_FNEG(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.FNEG, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "neg top float";
        }
    }

    public static class I_FMUL
    extends BinaryOperator {
        public I_FMUL(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.FMUL, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "mul top two floats";
        }
    }

    public static class I_FLOAD_3
    extends LocalVariableConstIndexLoad {
        public I_FLOAD_3(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.FLOAD_3, _byteReader, _wide, 3);
        }
    }

    public static class I_FLOAD_2
    extends LocalVariableConstIndexLoad {
        public I_FLOAD_2(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.FLOAD_2, _byteReader, _wide, 2);
        }
    }

    public static class I_FLOAD_1
    extends LocalVariableConstIndexLoad {
        public I_FLOAD_1(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.FLOAD_1, _byteReader, _wide, 1);
        }
    }

    public static class I_FLOAD_0
    extends LocalVariableConstIndexLoad {
        public I_FLOAD_0(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.FLOAD_0, _byteReader, _wide, 0);
        }
    }

    public static class I_FLOAD
    extends LocalVariableIndex08Load {
        public I_FLOAD(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.FLOAD, _byteReader, _wide);
        }
    }

    public static class I_FDIV
    extends BinaryOperator {
        public I_FDIV(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.FDIV, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "div top two floats";
        }
    }

    public static class I_FCONST_2
    extends BytecodeEncodedConstant<Float> {
        public I_FCONST_2(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.FCONST_2, _byteReader, _wide, Float.valueOf(2.0f));
        }

        @Override
        public String getDescription() {
            return "push (float) 2.0";
        }
    }

    public static class I_FCONST_1
    extends BytecodeEncodedConstant<Float> {
        public I_FCONST_1(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.FCONST_1, _byteReader, _wide, Float.valueOf(1.0f));
        }

        @Override
        public String getDescription() {
            return "push (float) 1.0";
        }
    }

    public static class I_FCONST_0
    extends BytecodeEncodedConstant<Float> {
        public I_FCONST_0(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.FCONST_0, _byteReader, _wide, Float.valueOf(0.0f));
        }

        @Override
        public String getDescription() {
            return "push (float) 0.0";
        }
    }

    public static class I_FCMPL
    extends BinaryOperator {
        public I_FCMPL(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.FCMPL, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "push result of float comparison";
        }
    }

    public static class I_FCMPG
    extends BinaryOperator {
        public I_FCMPG(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.FCMPG, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "push result of float comparison";
        }
    }

    public static class I_FASTORE
    extends AssignToArrayElement {
        public I_FASTORE(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.FASTORE, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "pop float into arrayref[index]";
        }
    }

    public static class I_FALOAD
    extends AccessArrayElement {
        public I_FALOAD(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.FALOAD, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "push float from arrayref and index";
        }
    }

    public static class I_FADD
    extends BinaryOperator {
        public I_FADD(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.FADD, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "add top two floats";
        }
    }

    public static class I_F2L
    extends CastOperator {
        public I_F2L(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.F2L, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "pop float push long";
        }
    }

    public static class I_F2I
    extends CastOperator {
        public I_F2I(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.F2I, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "pop float push int";
        }
    }

    public static class I_F2D
    extends CastOperator {
        public I_F2D(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.F2D, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "pop float push double";
        }
    }

    public static class I_DUP2_X2
    extends DUP {
        public I_DUP2_X2(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.DUP_X2, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "dup top 2 items 3 items down";
        }
    }

    public static class I_DUP2_X1
    extends DUP {
        public I_DUP2_X1(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.DUP2_X1, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "dup top 2 items 2 items down";
        }
    }

    public static class I_DUP2
    extends DUP {
        public I_DUP2(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.DUP2, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "dup top 2 items";
        }
    }

    public static class I_DUP_X2
    extends DUP {
        public I_DUP_X2(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.DUP_X2, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "dup top item 3 items down";
        }
    }

    public static class I_DUP_X1
    extends DUP {
        public I_DUP_X1(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.DUP_X1, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "dup top item 2 items down";
        }
    }

    public static class I_DUP
    extends DUP {
        public I_DUP(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.DUP, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "dup top item";
        }
    }

    public static abstract class DUP
    extends Instruction {
        public DUP(MethodModel _methodPoolEntry, ByteCode _byteCode, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, _byteCode, _byteReader, _wide);
        }
    }

    public static class I_DSUB
    extends BinaryOperator {
        public I_DSUB(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.DSUB, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "sub top two doubles";
        }
    }

    public static class I_DSTORE_3
    extends LocalVariableConstIndexStore {
        public I_DSTORE_3(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.DSTORE_3, _byteReader, _wide, 3);
        }
    }

    public static class I_DSTORE_2
    extends LocalVariableConstIndexStore {
        public I_DSTORE_2(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.DSTORE_2, _byteReader, _wide, 2);
        }
    }

    public static class I_DSTORE_1
    extends LocalVariableConstIndexStore {
        public I_DSTORE_1(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.DSTORE_1, _byteReader, _wide, 1);
        }
    }

    public static class I_DSTORE_0
    extends LocalVariableConstIndexStore {
        public I_DSTORE_0(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.DSTORE_0, _byteReader, _wide, 0);
        }
    }

    public static class I_DSTORE
    extends LocalVariableIndex08Store {
        public I_DSTORE(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.DSTORE, _byteReader, _wide);
        }
    }

    public static class I_DRETURN
    extends Return {
        public I_DRETURN(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.DRETURN, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "return popped double";
        }
    }

    public static class I_DREM
    extends BinaryOperator {
        public I_DREM(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.DREM, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "rem top two doubles";
        }
    }

    public static class I_DNEG
    extends UnaryOperator {
        public I_DNEG(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.DNEG, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "neg top double";
        }
    }

    public static class I_DMUL
    extends BinaryOperator {
        public I_DMUL(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.DMUL, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "mul top two doubles";
        }
    }

    public static class I_DLOAD_3
    extends LocalVariableConstIndexLoad {
        public I_DLOAD_3(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.DLOAD_3, _byteReader, _wide, 3);
        }
    }

    public static class I_DLOAD_2
    extends LocalVariableConstIndexLoad {
        public I_DLOAD_2(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.DLOAD_2, _byteReader, _wide, 2);
        }
    }

    public static class I_DLOAD_1
    extends LocalVariableConstIndexLoad {
        public I_DLOAD_1(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.DLOAD_1, _byteReader, _wide, 1);
        }
    }

    public static class I_DLOAD_0
    extends LocalVariableConstIndexLoad {
        public I_DLOAD_0(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.DLOAD_0, _byteReader, _wide, 0);
        }
    }

    public static class I_DLOAD
    extends LocalVariableIndex08Load {
        public I_DLOAD(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.DLOAD, _byteReader, _wide);
        }
    }

    public static class I_DDIV
    extends BinaryOperator {
        public I_DDIV(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.DDIV, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "div top two doubles";
        }
    }

    public static class I_DCONST_1
    extends BytecodeEncodedConstant<Double> {
        public I_DCONST_1(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.DCONST_1, _byteReader, _wide, 1.0);
        }

        @Override
        public String getDescription() {
            return "push (double) 1.0";
        }
    }

    public static class I_DCONST_0
    extends BytecodeEncodedConstant<Double> {
        public I_DCONST_0(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.DCONST_0, _byteReader, _wide, 0.0);
        }

        @Override
        public String getDescription() {
            return "push (double) 0.0";
        }
    }

    public static abstract class ImmediateConstant<T>
    extends Instruction
    implements Constant<T> {
        protected T value;

        public ImmediateConstant(MethodModel _methodPoolEntry, ByteCode _byteCode, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, _byteCode, _byteReader, _wide);
        }

        @Override
        public T getValue() {
            return this.value;
        }
    }

    public static abstract class BytecodeEncodedConstant<T>
    extends Instruction
    implements Constant<T> {
        private final T value;

        public BytecodeEncodedConstant(MethodModel _methodPoolEntry, ByteCode _byteCode, ByteReader _byteReader, boolean _wide, T _value) {
            super(_methodPoolEntry, _byteCode, _byteReader, _wide);
            this.value = _value;
        }

        @Override
        public T getValue() {
            return this.value;
        }
    }

    public static class I_DCMPL
    extends Instruction {
        public I_DCMPL(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.DCMPL, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "push result of double comparison";
        }
    }

    public static class I_DCMPG
    extends Instruction {
        public I_DCMPG(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.DCMPG, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "push result of double comparison";
        }
    }

    public static class I_DASTORE
    extends AssignToArrayElement {
        public I_DASTORE(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.DASTORE, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "pop double into arrayref[index]";
        }
    }

    public static class I_DALOAD
    extends AccessArrayElement {
        public I_DALOAD(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.DALOAD, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "push double from arrayref and index";
        }
    }

    public static class I_DADD
    extends BinaryOperator {
        public I_DADD(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.DADD, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "add top two doubles";
        }
    }

    public static class I_D2L
    extends CastOperator {
        public I_D2L(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.D2L, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "pop double push long";
        }
    }

    public static class I_D2I
    extends CastOperator {
        public I_D2I(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.D2I, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "pop double push int";
        }
    }

    public static class I_D2F
    extends CastOperator {
        public I_D2F(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.D2F, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "pop double push float";
        }
    }

    public static class I_CHECKCAST
    extends Index16 {
        public I_CHECKCAST(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.CHECKCAST, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "peek reference check against the constant accessed 16 bit";
        }
    }

    public static class I_CASTORE
    extends AssignToArrayElement {
        public I_CASTORE(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.CASTORE, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "pop char into arrayref[index]";
        }
    }

    public static class I_CALOAD
    extends AccessArrayElement {
        public I_CALOAD(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.CALOAD, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "push char from arrayref and index";
        }
    }

    public static class I_BIPUSH
    extends ImmediateConstant<Integer> {
        public I_BIPUSH(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.BIPUSH, _byteReader, _wide);
            this.value = _byteReader.u1();
        }

        @Override
        public String getDescription() {
            return "push (byte)";
        }

        @Override
        public Integer getValue() {
            int byteValue = (Integer)super.getValue();
            if (byteValue > 127) {
                byteValue = -(256 - byteValue);
            }
            return byteValue;
        }
    }

    public static class I_BASTORE
    extends AssignToArrayElement {
        public I_BASTORE(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.BASTORE, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "pop boolean/byte into arrayref[index]";
        }
    }

    public static class I_BALOAD
    extends AccessArrayElement {
        public I_BALOAD(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.BALOAD, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "push byte/boolean from arrayref and index";
        }
    }

    public static class I_ATHROW
    extends Instruction {
        public I_ATHROW(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.ATHROW, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "pop reference and throw";
        }
    }

    public static class I_ASTORE_3
    extends LocalVariableConstIndexStore {
        public I_ASTORE_3(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.ASTORE_3, _byteReader, _wide, 3);
        }
    }

    public static class I_ASTORE_2
    extends LocalVariableConstIndexStore {
        public I_ASTORE_2(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.ASTORE_2, _byteReader, _wide, 2);
        }
    }

    public static class I_ASTORE_1
    extends LocalVariableConstIndexStore {
        public I_ASTORE_1(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.ASTORE_1, _byteReader, _wide, 1);
        }
    }

    public static class I_ASTORE_0
    extends LocalVariableConstIndexStore {
        public I_ASTORE_0(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.ASTORE_0, _byteReader, _wide, 0);
        }
    }

    public static class I_ASTORE
    extends LocalVariableIndex08Store {
        public I_ASTORE(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.ASTORE, _byteReader, _wide);
        }
    }

    public static class I_ARRAYLENGTH
    extends Instruction {
        public I_ARRAYLENGTH(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.ARRAYLENGTH, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "pop array push length";
        }
    }

    public static class I_ARETURN
    extends Return {
        public I_ARETURN(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.ARETURN, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "return popped reference";
        }
    }

    public static class I_ANEWARRAY
    extends Index16
    implements New {
        public I_ANEWARRAY(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.ANEWARRAY, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "new array of reference";
        }
    }

    public static class I_ALOAD_3
    extends LocalVariableConstIndexLoad {
        public I_ALOAD_3(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.ALOAD_3, _byteReader, _wide, 3);
        }
    }

    public static class I_ALOAD_2
    extends LocalVariableConstIndexLoad {
        public I_ALOAD_2(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.ALOAD_2, _byteReader, _wide, 2);
        }
    }

    public static class I_ALOAD_1
    extends LocalVariableConstIndexLoad {
        public I_ALOAD_1(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.ALOAD_1, _byteReader, _wide, 1);
        }
    }

    public static class I_ALOAD_0
    extends LocalVariableConstIndexLoad {
        public I_ALOAD_0(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.ALOAD_0, _byteReader, _wide, 0);
        }
    }

    public static class I_ALOAD
    extends LocalVariableIndex08Load {
        public I_ALOAD(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.ALOAD, _byteReader, _wide);
        }
    }

    public static abstract class LocalVariableIndex08Store
    extends LocalVariableIndex08Accessor
    implements AssignToLocalVariable {
        public LocalVariableIndex08Store(MethodModel methodPoolEntry, ByteCode byteCode, ByteReader byteReader, boolean _wide) {
            super(methodPoolEntry, byteCode, byteReader, _wide);
        }

        @Override
        public boolean isDeclaration() {
            ClassModel.LocalVariableTableEntry<ClassModel.LocalVariableInfo> localVariableTableEntry = this.method.getLocalVariableTableEntry();
            ClassModel.LocalVariableInfo localVarInfo = localVariableTableEntry.getVariable(this.getThisPC() + this.getLength(), this.getLocalVariableTableIndex());
            return localVarInfo != null && localVarInfo.getStart() == this.getThisPC() + this.getLength();
        }

        @Override
        public String getDescription() {
            return "pop reference into local var index " + this.index;
        }
    }

    public static abstract class LocalVariableIndex08Load
    extends LocalVariableIndex08Accessor {
        public LocalVariableIndex08Load(MethodModel methodPoolEntry, ByteCode byteCode, ByteReader byteReader, boolean _wide) {
            super(methodPoolEntry, byteCode, byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "push reference from local var index " + this.index;
        }
    }

    public static abstract class LocalVariableIndex08Accessor
    extends Index08
    implements AccessLocalVariable {
        public LocalVariableIndex08Accessor(MethodModel methodPoolEntry, ByteCode byteCode, ByteReader byteReader, boolean _wide) {
            super(methodPoolEntry, byteCode, byteReader, _wide);
        }

        @Override
        public int getLocalVariableTableIndex() {
            return this.index;
        }

        @Override
        public ClassModel.LocalVariableInfo getLocalVariableInfo() {
            return this.method.getLocalVariableTableEntry().getVariable(this.getThisPC() + this.getLength(), this.getLocalVariableTableIndex());
        }
    }

    public static abstract class LocalVariableConstIndexStore
    extends LocalVariableConstIndexAccessor
    implements AssignToLocalVariable {
        public LocalVariableConstIndexStore(MethodModel methodPoolEntry, ByteCode byteCode, ByteReader byteReader, boolean _wide, int index) {
            super(methodPoolEntry, byteCode, byteReader, _wide, index);
        }

        @Override
        public boolean isDeclaration() {
            ClassModel.LocalVariableInfo lvi = this.method.getLocalVariableTableEntry().getVariable(this.getThisPC() + this.getLength(), this.getLocalVariableTableIndex());
            return lvi.getStart() == this.getThisPC() + this.getLength();
        }

        @Override
        public String getDescription() {
            return "pop reference into local var index " + this.index;
        }
    }

    public static abstract class LocalVariableConstIndexLoad
    extends LocalVariableConstIndexAccessor {
        public LocalVariableConstIndexLoad(MethodModel methodPoolEntry, ByteCode byteCode, ByteReader byteReader, boolean _wide, int index) {
            super(methodPoolEntry, byteCode, byteReader, _wide, index);
        }

        @Override
        public String getDescription() {
            return "push reference from local var index " + this.index;
        }
    }

    public static abstract class LocalVariableConstIndexAccessor
    extends IndexConst
    implements AccessLocalVariable {
        public LocalVariableConstIndexAccessor(MethodModel methodPoolEntry, ByteCode byteCode, ByteReader byteReader, boolean _wide, int index) {
            super(methodPoolEntry, byteCode, byteReader, _wide, index);
        }

        @Override
        public int getLocalVariableTableIndex() {
            return this.index;
        }

        @Override
        public ClassModel.LocalVariableInfo getLocalVariableInfo() {
            return this.method.getLocalVariableTableEntry().getVariable(this.getThisPC() + this.getLength(), this.getLocalVariableTableIndex());
        }
    }

    public static class I_ACONST_NULL
    extends Instruction
    implements Constant<Object> {
        public I_ACONST_NULL(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.ACONST_NULL, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "push null";
        }

        @Override
        public Object getValue() {
            return null;
        }
    }

    public static class I_AASTORE
    extends AssignToArrayElement {
        public I_AASTORE(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.AASTORE, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "pop reference into arrayref[index]";
        }
    }

    public static abstract class AssignToArrayElement
    extends ArrayAccess {
        public Instruction getValue() {
            return this.getFirstChild().getNextExpr().getNextExpr();
        }

        protected AssignToArrayElement(MethodModel _methodPoolEntry, ByteCode _byteCode, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, _byteCode, _byteReader, _wide);
        }
    }

    public static class I_AALOAD
    extends AccessArrayElement {
        public I_AALOAD(MethodModel _methodPoolEntry, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, ByteCode.AALOAD, _byteReader, _wide);
        }

        @Override
        public String getDescription() {
            return "push reference from arrayref and index";
        }
    }

    public static abstract class AccessArrayElement
    extends ArrayAccess {
        protected AccessArrayElement(MethodModel _methodPoolEntry, ByteCode _byteCode, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, _byteCode, _byteReader, _wide);
        }
    }

    public static abstract class ArrayAccess
    extends Instruction {
        public ArrayAccess(MethodModel _methodPoolEntry, ByteCode _byteCode, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, _byteCode, _byteReader, _wide);
        }

        public Instruction getArrayRef() {
            return this.getFirstChild();
        }

        public Instruction getArrayIndex() {
            return this.getFirstChild().getNextExpr();
        }
    }

    public static abstract class Branch32
    extends UnconditionalBranch {
        public Branch32(MethodModel _methodPoolEntry, ByteCode _byteCode, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, _byteCode, _byteReader, _wide);
            this.offset = _byteReader.s4();
        }
    }

    public static abstract class UnconditionalBranch16
    extends UnconditionalBranch {
        public UnconditionalBranch16(MethodModel _methodPoolEntry, ByteCode _byteCode, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, _byteCode, _byteReader, _wide);
            this.offset = _byteReader.s2();
        }
    }

    public static abstract class ConditionalBranch16
    extends ConditionalBranch
    implements HasOperator {
        public ConditionalBranch16(MethodModel _methodPoolEntry, ByteCode _byteCode, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, _byteCode, _byteReader, _wide);
            this.offset = _byteReader.s2();
        }

        @Override
        public Operator getOperator() {
            return this.getByteCode().getOperator();
        }
    }

    public static abstract class If
    extends ConditionalBranch16
    implements Binary {
        public If(MethodModel _methodPoolEntry, ByteCode _byteCode, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, _byteCode, _byteReader, _wide);
        }

        @Override
        public Instruction getLhs() {
            return this.getFirstChild();
        }

        @Override
        public Instruction getRhs() {
            return this.getLastChild();
        }
    }

    public static abstract class IfUnary
    extends ConditionalBranch16
    implements Unary {
        public IfUnary(MethodModel _methodPoolEntry, ByteCode _byteCode, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, _byteCode, _byteReader, _wide);
        }

        @Override
        public Instruction getUnary() {
            return this.getFirstChild();
        }
    }

    public static abstract class UnconditionalBranch
    extends Branch {
        public UnconditionalBranch(MethodModel _methodPoolEntry, ByteCode _byteCode, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, _byteCode, _byteReader, _wide);
        }

        public UnconditionalBranch(MethodModel _methodPoolEntry, ByteCode _byteCode, Instruction _target) {
            super(_methodPoolEntry, _byteCode, _target);
        }
    }

    public static abstract class ConditionalBranch
    extends Branch {
        private BranchSet branchSet;

        public ConditionalBranch(MethodModel _methodPoolEntry, ByteCode _byteCode, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, _byteCode, _byteReader, _wide);
        }

        public void setBranchSet(BranchSet _branchSet) {
            this.branchSet = _branchSet;
        }

        public BranchSet getOrCreateBranchSet() {
            if (this.branchSet == null) {
                this.branchSet = new BranchSet(this);
            }
            return this.branchSet;
        }

        public BranchSet getBranchSet() {
            return this.branchSet;
        }

        public ConditionalBranch findEndOfConditionalBranchSet(Instruction _extent) {
            ConditionalBranch i = this;
            Instruction theTarget = null;
            ConditionalBranch lastToTarget = null;
            if (this.getTarget().isAfter(_extent)) {
                theTarget = this.getTarget();
                lastToTarget = this;
            }
            while (i.getNextExpr().isBranch() && i.getNextExpr().asBranch().isForwardConditional()) {
                Branch nextBranch = i.getNextExpr().asBranch();
                if (theTarget == null && nextBranch.getTarget().isAfter(_extent)) {
                    theTarget = nextBranch.getTarget();
                    lastToTarget = this;
                } else if (nextBranch.getTarget() == theTarget) {
                    lastToTarget = this;
                }
                i = (ConditionalBranch)i.getNextExpr();
            }
            if (theTarget == null) {
                throw new IllegalStateException("unable to find end of while extent");
            }
            return lastToTarget;
        }
    }

    public static abstract class Branch
    extends Instruction {
        protected int offset;
        protected boolean breakOrContinue;
        protected Instruction target;

        public int getAbsolute() {
            return this.getThisPC() + this.getOffset();
        }

        private int getOffset() {
            return this.offset;
        }

        public Branch(MethodModel _methodPoolEntry, ByteCode _byteCode, ByteReader _byteReader, boolean _wide) {
            super(_methodPoolEntry, _byteCode, _byteReader, _wide);
        }

        public Branch(MethodModel _methodPoolEntry, ByteCode _byteCode, Instruction _target) {
            super(_methodPoolEntry, _byteCode, -1);
            this.setTarget(_target);
        }

        public Instruction getTarget() {
            return this.target;
        }

        public void setTarget(Instruction _target) {
            this.target = _target;
            this.offset = this.target.getThisPC() - this.getThisPC();
            this.target.addBranchTarget(this);
        }

        public boolean isConditional() {
            return this instanceof ConditionalBranch;
        }

        public boolean isUnconditional() {
            return this instanceof UnconditionalBranch;
        }

        public boolean isReverseConditional() {
            return this.isConditional() && this.isReverse();
        }

        public boolean isForwardConditional() {
            return this.isConditional() && this.isForward();
        }

        public boolean isReverseUnconditional() {
            return this.isUnconditional() && this.isReverse();
        }

        public boolean isForwardUnconditional() {
            return this.isUnconditional() && this.isForward();
        }

        public boolean isReverse() {
            return this.offset < 0;
        }

        public boolean isForward() {
            return this.offset >= 0;
        }

        public void unhook() {
            this.getTarget().removeBranchTarget(this);
        }

        public void setBreakOrContinue(boolean b) {
            this.breakOrContinue = true;
        }

        public boolean isBreakOrContinue() {
            return this.breakOrContinue;
        }

        public void retarget(Instruction _newTarget) {
            this.unhook();
            this.setTarget(_newTarget);
        }
    }

    public static abstract class CastOperator
    extends UnaryOperator {
        protected CastOperator(MethodModel _methodPoolEntry, ByteCode code, ByteReader reader, boolean _wide) {
            super(_methodPoolEntry, code, reader, _wide);
        }
    }

    public static abstract class UnaryOperator
    extends OperatorInstruction
    implements Unary {
        @Override
        public final Instruction getUnary() {
            return this.getFirstChild();
        }

        protected UnaryOperator(MethodModel _methodPoolEntry, ByteCode code, ByteReader reader, boolean _wide) {
            super(_methodPoolEntry, code, reader, _wide);
        }
    }

    public static abstract class BinaryOperator
    extends OperatorInstruction
    implements Binary {
        @Override
        public final Instruction getLhs() {
            return this.getFirstChild();
        }

        @Override
        public final Instruction getRhs() {
            return this.getLastChild();
        }

        protected BinaryOperator(MethodModel _methodPoolEntry, ByteCode code, ByteReader reader, boolean _wide) {
            super(_methodPoolEntry, code, reader, _wide);
        }
    }

    public static abstract class OperatorInstruction
    extends Instruction {
        protected OperatorInstruction(MethodModel _methodPoolEntry, ByteCode code, ByteReader reader, boolean _wide) {
            super(_methodPoolEntry, code, reader, _wide);
        }

        public Operator getOperator() {
            return this.getByteCode().getOperator();
        }
    }

    public static class CompositeArbitraryScopeInstruction
    extends CompositeInstruction {
        protected CompositeArbitraryScopeInstruction(MethodModel method, Instruction _firstChild, Instruction _lastChild, BranchSet _branchSet) {
            super(method, ByteCode.COMPOSITE_ARBITRARY_SCOPE, _firstChild, _lastChild, _branchSet);
        }
    }

    public static class CompositeForEclipseInstruction
    extends CompositeInstruction {
        protected CompositeForEclipseInstruction(MethodModel method, Instruction _firstChild, Instruction _lastChild, BranchSet _branchSet) {
            super(method, ByteCode.COMPOSITE_FOR_ECLIPSE, _firstChild, _lastChild, _branchSet);
        }
    }

    public static class CompositeDoWhileInstruction
    extends CompositeInstruction {
        protected CompositeDoWhileInstruction(MethodModel method, Instruction _firstChild, Instruction _lastChild, BranchSet _branchSet) {
            super(method, ByteCode.COMPOSITE_DO_WHILE, _firstChild, _lastChild, _branchSet);
        }
    }

    public static class CompositeEmptyLoopInstruction
    extends CompositeInstruction {
        public CompositeEmptyLoopInstruction(MethodModel method, Instruction _firstChild, Instruction _lastChild, BranchSet _branchSet) {
            super(method, ByteCode.COMPOSITE_EMPTY_LOOP, _firstChild, _lastChild, _branchSet);
        }
    }

    public static class CompositeWhileInstruction
    extends CompositeInstruction {
        public CompositeWhileInstruction(MethodModel method, Instruction _firstChild, Instruction _lastChild, BranchSet _branchSet) {
            super(method, ByteCode.COMPOSITE_WHILE, _firstChild, _lastChild, _branchSet);
        }
    }

    public static class CompositeForSunInstruction
    extends CompositeInstruction {
        public CompositeForSunInstruction(MethodModel method, Instruction _firstChild, Instruction _lastChild, BranchSet _branchSet) {
            super(method, ByteCode.COMPOSITE_FOR_SUN, _firstChild, _lastChild, _branchSet);
        }
    }

    public static class CompositeIfElseInstruction
    extends CompositeInstruction {
        public CompositeIfElseInstruction(MethodModel method, Instruction _firstChild, Instruction _lastChild, BranchSet _branchSet) {
            super(method, ByteCode.COMPOSITE_IF_ELSE, _firstChild, _lastChild, _branchSet);
        }
    }

    public static class CompositeIfInstruction
    extends CompositeInstruction {
        public CompositeIfInstruction(MethodModel method, Instruction _firstChild, Instruction _lastChild, BranchSet _branchSet) {
            super(method, ByteCode.COMPOSITE_IF, _firstChild, _lastChild, _branchSet);
        }
    }

    public static class CompositeInstruction
    extends Instruction {
        protected BranchSet branchSet;

        public CompositeInstruction(MethodModel method, ByteCode _byteCode, Instruction _firstChild, Instruction _lastChild, BranchSet _branchSet) {
            super(method, _byteCode, -1);
            this.branchSet = _branchSet;
            this.setChildren(_firstChild, _lastChild);
        }

        @Override
        public String getDescription() {
            return "COMPOSITE! " + (Object)((Object)this.getByteCode());
        }

        @Override
        public int getThisPC() {
            return this.getLastChild().getThisPC();
        }

        @Override
        public int getStartPC() {
            return this.getFirstChild().getStartPC();
        }

        public static CompositeInstruction create(ByteCode _byteCode, MethodModel _methodModel, Instruction _firstChild, Instruction _lastChild, BranchSet _branchSet) {
            CompositeInstruction compositeInstruction = null;
            switch (_byteCode) {
                case COMPOSITE_IF: {
                    compositeInstruction = new CompositeIfInstruction(_methodModel, _firstChild, _lastChild, _branchSet);
                    break;
                }
                case COMPOSITE_IF_ELSE: {
                    compositeInstruction = new CompositeIfElseInstruction(_methodModel, _firstChild, _lastChild, _branchSet);
                    break;
                }
                case COMPOSITE_FOR_SUN: {
                    compositeInstruction = new CompositeForSunInstruction(_methodModel, _firstChild, _lastChild, _branchSet);
                    break;
                }
                case COMPOSITE_WHILE: {
                    compositeInstruction = new CompositeWhileInstruction(_methodModel, _firstChild, _lastChild, _branchSet);
                    break;
                }
                case COMPOSITE_FOR_ECLIPSE: {
                    compositeInstruction = new CompositeForEclipseInstruction(_methodModel, _firstChild, _lastChild, _branchSet);
                    break;
                }
                case COMPOSITE_ARBITRARY_SCOPE: {
                    compositeInstruction = new CompositeArbitraryScopeInstruction(_methodModel, _firstChild, _lastChild, _branchSet);
                    break;
                }
                case COMPOSITE_EMPTY_LOOP: {
                    compositeInstruction = new CompositeEmptyLoopInstruction(_methodModel, _firstChild, _lastChild, _branchSet);
                    break;
                }
                case COMPOSITE_DO_WHILE: {
                    compositeInstruction = new CompositeDoWhileInstruction(_methodModel, _firstChild, _lastChild, _branchSet);
                }
            }
            return compositeInstruction;
        }

        public BranchSet getBranchSet() {
            return this.branchSet;
        }
    }

    public static enum ByteCode {
        NOP(null, LoadSpec.NONE, StoreSpec.NONE, ImmediateSpec.NONE, PopSpec.NONE, PushSpec.NONE, Operator.NONE),
        ACONST_NULL(I_ACONST_NULL.class, PushSpec.N),
        ICONST_M1(I_ICONST_M1.class, PushSpec.I),
        ICONST_0(I_ICONST_0.class, PushSpec.I),
        ICONST_1(I_ICONST_1.class, PushSpec.I),
        ICONST_2(I_ICONST_2.class, PushSpec.I),
        ICONST_3(I_ICONST_3.class, PushSpec.I),
        ICONST_4(I_ICONST_4.class, PushSpec.I),
        ICONST_5(I_ICONST_5.class, PushSpec.I),
        LCONST_0(I_LCONST_0.class, PushSpec.L),
        LCONST_1(I_LCONST_1.class, PushSpec.L),
        FCONST_0(I_FCONST_0.class, PushSpec.F),
        FCONST_1(I_FCONST_1.class, PushSpec.F),
        FCONST_2(I_FCONST_2.class, PushSpec.F),
        DCONST_0(I_DCONST_0.class, PushSpec.D),
        DCONST_1(I_DCONST_1.class, PushSpec.D),
        BIPUSH(I_BIPUSH.class, ImmediateSpec.Bconst, PushSpec.I),
        SIPUSH(I_SIPUSH.class, ImmediateSpec.Sconst, PushSpec.I),
        LDC(I_LDC.class, ImmediateSpec.Bcpci, PushSpec.IorForS),
        LDC_W(I_LDC_W.class, ImmediateSpec.Scpci, PushSpec.IorForS),
        LDC2_W(I_LDC2_W.class, ImmediateSpec.Scpci, PushSpec.LorD),
        ILOAD(I_ILOAD.class, LoadSpec.I, ImmediateSpec.Blvti, PushSpec.I),
        LLOAD(I_LLOAD.class, LoadSpec.L, ImmediateSpec.Blvti, PushSpec.L),
        FLOAD(I_FLOAD.class, LoadSpec.F, ImmediateSpec.Blvti, PushSpec.F),
        DLOAD(I_DLOAD.class, LoadSpec.F, ImmediateSpec.Blvti, PushSpec.D),
        ALOAD(I_ALOAD.class, LoadSpec.A, ImmediateSpec.Blvti, PushSpec.O),
        ILOAD_0(I_ILOAD_0.class, LoadSpec.I, PushSpec.I),
        ILOAD_1(I_ILOAD_1.class, LoadSpec.I, PushSpec.I),
        ILOAD_2(I_ILOAD_2.class, LoadSpec.I, PushSpec.I),
        ILOAD_3(I_ILOAD_3.class, LoadSpec.I, PushSpec.I),
        LLOAD_0(I_LLOAD_0.class, LoadSpec.L, PushSpec.L),
        LLOAD_1(I_LLOAD_1.class, LoadSpec.L, PushSpec.L),
        LLOAD_2(I_LLOAD_2.class, LoadSpec.L, PushSpec.L),
        LLOAD_3(I_LLOAD_3.class, LoadSpec.L, PushSpec.L),
        FLOAD_0(I_FLOAD_0.class, LoadSpec.F, PushSpec.F),
        FLOAD_1(I_FLOAD_1.class, LoadSpec.F, PushSpec.F),
        FLOAD_2(I_FLOAD_2.class, LoadSpec.F, PushSpec.F),
        FLOAD_3(I_FLOAD_3.class, LoadSpec.F, PushSpec.F),
        DLOAD_0(I_DLOAD_0.class, LoadSpec.D, PushSpec.D),
        DLOAD_1(I_DLOAD_1.class, LoadSpec.D, PushSpec.D),
        DLOAD_2(I_DLOAD_2.class, LoadSpec.D, PushSpec.D),
        DLOAD_3(I_DLOAD_3.class, LoadSpec.D, PushSpec.D),
        ALOAD_0(I_ALOAD_0.class, LoadSpec.A, PushSpec.O),
        ALOAD_1(I_ALOAD_1.class, LoadSpec.A, PushSpec.O),
        ALOAD_2(I_ALOAD_2.class, LoadSpec.A, PushSpec.O),
        ALOAD_3(I_ALOAD_3.class, LoadSpec.A, PushSpec.O),
        IALOAD(I_IALOAD.class, PopSpec.AI, PushSpec.I),
        LALOAD(I_LALOAD.class, PopSpec.AI, PushSpec.L),
        FALOAD(I_FALOAD.class, PopSpec.AI, PushSpec.F),
        DALOAD(I_DALOAD.class, PopSpec.AI, PushSpec.D),
        AALOAD(I_AALOAD.class, PopSpec.AI, PushSpec.A),
        BALOAD(I_BALOAD.class, PopSpec.AI, PushSpec.I),
        CALOAD(I_CALOAD.class, PopSpec.AI, PushSpec.I),
        SALOAD(I_SALOAD.class, PopSpec.AI, PushSpec.I),
        ISTORE(I_ISTORE.class, StoreSpec.I, ImmediateSpec.Blvti, PopSpec.I),
        LSTORE(I_LSTORE.class, StoreSpec.L, ImmediateSpec.Blvti, PopSpec.L),
        FSTORE(I_FSTORE.class, StoreSpec.F, ImmediateSpec.Blvti, PopSpec.F),
        DSTORE(I_DSTORE.class, StoreSpec.D, ImmediateSpec.Blvti, PopSpec.D),
        ASTORE(I_ASTORE.class, StoreSpec.A, ImmediateSpec.Blvti, PopSpec.O),
        ISTORE_0(I_ISTORE_0.class, StoreSpec.I, PopSpec.I),
        ISTORE_1(I_ISTORE_1.class, StoreSpec.I, PopSpec.I),
        ISTORE_2(I_ISTORE_2.class, StoreSpec.I, PopSpec.I),
        ISTORE_3(I_ISTORE_3.class, StoreSpec.I, PopSpec.I),
        LSTORE_0(I_LSTORE_0.class, StoreSpec.L, PopSpec.L),
        LSTORE_1(I_LSTORE_1.class, StoreSpec.L, PopSpec.L),
        LSTORE_2(I_LSTORE_2.class, StoreSpec.L, PopSpec.L),
        LSTORE_3(I_LSTORE_3.class, StoreSpec.L, PopSpec.L),
        FSTORE_0(I_FSTORE_0.class, StoreSpec.F, PopSpec.F),
        FSTORE_1(I_FSTORE_1.class, StoreSpec.F, PopSpec.F),
        FSTORE_2(I_FSTORE_2.class, StoreSpec.F, PopSpec.F),
        FSTORE_3(I_FSTORE_3.class, StoreSpec.F, PopSpec.F),
        DSTORE_0(I_DSTORE_0.class, StoreSpec.D, PopSpec.D),
        DSTORE_1(I_DSTORE_1.class, StoreSpec.D, PopSpec.D),
        DSTORE_2(I_DSTORE_2.class, StoreSpec.D, PopSpec.D),
        DSTORE_3(I_DSTORE_3.class, StoreSpec.D, PopSpec.D),
        ASTORE_0(I_ASTORE_0.class, StoreSpec.A, PopSpec.O),
        ASTORE_1(I_ASTORE_1.class, StoreSpec.A, PopSpec.O),
        ASTORE_2(I_ASTORE_2.class, StoreSpec.A, PopSpec.O),
        ASTORE_3(I_ASTORE_3.class, StoreSpec.A, PopSpec.O),
        IASTORE(I_IASTORE.class, PopSpec.AII),
        LASTORE(I_LASTORE.class, PopSpec.AIL),
        FASTORE(I_FASTORE.class, PopSpec.AIF),
        DASTORE(I_DASTORE.class, PopSpec.AID),
        AASTORE(I_AASTORE.class, PopSpec.AIO),
        BASTORE(I_BASTORE.class, PopSpec.AIB),
        CASTORE(I_CASTORE.class, PopSpec.AIC),
        SASTORE(I_SASTORE.class, PopSpec.AIS),
        POP(I_POP.class, PopSpec.I),
        POP2(I_POP2.class, PopSpec.II),
        DUP(I_DUP.class, PopSpec.I, PushSpec.II),
        DUP_X1(I_DUP_X1.class, PopSpec.II, PushSpec.III),
        DUP_X2(I_DUP_X2.class, PopSpec.III, PushSpec.IIII),
        DUP2(I_DUP2.class, PopSpec.II, PushSpec.IIII),
        DUP2_X1(I_DUP2_X1.class, PopSpec.III, PushSpec.IIIII),
        DUP2_X2(I_DUP2_X2.class, PopSpec.IIII, PushSpec.IIIIII),
        SWAP(I_SWAP.class, PopSpec.II, PushSpec.II),
        IADD(I_IADD.class, PopSpec.II, PushSpec.I, Operator.Add),
        LADD(I_LADD.class, PopSpec.LL, PushSpec.L, Operator.Add),
        FADD(I_FADD.class, PopSpec.FF, PushSpec.F, Operator.Add),
        DADD(I_DADD.class, PopSpec.DD, PushSpec.D, Operator.Add),
        ISUB(I_ISUB.class, PopSpec.II, PushSpec.I, Operator.Sub),
        LSUB(I_LSUB.class, PopSpec.LL, PushSpec.L, Operator.Sub),
        FSUB(I_FSUB.class, PopSpec.FF, PushSpec.F, Operator.Sub),
        DSUB(I_DSUB.class, PopSpec.DD, PushSpec.D, Operator.Sub),
        IMUL(I_IMUL.class, PopSpec.II, PushSpec.I, Operator.Mul),
        LMUL(I_LMUL.class, PopSpec.LL, PushSpec.L, Operator.Mul),
        FMUL(I_FMUL.class, PopSpec.FF, PushSpec.F, Operator.Mul),
        DMUL(I_DMUL.class, PopSpec.DD, PushSpec.D, Operator.Mul),
        IDIV(I_IDIV.class, PopSpec.II, PushSpec.I, Operator.Div),
        LDIV(I_LDIV.class, PopSpec.LL, PushSpec.L, Operator.Div),
        FDIV(I_FDIV.class, PopSpec.FF, PushSpec.F, Operator.Div),
        DDIV(I_DDIV.class, PopSpec.DD, PushSpec.D, Operator.Div),
        IREM(I_IREM.class, PopSpec.II, PushSpec.I, Operator.Rem),
        LREM(I_LREM.class, PopSpec.LL, PushSpec.L, Operator.Rem),
        FREM(I_FREM.class, PopSpec.FF, PushSpec.F, Operator.Rem),
        DREM(I_DREM.class, PopSpec.DD, PushSpec.D, Operator.Rem),
        INEG(I_INEG.class, PopSpec.I, PushSpec.I, Operator.Neg),
        LNEG(I_LNEG.class, PopSpec.L, PushSpec.L, Operator.Neg),
        FNEG(I_FNEG.class, PopSpec.F, PushSpec.F, Operator.Neg),
        DNEG(I_DNEG.class, PopSpec.D, PushSpec.D, Operator.Neg),
        ISHL(I_ISHL.class, PopSpec.II, PushSpec.I, Operator.LeftShift),
        LSHL(I_LSHL.class, PopSpec.LI, PushSpec.L, Operator.LeftShift),
        ISHR(I_ISHR.class, PopSpec.II, PushSpec.I, Operator.LogicalRightShift),
        LSHR(I_LSHR.class, PopSpec.LI, PushSpec.L, Operator.LogicalRightShift),
        IUSHR(I_IUSHR.class, PopSpec.II, PushSpec.I, Operator.ArithmeticRightShift),
        LUSHR(I_LUSHR.class, PopSpec.LI, PushSpec.L, Operator.ArithmeticRightShift),
        IAND(I_IAND.class, PopSpec.II, PushSpec.I, Operator.BitwiseAnd),
        LAND(I_LAND.class, PopSpec.LL, PushSpec.L, Operator.BitwiseAnd),
        IOR(I_IOR.class, PopSpec.II, PushSpec.I, Operator.BitwiseOr),
        LOR(I_LOR.class, PopSpec.LL, PushSpec.L, Operator.BitwiseOr),
        IXOR(I_IXOR.class, PopSpec.II, PushSpec.I, Operator.BitwiseXor),
        LXOR(I_LXOR.class, PopSpec.LL, PushSpec.L, Operator.BitwiseXor),
        IINC(I_IINC.class, ImmediateSpec.BlvtiBconst),
        I2L(I_I2L.class, PopSpec.I, PushSpec.L, Operator.I2LCast),
        I2F(I_I2F.class, PopSpec.I, PushSpec.F, Operator.I2FCast),
        I2D(I_I2D.class, PopSpec.I, PushSpec.D, Operator.I2DCast),
        L2I(I_L2I.class, PopSpec.L, PushSpec.I, Operator.L2ICast),
        L2F(I_L2F.class, PopSpec.L, PushSpec.F, Operator.L2FCast),
        L2D(I_L2D.class, PopSpec.L, PushSpec.D, Operator.L2DCast),
        F2I(I_F2I.class, PopSpec.F, PushSpec.I, Operator.F2ICast),
        F2L(I_F2L.class, PopSpec.F, PushSpec.L, Operator.F2LCast),
        F2D(I_F2D.class, PopSpec.F, PushSpec.D, Operator.F2DCast),
        D2I(I_D2I.class, PopSpec.D, PushSpec.I, Operator.D2ICast),
        D2L(I_D2L.class, PopSpec.D, PushSpec.L, Operator.D2LCast),
        D2F(I_D2F.class, PopSpec.D, PushSpec.F, Operator.D2FCast),
        I2B(I_I2B.class, PopSpec.I, PushSpec.I, Operator.I2BCast),
        I2C(I_I2C.class, PopSpec.I, PushSpec.I, Operator.I2CCast),
        I2S(I_I2S.class, PopSpec.I, PushSpec.I, Operator.I2SCast),
        LCMP(I_LCMP.class, PopSpec.LL, PushSpec.I, Operator.Sub),
        FCMPL(I_FCMPL.class, PopSpec.FF, PushSpec.I, Operator.LessThan),
        FCMPG(I_FCMPG.class, PopSpec.FF, PushSpec.I, Operator.GreaterThan),
        DCMPL(I_DCMPL.class, PopSpec.DD, PushSpec.I, Operator.LessThan),
        DCMPG(I_DCMPG.class, PopSpec.DD, PushSpec.I, Operator.GreaterThan),
        IFEQ(I_IFEQ.class, ImmediateSpec.Spc, PopSpec.I, Operator.Equal),
        IFNE(I_IFNE.class, ImmediateSpec.Spc, PopSpec.I, Operator.NotEqual),
        IFLT(I_IFLT.class, ImmediateSpec.Spc, PopSpec.I, Operator.LessThan),
        IFGE(I_IFGE.class, ImmediateSpec.Spc, PopSpec.I, Operator.GreaterThanOrEqual),
        IFGT(I_IFGT.class, ImmediateSpec.Spc, PopSpec.I, Operator.GreaterThan),
        IFLE(I_IFLE.class, ImmediateSpec.Spc, PopSpec.I, Operator.LessThanOrEqual),
        IF_ICMPEQ(I_IF_ICMPEQ.class, ImmediateSpec.Sconst, PopSpec.II, Operator.Equal),
        IF_ICMPNE(I_IF_ICMPNE.class, ImmediateSpec.Spc, PopSpec.II, Operator.NotEqual),
        IF_ICMPLT(I_IF_ICMPLT.class, ImmediateSpec.Spc, PopSpec.II, Operator.LessThan),
        IF_ICMPGE(I_IF_ICMPGE.class, ImmediateSpec.Spc, PopSpec.II, Operator.GreaterThanOrEqual),
        IF_ICMPGT(I_IF_ICMPGT.class, ImmediateSpec.Spc, PopSpec.II, Operator.GreaterThan),
        IF_ICMPLE(I_IF_ICMPLE.class, ImmediateSpec.Spc, PopSpec.II, Operator.LessThanOrEqual),
        IF_ACMPEQ(I_IF_ACMPEQ.class, ImmediateSpec.Spc, PopSpec.OO, Operator.Equal),
        IF_ACMPNE(I_IF_ACMPNE.class, ImmediateSpec.Spc, PopSpec.OO, Operator.NotEqual),
        GOTO(I_GOTO.class, ImmediateSpec.Spc),
        JSR(I_JSR.class, ImmediateSpec.Spc, PushSpec.RA),
        RET(I_RET.class, ImmediateSpec.Bconst),
        TABLESWITCH(I_TABLESWITCH.class, ImmediateSpec.UNKNOWN, PopSpec.I),
        LOOKUPSWITCH(I_LOOKUPSWITCH.class, ImmediateSpec.UNKNOWN, PopSpec.I),
        IRETURN(I_IRETURN.class, PopSpec.I),
        LRETURN(I_LRETURN.class, PopSpec.L),
        FRETURN(I_FRETURN.class, PopSpec.F),
        DRETURN(I_DRETURN.class, PopSpec.D),
        ARETURN(I_ARETURN.class, PopSpec.O),
        RETURN(I_RETURN.class, LoadSpec.NONE, StoreSpec.NONE, ImmediateSpec.NONE, PopSpec.NONE, PushSpec.NONE, Operator.NONE),
        GETSTATIC(I_GETSTATIC.class, ImmediateSpec.Scpfi, PushSpec.UNKNOWN),
        PUTSTATIC(I_PUTSTATIC.class, ImmediateSpec.Scpfi, PopSpec.UNKNOWN),
        GETFIELD(I_GETFIELD.class, LoadSpec.NONE, StoreSpec.NONE, ImmediateSpec.Scpfi, PopSpec.O, PushSpec.UNKNOWN, Operator.NONE),
        PUTFIELD(I_PUTFIELD.class, ImmediateSpec.Scpfi, PopSpec.OUNKNOWN),
        INVOKEVIRTUAL(I_INVOKEVIRTUAL.class, LoadSpec.NONE, StoreSpec.NONE, ImmediateSpec.Scpmi, PopSpec.OARGS, PushSpec.UNKNOWN, Operator.NONE),
        INVOKESPECIAL(I_INVOKESPECIAL.class, LoadSpec.NONE, StoreSpec.NONE, ImmediateSpec.Scpmi, PopSpec.OARGS, PushSpec.UNKNOWN, Operator.NONE),
        INVOKESTATIC(I_INVOKESTATIC.class, LoadSpec.NONE, StoreSpec.NONE, ImmediateSpec.Scpmi, PopSpec.ARGS, PushSpec.UNKNOWN, Operator.NONE),
        INVOKEINTERFACE(I_INVOKEINTERFACE.class, LoadSpec.NONE, StoreSpec.NONE, ImmediateSpec.ScpmiBB, PopSpec.OARGS, PushSpec.UNKNOWN, Operator.NONE),
        INVOKEDYNAMIC(I_INVOKEDYNAMIC.class, LoadSpec.NONE, StoreSpec.NONE, ImmediateSpec.ScpmiBB, PopSpec.OARGS, PushSpec.UNKNOWN, Operator.NONE),
        NEW(I_NEW.class, ImmediateSpec.Scpci, PushSpec.O),
        NEWARRAY(I_NEWARRAY.class, LoadSpec.NONE, StoreSpec.NONE, ImmediateSpec.Bconst, PopSpec.I, PushSpec.A, Operator.NONE),
        ANEWARRAY(I_ANEWARRAY.class, LoadSpec.NONE, StoreSpec.NONE, ImmediateSpec.Sconst, PopSpec.I, PushSpec.A, Operator.NONE),
        ARRAYLENGTH(I_ARRAYLENGTH.class, PopSpec.A, PushSpec.I),
        ATHROW(I_ATHROW.class, PopSpec.O, PushSpec.O),
        CHECKCAST(I_CHECKCAST.class, LoadSpec.NONE, StoreSpec.NONE, ImmediateSpec.Scpci, PopSpec.O, PushSpec.O, Operator.NONE),
        INSTANCEOF(I_INSTANCEOF.class, LoadSpec.NONE, StoreSpec.NONE, ImmediateSpec.Scpci, PopSpec.O, PushSpec.I, Operator.NONE),
        MONITORENTER(I_MONITORENTER.class, PopSpec.O),
        MONITOREXIT(I_MONITOREXIT.class, PopSpec.O),
        WIDE(I_WIDE.class, LoadSpec.NONE, StoreSpec.NONE, ImmediateSpec.UNKNOWN, PopSpec.UNKNOWN, PushSpec.UNKNOWN, Operator.NONE),
        MULTIANEWARRAY(I_MULTIANEWARRAY.class, LoadSpec.NONE, StoreSpec.NONE, ImmediateSpec.ScpciBdim, PopSpec.UNKNOWN, PushSpec.A, Operator.NONE),
        IFNULL(I_IFNULL.class, ImmediateSpec.Spc, PopSpec.O, Operator.EqualNULL),
        IFNONNULL(I_IFNONNULL.class, ImmediateSpec.Spc, PopSpec.O, Operator.NotEqualNULL),
        GOTO_W(I_GOTO_W.class, ImmediateSpec.Ipc),
        JSR_W(I_JSR_W.class, ImmediateSpec.Ipc, PushSpec.RA),
        ILLEGAL_202,
        ILLEGAL_203,
        ILLEGAL_204,
        ILLEGAL_205,
        ILLEGAL_206,
        ILLEGAL_207,
        ILLEGAL_208,
        ILLEGAL_209,
        ILLEGAL_210,
        ILLEGAL_211,
        ILLEGAL_212,
        ILLEGAL_213,
        ILLEGAL_214,
        ILLEGAL_215,
        ILLEGAL_216,
        ILLEGAL_217,
        ILLEGAL_218,
        ILLEGAL_219,
        ILLEGAL_220,
        ILLEGAL_221,
        ILLEGAL_222,
        ILLEGAL_223,
        ILLEGAL_224,
        ILLEGAL_225,
        ILLEGAL_226,
        ILLEGAL_227,
        ILLEGAL_228,
        ILLEGAL_229,
        ILLEGAL_230,
        ILLEGAL_231,
        ILLEGAL_232,
        ILLEGAL_233,
        ILLEGAL_234,
        ILLEGAL_235,
        ILLEGAL_236,
        ILLEGAL_237,
        ILLEGAL_238,
        ILLEGAL_239,
        ILLEGAL_240,
        ILLEGAL_241,
        ILLEGAL_242,
        ILLEGAL_243,
        ILLEGAL_244,
        ILLEGAL_245,
        ILLEGAL_246,
        ILLEGAL_247,
        ILLEGAL_248,
        ILLEGAL_249,
        ILLEGAL_250,
        ILLEGAL_251,
        ILLEGAL_252,
        ILLEGAL_253,
        ILLEGAL_254,
        ILLEGAL_255,
        NONE,
        COMPOSITE_IF,
        COMPOSITE_IF_ELSE,
        COMPOSITE_FOR_SUN,
        COMPOSITE_FOR_ECLIPSE,
        COMPOSITE_ARBITRARY_SCOPE,
        COMPOSITE_WHILE,
        CLONE,
        INCREMENT,
        INLINE_ASSIGN,
        MULTI_ASSIGN,
        FAKEGOTO,
        FIELD_ARRAY_ELEMENT_INCREMENT,
        FIELD_ARRAY_ELEMENT_ASSIGN,
        HEAD,
        COMPOSITE_EMPTY_LOOP,
        COMPOSITE_DO_WHILE;

        private final Class<?> clazz;
        private final ImmediateSpec immediate;
        private final PushSpec push;
        private final PopSpec pop;
        private final Operator operator;
        private LoadSpec loadSpec;
        private StoreSpec storeSpec;
        private Constructor<?> constructor;

        private ByteCode(Class<?> _class, LoadSpec _loadSpec, StoreSpec _storeSpec, ImmediateSpec _immediate, PopSpec _pop, PushSpec _push, Operator _operator) {
            this.clazz = _class;
            this.immediate = _immediate;
            this.push = _push;
            this.pop = _pop;
            this.operator = _operator;
            this.loadSpec = _loadSpec;
            this.storeSpec = _storeSpec;
            if (this.clazz != null) {
                try {
                    this.constructor = this.clazz.getDeclaredConstructor(MethodModel.class, ByteReader.class, Boolean.TYPE);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        }

        private ByteCode(Class<?> _class, ImmediateSpec _immediate) {
            this(_class, LoadSpec.NONE, StoreSpec.NONE, _immediate, PopSpec.NONE, PushSpec.NONE, Operator.NONE);
        }

        private ByteCode(Class<?> _class, PushSpec _push) {
            this(_class, LoadSpec.NONE, StoreSpec.NONE, ImmediateSpec.NONE, PopSpec.NONE, _push, Operator.NONE);
        }

        private ByteCode(Class<?> _class, StoreSpec _store, ImmediateSpec _immediate, PopSpec _pop) {
            this(_class, LoadSpec.NONE, _store, _immediate, _pop, PushSpec.NONE, Operator.NONE);
        }

        private ByteCode(Class<?> _class, StoreSpec _store, PopSpec _pop) {
            this(_class, LoadSpec.NONE, _store, ImmediateSpec.NONE, _pop, PushSpec.NONE, Operator.NONE);
        }

        private ByteCode(Class<?> _class, ImmediateSpec _immediate, PopSpec _pop) {
            this(_class, LoadSpec.NONE, StoreSpec.NONE, _immediate, _pop, PushSpec.NONE, Operator.NONE);
        }

        private ByteCode(Class<?> _class, ImmediateSpec _immediate, PopSpec _pop, Operator _operator) {
            this(_class, LoadSpec.NONE, StoreSpec.NONE, _immediate, _pop, PushSpec.NONE, _operator);
        }

        private ByteCode(Class<?> _class, LoadSpec _load, ImmediateSpec _immediate, PushSpec _push) {
            this(_class, _load, StoreSpec.NONE, _immediate, PopSpec.NONE, _push, Operator.NONE);
        }

        private ByteCode(Class<?> _class, LoadSpec _load, PushSpec _push) {
            this(_class, _load, StoreSpec.NONE, ImmediateSpec.NONE, PopSpec.NONE, _push, Operator.NONE);
        }

        private ByteCode(Class<?> _class, ImmediateSpec _immediate, PushSpec _push) {
            this(_class, LoadSpec.NONE, StoreSpec.NONE, _immediate, PopSpec.NONE, _push, Operator.NONE);
        }

        private ByteCode(Class<?> _class, PopSpec _pop, PushSpec _push) {
            this(_class, LoadSpec.NONE, StoreSpec.NONE, ImmediateSpec.NONE, _pop, _push, Operator.NONE);
        }

        private ByteCode(Class<?> _class, PopSpec _pop, PushSpec _push, Operator _operator) {
            this(_class, LoadSpec.NONE, StoreSpec.NONE, ImmediateSpec.NONE, _pop, _push, _operator);
        }

        private ByteCode(Class<?> _class, PopSpec _pop) {
            this(_class, LoadSpec.NONE, StoreSpec.NONE, ImmediateSpec.NONE, _pop, PushSpec.NONE, Operator.NONE);
        }

        private ByteCode() {
            this(null, LoadSpec.NONE, StoreSpec.NONE, ImmediateSpec.NONE, PopSpec.NONE, PushSpec.NONE, Operator.NONE);
        }

        public int getCode() {
            return this.ordinal();
        }

        public String getName() {
            return this.name().toLowerCase();
        }

        public ImmediateSpec getImmediate() {
            return this.immediate;
        }

        public static ByteCode get(int _idx) {
            return ByteCode.values()[_idx];
        }

        public PushSpec getPush() {
            return this.push;
        }

        public PopSpec getPop() {
            return this.pop;
        }

        public boolean usesDouble() {
            PushSpec push = this.getPush();
            PopSpec pop = this.getPop();
            return push == PushSpec.D || pop == PopSpec.D || pop == PopSpec.DD || pop == PopSpec.AID;
        }

        public Instruction newInstruction(MethodModel _methodModel, ByteReader byteReader, boolean _isWide) {
            Instruction newInstruction = null;
            if (this.constructor != null) {
                try {
                    newInstruction = (Instruction)this.constructor.newInstance(_methodModel, byteReader, _isWide);
                    newInstruction.setLength(byteReader.getOffset() - newInstruction.getThisPC());
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            return newInstruction;
        }

        public static Instruction create(MethodModel _methodModel, ByteReader _byteReader) {
            ByteCode byteCode = ByteCode.get(_byteReader.u1());
            boolean isWide = false;
            if (byteCode.equals((Object)WIDE)) {
                isWide = true;
                byteCode = ByteCode.get(_byteReader.u1());
            }
            Instruction newInstruction = byteCode.newInstruction(_methodModel, _byteReader, isWide);
            return newInstruction;
        }

        public Operator getOperator() {
            return this.operator;
        }

        public LoadSpec getLoad() {
            return this.loadSpec;
        }

        public StoreSpec getStore() {
            return this.storeSpec;
        }
    }

    public static enum ImmediateSpec {
        NONE("NONE", new TypeSpec[0]),
        UNKNOWN("UNKNOWN", new TypeSpec[0]),
        Bconst("byte constant value", TypeSpec.B),
        Sconst("short constant value", TypeSpec.S),
        Bcpci("byte constant pool constant index", TypeSpec.B),
        Scpci("short constant pool constant index", TypeSpec.S),
        Icpci("int constant pool index", TypeSpec.I),
        Blvti("byte local variable table index", TypeSpec.B),
        Spc("short pc", TypeSpec.S),
        Ipc("int pc", TypeSpec.I),
        Scpfi("short constant pool field index", TypeSpec.S),
        Scpmi("short constant pool method index", TypeSpec.S),
        ScpmiBB("short constant pool method index, byte count, byte (always zero)", TypeSpec.S, TypeSpec.B, TypeSpec.B),
        ScpciBdim("short constant pool class index, byte dimensions", TypeSpec.S, TypeSpec.B),
        BlvtiBconst("byte local variable table index, byte constant value", TypeSpec.B, TypeSpec.B);

        private final String name;
        private final TypeSpec[] types;

        private ImmediateSpec(String _name, TypeSpec ... _types) {
            this.name = _name;
            this.types = _types;
        }

        public String getName() {
            return this.name;
        }

        public TypeSpec[] getTypes() {
            return this.types;
        }
    }

    public static enum PopSpec {
        NONE(new TypeSpec[0]),
        UNKNOWN(TypeSpec.UNKNOWN),
        I(TypeSpec.I),
        II(TypeSpec.I, TypeSpec.I),
        III(TypeSpec.I, TypeSpec.I, TypeSpec.I),
        IIII(TypeSpec.I, TypeSpec.I, TypeSpec.I, TypeSpec.I),
        IIIII(TypeSpec.I, TypeSpec.I, TypeSpec.I, TypeSpec.I, TypeSpec.I),
        L(TypeSpec.L),
        LL(TypeSpec.L, TypeSpec.L),
        F(TypeSpec.F),
        FF(TypeSpec.F, TypeSpec.F),
        D(TypeSpec.D),
        DD(TypeSpec.D, TypeSpec.D),
        O(TypeSpec.O),
        OO(TypeSpec.O, TypeSpec.O),
        A(TypeSpec.A),
        AI(TypeSpec.A, TypeSpec.I),
        AII(TypeSpec.A, TypeSpec.I, TypeSpec.I),
        AIF(TypeSpec.A, TypeSpec.I, TypeSpec.F),
        AID(TypeSpec.A, TypeSpec.I, TypeSpec.D),
        AIL(TypeSpec.A, TypeSpec.I, TypeSpec.L),
        AIC(TypeSpec.A, TypeSpec.I, TypeSpec.C),
        AIS(TypeSpec.A, TypeSpec.I, TypeSpec.S),
        AIB(TypeSpec.A, TypeSpec.I, TypeSpec.B),
        AIO(TypeSpec.A, TypeSpec.I, TypeSpec.O),
        LI(TypeSpec.L, TypeSpec.I),
        OUNKNOWN(TypeSpec.O, TypeSpec.UNKNOWN),
        ARGS(TypeSpec.ARGS),
        OARGS(TypeSpec.O, TypeSpec.ARGS);

        private final TypeSpec[] types;

        private PopSpec(TypeSpec ... _types) {
            this.types = _types;
        }

        public int getStackAdjust() {
            return this.types.length;
        }
    }

    public static enum PushSpec {
        NONE(new TypeSpec[0]),
        UNKNOWN(new TypeSpec[0]),
        I(TypeSpec.I),
        II(TypeSpec.I, TypeSpec.I),
        III(TypeSpec.I, TypeSpec.I, TypeSpec.I),
        IIII(TypeSpec.I, TypeSpec.I, TypeSpec.I, TypeSpec.I),
        IIIII(TypeSpec.I, TypeSpec.I, TypeSpec.I, TypeSpec.I, TypeSpec.I),
        IIIIII(TypeSpec.I, TypeSpec.I, TypeSpec.I, TypeSpec.I, TypeSpec.I, TypeSpec.I),
        L(TypeSpec.L),
        F(TypeSpec.F),
        D(TypeSpec.D),
        O(TypeSpec.O),
        A(TypeSpec.A),
        N(TypeSpec.N),
        IorForS(TypeSpec.IorForS),
        LorD(TypeSpec.LorD),
        RA(TypeSpec.RA);

        private final TypeSpec[] types;

        private PushSpec(TypeSpec ... _types) {
            this.types = _types;
        }

        public int getStackAdjust() {
            return this.types.length;
        }
    }

    public static enum Operator {
        NONE,
        LogicalOr(true, "||"),
        LogicalAnd(true, "&&", LogicalOr),
        Equal(true, "=="),
        NotEqual(true, "!=", Equal),
        LessThan(true, "<"),
        GreaterThanOrEqual(true, ">=", LessThan),
        GreaterThan(true, ">"),
        LessThanOrEqual(true, "<=", GreaterThan),
        EqualNULL(true, "NULL=="),
        NotEqualNULL(true, "NULL!=", EqualNULL),
        BitwiseOr(true, "|"),
        BitwiseAnd(true, "&"),
        BitwiseXor(true, "^"),
        LeftShift(true, "<<"),
        ArithmeticRightShift(true, ">>>"),
        LogicalRightShift(true, ">>"),
        Add(true, "+"),
        Sub(true, "-"),
        Div(true, "/"),
        Rem(true, "%"),
        Mul(true, "*"),
        Neg(false, "-"),
        Pos(false, "+"),
        I2FCast(false, "(float)"),
        I2LCast(false, "(long)"),
        I2DCast(false, "(double)"),
        L2ICast(false, "(int)"),
        L2FCast(false, "(float)"),
        L2DCast(false, "(double)"),
        F2ICast(false, "(int)"),
        F2LCast(false, "(long)"),
        F2DCast(false, "(double)"),
        D2ICast(false, "(int)"),
        D2LCast(false, "(long)"),
        D2FCast(false, "(float)"),
        I2BCast(false, "(byte)"),
        I2CCast(false, "(char)"),
        I2SCast(false, "(short)");

        private final String text;
        private final boolean binary;
        private Operator compliment;

        private Operator(boolean _binary, String _text) {
            this.text = _text;
            this.binary = _binary;
        }

        private Operator(boolean _binary, String _text, Operator _c) {
            this(_binary, _text);
            this.compliment = _c;
            this.compliment.compliment = this;
        }

        private Operator() {
            this(false, null);
        }

        public String getText() {
            return this.text;
        }

        public Operator getCompliment() {
            return this.compliment;
        }

        public String getText(boolean _invert) {
            return _invert ? this.compliment.getText() : this.getText();
        }

        public boolean isBinary() {
            return this.binary;
        }

        public boolean isUnary() {
            return !this.equals((Object)NONE) && !this.isBinary();
        }
    }

    public static enum TypeSpec {
        NONE("none", "none", 0, 0),
        Z("Z", "boolean", 4, 1),
        C("C", "char", 2, 1),
        F("F", "float", 4, 1),
        D("D", "double", 8, 2),
        B("B", "byte", 1, 1),
        S("S", "short", 2, 1),
        I("I", "int", 4, 1),
        L("L", "long", 8, 1),
        J("J", "long", 8, 1),
        A("A", "array", 4, 1),
        O("O", "object", 4, 1),
        N("N", "null", 4, 1),
        IorForS("IorForS", "int, float or String depending on constant pool entry", 4, 1),
        LorD("LorD", "long or float depending upon the constant pool entry", 8, 2),
        RA("RA", "return address", 4, 1),
        UNKNOWN("UNKNOWN", "unknown", -1, -1),
        ARGS("ARGS", "args to method call", -1, -1);

        private final String longName;
        private final String shortName;
        private final int size;
        private final int slots;

        private TypeSpec(String _shortName, String _longName, int _size, int _slots) {
            this.shortName = _shortName;
            this.longName = _longName;
            this.size = _size;
            this.slots = _slots;
        }

        public int getSize() {
            return this.size;
        }

        public int getSlots() {
            return this.slots;
        }

        public String getLongName() {
            return this.longName;
        }

        public String getShortName() {
            return this.shortName;
        }
    }

    public static enum StoreSpec {
        NONE,
        F,
        D,
        I,
        L,
        A,
        O;

    }

    public static enum LoadSpec {
        NONE,
        F,
        D,
        I,
        L,
        A,
        O;

    }
}

