/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi.internal.instruction;

import com.aparapi.internal.instruction.Instruction;
import com.aparapi.internal.instruction.InstructionSet;

public class InstructionPattern {
    public static final InstructionMatcher assignToLocalVariable = new InstructionMatcher("Assign to local variable"){

        @Override
        public InstructionMatch matches(Instruction _instruction) {
            return InstructionMatch.test(_instruction instanceof InstructionSet.AssignToLocalVariable);
        }
    };
    public static final InstructionMatcher constant = new InstructionMatcher("Constant "){

        @Override
        public InstructionMatch matches(Instruction _instruction) {
            return InstructionMatch.test(_instruction instanceof InstructionSet.Constant);
        }
    };
    public static final InstructionMatcher assignToArrayElement = new InstructionMatcher("Assign to array element"){

        @Override
        public InstructionMatch matches(Instruction _instruction) {
            return InstructionMatch.test(_instruction instanceof InstructionSet.AssignToArrayElement);
        }
    };
    public static final InstructionMatcher methodCall = new InstructionMatcher("Method Call"){

        @Override
        public InstructionMatch matches(Instruction _instruction) {
            return InstructionMatch.test(_instruction instanceof InstructionSet.MethodCall);
        }
    };
    public static final InstructionMatcher longHandIncLocalVariable = new InstructionMatcher("Long hand increment of local variable"){

        @Override
        public InstructionMatch matches(Instruction _instruction) {
            if (_instruction instanceof InstructionSet.AssignToLocalVariable) {
                InstructionSet.AssignToLocalVariable assign = (InstructionSet.AssignToLocalVariable)((Object)_instruction);
                Instruction child = ((Instruction)((Object)assign)).getFirstChild();
                if (child instanceof InstructionSet.CastOperator) {
                    child = child.getFirstChild();
                }
                if (child instanceof InstructionSet.I_IADD) {
                    InstructionSet.AccessLocalVariable access;
                    InstructionSet.I_IADD add = (InstructionSet.I_IADD)child;
                    Instruction lhs = add.getLhs();
                    Instruction rhs = add.getRhs();
                    if (lhs instanceof InstructionSet.AccessLocalVariable && (access = (InstructionSet.AccessLocalVariable)((Object)lhs)).getLocalVariableTableIndex() == assign.getLocalVariableTableIndex() && rhs instanceof InstructionSet.I_ICONST_1) {
                        return InstructionMatch.TRUE;
                    }
                }
            }
            return InstructionMatch.FALSE;
        }
    };
    public static final InstructionMatcher longHandDecLocalVariable = new InstructionMatcher("Long hand decrement of local variable"){

        @Override
        public InstructionMatch matches(Instruction _instruction) {
            if (_instruction instanceof InstructionSet.AssignToLocalVariable) {
                InstructionSet.AssignToLocalVariable assign = (InstructionSet.AssignToLocalVariable)((Object)_instruction);
                Instruction child = ((Instruction)((Object)assign)).getFirstChild();
                if (child instanceof InstructionSet.CastOperator) {
                    child = child.getFirstChild();
                }
                if (child instanceof InstructionSet.I_ISUB) {
                    InstructionSet.AccessLocalVariable access;
                    InstructionSet.I_ISUB add = (InstructionSet.I_ISUB)child;
                    Instruction lhs = add.getLhs();
                    Instruction rhs = add.getRhs();
                    if (lhs instanceof InstructionSet.AccessLocalVariable && (access = (InstructionSet.AccessLocalVariable)((Object)lhs)).getLocalVariableTableIndex() == assign.getLocalVariableTableIndex() && rhs instanceof InstructionSet.I_ICONST_1) {
                        return InstructionMatch.TRUE;
                    }
                }
            }
            return InstructionMatch.FALSE;
        }
    };
    public static final InstructionMatcher fieldPlusOne = new InstructionMatcher("Field Plus One"){

        @Override
        public InstructionMatch matches(Instruction _instruction) {
            if (_instruction instanceof InstructionSet.CastOperator) {
                InstructionSet.CastOperator topCastOperator = (InstructionSet.CastOperator)_instruction;
                _instruction = topCastOperator.getFirstChild().getReal();
            }
            if (_instruction instanceof InstructionSet.I_IADD) {
                InstructionSet.I_IADD add = (InstructionSet.I_IADD)_instruction;
                Instruction addLhs = add.getLhs().getReal();
                Instruction addRhs = add.getRhs().getReal();
                if (addLhs instanceof InstructionSet.AccessInstanceField && addRhs instanceof InstructionSet.I_ICONST_1) {
                    return InstructionMatch.TRUE;
                }
            }
            return InstructionMatch.FALSE;
        }
    };
    public static final InstructionMatcher fieldMinusOne = new InstructionMatcher("Field minus 1"){

        @Override
        public InstructionMatch matches(Instruction _instruction) {
            if (_instruction instanceof InstructionSet.CastOperator) {
                InstructionSet.CastOperator topCastOperator = (InstructionSet.CastOperator)_instruction;
                _instruction = topCastOperator.getFirstChild().getReal();
            }
            if (_instruction instanceof InstructionSet.I_ISUB) {
                InstructionSet.I_ISUB add = (InstructionSet.I_ISUB)_instruction;
                Instruction addLhs = add.getLhs().getReal();
                Instruction addRhs = add.getRhs().getReal();
                if (addLhs instanceof InstructionSet.AccessInstanceField && addRhs instanceof InstructionSet.I_ICONST_1) {
                    return InstructionMatch.TRUE;
                }
            }
            return InstructionMatch.FALSE;
        }
    };
    public static final InstructionMatcher fieldArrayElementAccess = new InstructionMatcher("Field array element access"){

        @Override
        public InstructionMatch matches(Instruction _instruction) {
            InstructionSet.AccessArrayElement accessArrayElement;
            Instruction addLhs;
            if (_instruction instanceof InstructionSet.AccessArrayElement && (addLhs = (accessArrayElement = (InstructionSet.AccessArrayElement)_instruction).getArrayRef().getReal()) instanceof InstructionSet.AccessInstanceField) {
                return InstructionMatch.TRUE;
            }
            return InstructionMatch.FALSE;
        }
    };
    public static final InstructionMatcher fieldArrayElementPlusOne = new InstructionMatcher("field array element plus one"){

        @Override
        public InstructionMatch matches(Instruction _instruction) {
            InstructionSet.I_IADD accessArrayElement;
            if (_instruction instanceof InstructionSet.I_IADD && (accessArrayElement = (InstructionSet.I_IADD)_instruction).getLhs() != null) {
                Instruction addRhs;
                Instruction addLhs = accessArrayElement.getLhs().getReal();
                if (InstructionPattern.fieldArrayElementAccess.matches((Instruction)addLhs).ok && (addRhs = accessArrayElement.getRhs().getReal()) instanceof InstructionSet.I_ICONST_1) {
                    return InstructionMatch.TRUE;
                }
            }
            return InstructionMatch.FALSE;
        }
    };
    public static final InstructionMatcher fieldArrayElementMinusOne = new InstructionMatcher("field array element minus one"){

        @Override
        public InstructionMatch matches(Instruction _instruction) {
            if (_instruction instanceof InstructionSet.I_ISUB) {
                Instruction addRhs;
                InstructionSet.I_ISUB accessArrayElement = (InstructionSet.I_ISUB)_instruction;
                Instruction addLhs = accessArrayElement.getLhs().getReal();
                if (InstructionPattern.fieldArrayElementAccess.matches((Instruction)addLhs).ok && (addRhs = accessArrayElement.getRhs().getReal()) instanceof InstructionSet.I_ICONST_1) {
                    return InstructionMatch.TRUE;
                }
            }
            return InstructionMatch.FALSE;
        }
    };
    public static final InstructionMatcher longHandFieldArrayElementIncrement = new InstructionMatcher("long hand field array element increment"){

        @Override
        public InstructionMatch matches(Instruction _instruction) {
            if (_instruction instanceof InstructionSet.AssignToArrayElement) {
                InstructionSet.AssignToArrayElement accessArrayElement = (InstructionSet.AssignToArrayElement)_instruction;
                Instruction arrayRef = accessArrayElement.getArrayRef().getReal();
                Instruction value = accessArrayElement.getValue().getReal();
                if (arrayRef instanceof InstructionSet.AccessInstanceField && InstructionPattern.fieldArrayElementPlusOne.matches((Instruction)value).ok) {
                    return InstructionMatch.TRUE;
                }
            }
            return InstructionMatch.FALSE;
        }
    };
    public static final InstructionMatcher longHandFieldArrayElementDecrement = new InstructionMatcher("long hand field array element decrement"){

        @Override
        public InstructionMatch matches(Instruction _instruction) {
            if (_instruction instanceof InstructionSet.AssignToArrayElement) {
                InstructionSet.AssignToArrayElement accessArrayElement = (InstructionSet.AssignToArrayElement)_instruction;
                Instruction arrayRef = accessArrayElement.getArrayRef().getReal();
                Instruction value = accessArrayElement.getValue().getReal();
                if (arrayRef instanceof InstructionSet.AccessInstanceField && InstructionPattern.fieldArrayElementMinusOne.matches((Instruction)value).ok) {
                    return InstructionMatch.TRUE;
                }
            }
            return InstructionMatch.FALSE;
        }
    };
    public static final InstructionMatcher accessLocalVariable = new InstructionMatcher("access to local variable"){

        @Override
        InstructionMatch matches(Instruction _instruction) {
            return InstructionMatch.test(_instruction instanceof InstructionSet.AccessLocalVariable);
        }
    };
    public static final InstructionMatcher inc = new InstructionMatcher("inc"){

        @Override
        InstructionMatch matches(Instruction _instruction) {
            return InstructionMatch.test(_instruction instanceof InstructionSet.I_IINC);
        }
    };
    public static final InstructionMatcher cast = new InstructionMatcher("cast"){

        @Override
        InstructionMatch matches(Instruction _instruction) {
            return InstructionMatch.test(_instruction instanceof InstructionSet.CastOperator);
        }
    };
    public static final InstructionMatcher accessInstanceField = new InstructionMatcher("access instance field"){

        @Override
        InstructionMatch matches(Instruction _instruction) {
            return InstructionMatch.test(_instruction instanceof InstructionSet.AccessInstanceField);
        }
    };
    public static final InstructionMatcher assignToInstanceField = new InstructionMatcher("assign to instance field"){

        @Override
        InstructionMatch matches(Instruction _instruction) {
            return InstructionMatch.test(_instruction instanceof InstructionSet.AssignToInstanceField);
        }
    };
    public static final InstructionMatcher iadd = new InstructionMatcher("iadd"){

        @Override
        InstructionMatch matches(Instruction _instruction) {
            return InstructionMatch.test(_instruction instanceof InstructionSet.I_IADD);
        }
    };

    private boolean compareSubTrees(Instruction _lhs, Instruction _rhs) {
        boolean same = (_lhs = _lhs.getReal()).sameAs(_rhs = _rhs.getReal());
        if (same) {
            Instruction lhsChild = _lhs.getFirstChild();
            Instruction rhsChild = _rhs.getFirstChild();
            while (same && lhsChild != null && rhsChild != null) {
                if (!(same = same && this.compareSubTrees(lhsChild, rhsChild))) continue;
                rhsChild = rhsChild.getNextExpr();
                lhsChild = lhsChild.getNextExpr();
            }
            same = same && lhsChild == rhsChild;
        }
        return same;
    }

    public class AssignableInstructionMatcher
    extends InstructionMatcher {
        private final Class<?>[] classes;

        public AssignableInstructionMatcher(Class<?> ... _classes) {
            super("AssignableInstructionMatcher");
            this.classes = _classes;
        }

        @Override
        public InstructionMatch matches(Instruction _instruction) {
            for (Class<?> c : this.classes) {
                if (!c.isAssignableFrom(_instruction.getClass())) continue;
                return InstructionMatch.TRUE;
            }
            return InstructionMatch.TRUE;
        }
    }

    public static abstract class InstructionMatcher {
        private final String description;

        abstract InstructionMatch matches(Instruction var1);

        public InstructionMatch matches(Instruction _instruction, InstructionMatcher _instructionMatcher) {
            if (this.matches((Instruction)_instruction.getReal()).ok && _instruction.getNextExpr() != null) {
                return _instructionMatcher.matches(_instruction.getNextExpr().getReal());
            }
            return InstructionMatch.FALSE;
        }

        public InstructionMatcher(String _description) {
            this.description = _description;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static class InstructionMatch {
        public final boolean ok;
        public static final InstructionMatch TRUE = new InstructionMatch(true);
        public static final InstructionMatch FALSE = new InstructionMatch(false);

        public InstructionMatch(boolean _ok) {
            this.ok = _ok;
        }

        public static InstructionMatch test(boolean _condition) {
            return _condition ? TRUE : FALSE;
        }
    }
}

