/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi.internal.instruction;

import com.aparapi.internal.instruction.InstructionSet;
import com.aparapi.internal.model.MethodModel;
import com.aparapi.internal.reader.ByteReader;
import java.util.LinkedList;

public abstract class Instruction {
    protected MethodModel method;
    private final InstructionSet.ByteCode byteCode;
    private int length;
    protected int pc;
    private Instruction nextPC = null;
    private Instruction prevPC = null;
    private Instruction nextExpr = null;
    private Instruction prevExpr = null;
    private Instruction parentExpr = null;
    private LinkedList<InstructionSet.ConditionalBranch> forwardConditionalBranchTargets;
    private LinkedList<InstructionSet.ConditionalBranch> reverseConditionalBranchTargets;
    private LinkedList<InstructionSet.Branch> forwardUnconditionalBranchTargets;
    private LinkedList<InstructionSet.Branch> reverseUnconditionalBranchTargets;
    private Instruction firstChild = null;
    private Instruction lastChild = null;

    abstract String getDescription();

    public void setChildren(Instruction _firstChild, Instruction _lastChild) {
        if (_firstChild == null || _lastChild == null) {
            throw new IllegalStateException("null children added");
        }
        this.firstChild = _firstChild;
        this.lastChild = _lastChild;
        for (Instruction i = this.firstChild; i != this.lastChild; i = i.getNextExpr()) {
            if (i == null) {
                throw new IllegalStateException("child list broken ");
            }
            i.setParentExpr(this);
        }
        this.lastChild.setParentExpr(this);
    }

    public Instruction getPrevExpr() {
        return this.prevExpr;
    }

    public Instruction getNextExpr() {
        return this.nextExpr;
    }

    public void setNextPC(Instruction _nextByPC) {
        this.nextPC = _nextByPC;
    }

    public void setPrevPC(Instruction _prevByPC) {
        this.prevPC = _prevByPC;
    }

    public void setPrevExpr(Instruction _prevExpr) {
        this.prevExpr = _prevExpr;
    }

    public void setNextExpr(Instruction _nextExpr) {
        this.nextExpr = _nextExpr;
    }

    public Instruction toInstruction() {
        return this;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int _length) {
        this.length = _length;
    }

    public final InstructionSet.ByteCode getByteCode() {
        return this.byteCode;
    }

    public int getThisPC() {
        return this.pc;
    }

    public int getStartPC() {
        return this.getFirstChild() == null ? this.pc : this.getFirstChild().getStartPC();
    }

    protected Instruction(MethodModel _method, InstructionSet.ByteCode _byteCode, int _pc) {
        this.method = _method;
        this.pc = _pc;
        this.byteCode = _byteCode;
    }

    protected Instruction(MethodModel _method, InstructionSet.ByteCode _byteCode, ByteReader _byteReader, boolean _wide) {
        this(_method, _byteCode, _wide ? _byteReader.getOffset() - 2 : _byteReader.getOffset() - 1);
    }

    public int getStackConsumeCount() {
        return this.byteCode.getPop().getStackAdjust();
    }

    public int getStackProduceCount() {
        return this.byteCode.getPush().getStackAdjust();
    }

    public int getStackDelta() {
        return this.getStackProduceCount() - this.getStackConsumeCount();
    }

    public String toString() {
        return this.pc + " " + this.byteCode.getName();
    }

    public boolean isBranch() {
        return this instanceof InstructionSet.Branch;
    }

    public int compareTo(Instruction _other) {
        return this.pc - _other.pc;
    }

    public boolean isAfter(Instruction _other) {
        return this.compareTo(_other) > 0;
    }

    public boolean isAfterOrEqual(Instruction _other) {
        return this.compareTo(_other) >= 0;
    }

    public boolean isBefore(Instruction _other) {
        return this.compareTo(_other) < 0;
    }

    public boolean isBeforeOrEqual(Instruction _other) {
        return this.compareTo(_other) <= 0;
    }

    public Instruction getFirstChild() {
        return this.firstChild;
    }

    public Instruction getLastChild() {
        return this.lastChild;
    }

    public Instruction getStartInstruction() {
        return this.getFirstChild() == null ? this : this.getFirstChild().getStartInstruction();
    }

    public MethodModel getMethod() {
        return this.method;
    }

    public Instruction getNextPC() {
        return this.nextPC;
    }

    public Instruction getPrevPC() {
        return this.prevPC;
    }

    public void setParentExpr(Instruction _parentExpr) {
        this.parentExpr = _parentExpr;
    }

    public Instruction getParentExpr() {
        return this.parentExpr;
    }

    public Instruction getRootExpr() {
        return this.parentExpr == null ? this : this.parentExpr.getRootExpr();
    }

    public boolean isReverseConditionalBranchTarget() {
        return this.reverseConditionalBranchTargets != null && this.reverseConditionalBranchTargets.size() > 0;
    }

    public boolean isForwardConditionalBranchTarget() {
        return this.forwardConditionalBranchTargets != null && this.forwardConditionalBranchTargets.size() > 0;
    }

    public boolean isReverseUnconditionalBranchTarget() {
        return this.reverseUnconditionalBranchTargets != null && this.reverseUnconditionalBranchTargets.size() > 0;
    }

    public boolean isForwardUnconditionalBranchTarget() {
        return this.forwardUnconditionalBranchTargets != null && this.forwardUnconditionalBranchTargets.size() > 0;
    }

    public boolean isReverseBranchTarget() {
        return this.isReverseConditionalBranchTarget() || this.isReverseUnconditionalBranchTarget();
    }

    public boolean isConditionalBranchTarget() {
        return this.isReverseConditionalBranchTarget() || this.isForwardConditionalBranchTarget();
    }

    public boolean isUnconditionalBranchTarget() {
        return this.isReverseUnconditionalBranchTarget() || this.isForwardUnconditionalBranchTarget();
    }

    public boolean isForwardBranchTarget() {
        return this.isForwardConditionalBranchTarget() || this.isForwardUnconditionalBranchTarget();
    }

    public boolean isBranchTarget() {
        return this.isForwardBranchTarget() || this.isReverseBranchTarget();
    }

    public boolean producesStack() {
        return this instanceof InstructionSet.CompositeInstruction || this.getStackProduceCount() > 0;
    }

    public Instruction getReal() {
        return this;
    }

    public InstructionSet.Branch asBranch() {
        return (InstructionSet.Branch)this;
    }

    public boolean consumesStack() {
        return this.getStackConsumeCount() > 0;
    }

    public void addBranchTarget(InstructionSet.Branch _branch) {
        if (_branch.isReverse()) {
            if (_branch.isConditional()) {
                if (this.reverseConditionalBranchTargets == null) {
                    this.reverseConditionalBranchTargets = new LinkedList();
                }
                this.reverseConditionalBranchTargets.add((InstructionSet.ConditionalBranch)_branch);
            } else {
                if (this.reverseUnconditionalBranchTargets == null) {
                    this.reverseUnconditionalBranchTargets = new LinkedList();
                }
                this.reverseUnconditionalBranchTargets.add(_branch);
            }
        } else if (_branch.isConditional()) {
            if (this.forwardConditionalBranchTargets == null) {
                this.forwardConditionalBranchTargets = new LinkedList();
            }
            this.forwardConditionalBranchTargets.add((InstructionSet.ConditionalBranch)_branch);
        } else {
            if (this.forwardUnconditionalBranchTargets == null) {
                this.forwardUnconditionalBranchTargets = new LinkedList();
            }
            this.forwardUnconditionalBranchTargets.add(_branch);
        }
    }

    public void removeBranchTarget(InstructionSet.Branch _branch) {
        if (_branch.isReverse()) {
            if (_branch.isConditional()) {
                if (this.reverseConditionalBranchTargets != null) {
                    this.reverseConditionalBranchTargets.remove(_branch);
                    if (this.reverseConditionalBranchTargets.size() == 0) {
                        this.reverseConditionalBranchTargets = null;
                    }
                }
            } else if (this.reverseUnconditionalBranchTargets != null) {
                this.reverseUnconditionalBranchTargets.remove(_branch);
                if (this.reverseUnconditionalBranchTargets.size() == 0) {
                    this.reverseUnconditionalBranchTargets = null;
                }
            }
        } else if (_branch.isConditional()) {
            if (this.forwardConditionalBranchTargets != null) {
                this.forwardConditionalBranchTargets.remove(_branch);
                if (this.forwardConditionalBranchTargets.size() == 0) {
                    this.forwardConditionalBranchTargets = null;
                }
            }
        } else if (this.forwardUnconditionalBranchTargets != null) {
            this.forwardUnconditionalBranchTargets.remove(_branch);
            if (this.forwardUnconditionalBranchTargets.size() == 0) {
                this.forwardUnconditionalBranchTargets = null;
            }
        }
    }

    public LinkedList<InstructionSet.Branch> getForwardUnconditionalBranches() {
        return this.forwardUnconditionalBranchTargets;
    }

    public LinkedList<InstructionSet.ConditionalBranch> getForwardConditionalBranches() {
        return this.forwardConditionalBranchTargets;
    }

    public LinkedList<InstructionSet.Branch> getReverseUnconditionalBranches() {
        return this.reverseUnconditionalBranchTargets;
    }

    public LinkedList<InstructionSet.ConditionalBranch> getReverseConditionalBranches() {
        return this.reverseConditionalBranchTargets;
    }

    public boolean isForwardBranch() {
        return this.isBranch() && this.asBranch().isForward();
    }

    public boolean sameAs(Instruction _other) {
        return this.equals(_other);
    }
}

