/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi.device;

import com.aparapi.Range;
import com.aparapi.device.Device;
import com.aparapi.internal.opencl.OpenCLArgDescriptor;
import com.aparapi.internal.opencl.OpenCLKernel;
import com.aparapi.internal.opencl.OpenCLPlatform;
import com.aparapi.internal.opencl.OpenCLProgram;
import com.aparapi.opencl.OpenCL;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OpenCLDevice
extends Device {
    private final OpenCLPlatform platform;
    private final long deviceId;
    private int maxComputeUnits;
    private long localMemSize;
    private long globalMemSize;
    private long maxMemAllocSize;
    private String shortDescription = null;
    private String name = null;

    public OpenCLDevice(OpenCLPlatform _platform, long _deviceId, Device.TYPE _type) {
        this.platform = _platform;
        this.deviceId = _deviceId;
        this.type = _type;
    }

    public OpenCLPlatform getOpenCLPlatform() {
        return this.platform;
    }

    public int getMaxComputeUnits() {
        return this.maxComputeUnits;
    }

    public void setMaxComputeUnits(int _maxComputeUnits) {
        this.maxComputeUnits = _maxComputeUnits;
    }

    public long getLocalMemSize() {
        return this.localMemSize;
    }

    public void setLocalMemSize(long _localMemSize) {
        this.localMemSize = _localMemSize;
    }

    public long getMaxMemAllocSize() {
        return this.maxMemAllocSize;
    }

    public void setMaxMemAllocSize(long _maxMemAllocSize) {
        this.maxMemAllocSize = _maxMemAllocSize;
    }

    public long getGlobalMemSize() {
        return this.globalMemSize;
    }

    public void setGlobalMemSize(long _globalMemSize) {
        this.globalMemSize = _globalMemSize;
    }

    void setMaxWorkItemSize(int _dim, int _value) {
        this.maxWorkItemSize[_dim] = _value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public long getDeviceId() {
        return this.deviceId;
    }

    @Override
    public String getShortDescription() {
        if (this.shortDescription == null) {
            String vendor = this.platform.getName();
            String[] split = vendor.split("[\\s\\(\\)]");
            this.shortDescription = split[0] + "<" + (Object)((Object)this.getType()) + ">";
        }
        return this.shortDescription;
    }

    public List<OpenCLArgDescriptor> getArgs(Method m) {
        ArrayList<OpenCLArgDescriptor> args = new ArrayList<OpenCLArgDescriptor>();
        Annotation[][] parameterAnnotations = m.getParameterAnnotations();
        Class<?>[] parameterTypes = m.getParameterTypes();
        for (int arg = 0; arg < parameterTypes.length; ++arg) {
            if (parameterTypes[arg].isAssignableFrom(Range.class)) continue;
            long bits = 0L;
            String name = null;
            for (Annotation pa : parameterAnnotations[arg]) {
                if (pa instanceof OpenCL.GlobalReadOnly) {
                    name = ((OpenCL.GlobalReadOnly)pa).value();
                    bits |= 0x900L;
                    continue;
                }
                if (pa instanceof OpenCL.GlobalWriteOnly) {
                    name = ((OpenCL.GlobalWriteOnly)pa).value();
                    bits |= 0x1100L;
                    continue;
                }
                if (pa instanceof OpenCL.GlobalReadWrite) {
                    name = ((OpenCL.GlobalReadWrite)pa).value();
                    bits |= 0x2100L;
                    continue;
                }
                if (pa instanceof OpenCL.Local) {
                    name = ((OpenCL.Local)pa).value();
                    bits |= 0x200L;
                    continue;
                }
                if (pa instanceof OpenCL.Constant) {
                    name = ((OpenCL.Constant)pa).value();
                    bits |= 0xC00L;
                    continue;
                }
                if (!(pa instanceof OpenCL.Arg)) continue;
                name = ((OpenCL.Arg)pa).value();
                bits |= 0x4000L;
            }
            if (parameterTypes[arg].isArray()) {
                if (parameterTypes[arg].isAssignableFrom(float[].class)) {
                    bits |= 0x48L;
                } else if (parameterTypes[arg].isAssignableFrom(int[].class)) {
                    bits |= 0x44L;
                } else if (parameterTypes[arg].isAssignableFrom(double[].class)) {
                    bits |= 0x60L;
                } else if (parameterTypes[arg].isAssignableFrom(byte[].class)) {
                    bits |= 0x41L;
                } else if (parameterTypes[arg].isAssignableFrom(short[].class)) {
                    bits |= 0x42L;
                } else if (parameterTypes[arg].isAssignableFrom(long[].class)) {
                    bits |= 0x50L;
                }
            } else if (parameterTypes[arg].isPrimitive()) {
                if (parameterTypes[arg].isAssignableFrom(Float.TYPE)) {
                    bits |= 0x88L;
                } else if (parameterTypes[arg].isAssignableFrom(Integer.TYPE)) {
                    bits |= 0x84L;
                } else if (parameterTypes[arg].isAssignableFrom(Double.TYPE)) {
                    bits |= 0xA0L;
                } else if (parameterTypes[arg].isAssignableFrom(Byte.TYPE)) {
                    bits |= 0x81L;
                } else if (parameterTypes[arg].isAssignableFrom(Short.TYPE)) {
                    bits |= 0x82L;
                } else if (parameterTypes[arg].isAssignableFrom(Long.TYPE)) {
                    bits |= 0x90L;
                }
            } else {
                System.out.println("OUch!");
            }
            if (name == null) {
                throw new IllegalStateException("no name!");
            }
            OpenCLArgDescriptor kernelArg = new OpenCLArgDescriptor(name, bits);
            args.add(kernelArg);
        }
        return args;
    }

    private static boolean isReservedInterfaceMethod(Method _methods) {
        return _methods.getName().equals("put") || _methods.getName().equals("get") || _methods.getName().equals("dispose") || _methods.getName().equals("begin") || _methods.getName().equals("end") || _methods.getName().equals("getProfileInfo");
    }

    private String streamToString(InputStream _inputStream) {
        StringBuilder sourceBuilder = new StringBuilder();
        if (_inputStream != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(_inputStream));
            try {
                String line = reader.readLine();
                while (line != null) {
                    sourceBuilder.append(line).append("\n");
                    line = reader.readLine();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                _inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sourceBuilder.toString();
    }

    public <T extends OpenCL<T>> T bind(Class<T> _interface, InputStream _inputStream) {
        return this.bind(_interface, this.streamToString(_inputStream));
    }

    public <T extends OpenCL<T>> T bind(Class<T> _interface) {
        return this.bind(_interface, (String)null);
    }

    public <T extends OpenCL<T>> T bind(Class<T> _interface, String _source) {
        HashMap<String, List<OpenCLArgDescriptor>> kernelNameToArgsMap = new HashMap<String, List<OpenCLArgDescriptor>>();
        if (_source == null) {
            StringBuilder sourceBuilder = new StringBuilder();
            int interfaceIsAnnotated = 0;
            for (Annotation annotation : _interface.getAnnotations()) {
                if (annotation instanceof OpenCL.Source) {
                    OpenCL.Source source = (OpenCL.Source)annotation;
                    sourceBuilder.append(source.value()).append("\n");
                    interfaceIsAnnotated = 1;
                    continue;
                }
                if (!(annotation instanceof OpenCL.Resource)) continue;
                OpenCL.Resource sourceResource = (OpenCL.Resource)annotation;
                InputStream stream = _interface.getClassLoader().getResourceAsStream(sourceResource.value());
                sourceBuilder.append(this.streamToString(stream));
                interfaceIsAnnotated = 1;
            }
            if (interfaceIsAnnotated != 0) {
                for (Method method : _interface.getDeclaredMethods()) {
                    if (OpenCLDevice.isReservedInterfaceMethod(method)) continue;
                    List<OpenCLArgDescriptor> args = this.getArgs(method);
                    kernelNameToArgsMap.put(method.getName(), args);
                }
            } else {
                for (Method method : _interface.getDeclaredMethods()) {
                    if (OpenCLDevice.isReservedInterfaceMethod(method)) continue;
                    for (Annotation a : method.getAnnotations()) {
                        if (!(a instanceof OpenCL.Kernel)) continue;
                        sourceBuilder.append("__kernel void " + method.getName() + "(");
                        List<OpenCLArgDescriptor> args = this.getArgs(method);
                        boolean first = true;
                        for (OpenCLArgDescriptor arg : args) {
                            if (first) {
                                first = false;
                            } else {
                                sourceBuilder.append(",");
                            }
                            sourceBuilder.append("\n   " + arg);
                        }
                        sourceBuilder.append(")");
                        OpenCL.Kernel kernel = (OpenCL.Kernel)a;
                        sourceBuilder.append(kernel.value());
                        kernelNameToArgsMap.put(method.getName(), args);
                    }
                }
            }
            _source = sourceBuilder.toString();
        } else {
            for (Method m : _interface.getDeclaredMethods()) {
                if (OpenCLDevice.isReservedInterfaceMethod(m)) continue;
                List<OpenCLArgDescriptor> args = this.getArgs(m);
                kernelNameToArgsMap.put(m.getName(), args);
            }
        }
        OpenCLProgram program = new OpenCLProgram(this, _source).createProgram(this);
        HashMap<String, OpenCLKernel> map = new HashMap<String, OpenCLKernel>();
        for (String name : kernelNameToArgsMap.keySet()) {
            OpenCLKernel kernel = OpenCLKernel.createKernel(program, name, (List)kernelNameToArgsMap.get(name));
            if (kernel == null) {
                throw new IllegalStateException("kernel is null");
            }
            map.put(name, kernel);
        }
        OpenCLInvocationHandler invocationHandler = new OpenCLInvocationHandler(program, map);
        OpenCL instance = (OpenCL)Proxy.newProxyInstance(OpenCLDevice.class.getClassLoader(), new Class[]{_interface, OpenCL.class}, invocationHandler);
        return (T)instance;
    }

    public static List<OpenCLDevice> listDevices(Device.TYPE type) {
        OpenCLPlatform platform = new OpenCLPlatform(0L, null, null, null);
        ArrayList<OpenCLDevice> results = new ArrayList<OpenCLDevice>();
        for (OpenCLPlatform p : platform.getOpenCLPlatforms()) {
            for (OpenCLDevice device : p.getOpenCLDevices()) {
                if (type != null && device.getType() != type) continue;
                results.add(device);
            }
        }
        return results;
    }

    public static OpenCLDevice select(DeviceSelector _deviceSelector) {
        OpenCLDevice device = null;
        OpenCLPlatform platform = new OpenCLPlatform(0L, null, null, null);
        for (OpenCLPlatform p : platform.getOpenCLPlatforms()) {
            OpenCLDevice d;
            Iterator<OpenCLDevice> iterator = p.getOpenCLDevices().iterator();
            while (iterator.hasNext() && (device = _deviceSelector.select(d = iterator.next())) == null) {
            }
            if (device == null) continue;
            break;
        }
        return device;
    }

    public static OpenCLDevice select(DeviceComparitor _deviceComparitor) {
        OpenCLDevice device = null;
        OpenCLPlatform platform = new OpenCLPlatform(0L, null, null, null);
        List<OpenCLPlatform> openCLPlatforms = platform.getOpenCLPlatforms();
        for (OpenCLPlatform p : openCLPlatforms) {
            List<OpenCLDevice> openCLDevices = p.getOpenCLDevices();
            for (OpenCLDevice d : openCLDevices) {
                if (device == null) {
                    device = d;
                    continue;
                }
                device = _deviceComparitor.select(device, d);
            }
        }
        return device;
    }

    public static OpenCLDevice select(DeviceComparitor _deviceComparitor, Device.TYPE _type) {
        OpenCLDevice device = null;
        OpenCLPlatform platform = new OpenCLPlatform(0L, null, null, null);
        for (OpenCLPlatform p : platform.getOpenCLPlatforms()) {
            for (OpenCLDevice d : p.getOpenCLDevices()) {
                if (d.getType() != _type) continue;
                if (device == null) {
                    device = d;
                    continue;
                }
                device = _deviceComparitor.select(device, d);
            }
        }
        return device;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("{");
        boolean first = true;
        for (int workItemSize : this.maxWorkItemSize) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            s.append(workItemSize);
        }
        s.append("}");
        return "Device " + this.deviceId + "\n  vendor = " + this.getOpenCLPlatform().getVendor() + "\n  type:" + (Object)((Object)this.type) + "\n  maxComputeUnits=" + this.maxComputeUnits + "\n  maxWorkItemDimensions=" + this.maxWorkItemDimensions + "\n  maxWorkItemSizes=" + s + "\n  maxWorkWorkGroupSize=" + this.maxWorkGroupSize + "\n  globalMemSize=" + this.globalMemSize + "\n  localMemSize=" + this.localMemSize;
    }

    public static interface DeviceComparitor {
        public OpenCLDevice select(OpenCLDevice var1, OpenCLDevice var2);
    }

    public static interface DeviceSelector {
        public OpenCLDevice select(OpenCLDevice var1);
    }

    public static class OpenCLInvocationHandler<T extends OpenCL<T>>
    implements InvocationHandler {
        private final Map<String, OpenCLKernel> map;
        private final OpenCLProgram program;
        private boolean disposed = false;

        public OpenCLInvocationHandler(OpenCLProgram _program, Map<String, OpenCLKernel> _map) {
            this.program = _program;
            this.map = _map;
            this.disposed = false;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (this.disposed) {
                throw new IllegalStateException("bound interface already disposed");
            }
            if (!OpenCLDevice.isReservedInterfaceMethod(method)) {
                OpenCLKernel kernel = this.map.get(method.getName());
                if (kernel != null) {
                    kernel.invoke(args);
                }
            } else if (method.getName().equals("put")) {
                System.out.println("put not implemented");
            } else if (method.getName().equals("get")) {
                System.out.println("get not implemented");
            } else if (method.getName().equals("begin")) {
                System.out.println("begin not implemented");
            } else if (method.getName().equals("dispose")) {
                for (OpenCLKernel k : this.map.values()) {
                    k.dispose();
                }
                this.program.dispose();
                this.map.clear();
                this.disposed = true;
            } else if (method.getName().equals("end")) {
                System.out.println("end not implemented");
            } else if (method.getName().equals("getProfileInfo")) {
                proxy = this.program.getProfileInfo();
            }
            return proxy;
        }
    }
}

