/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi.device;

import com.aparapi.Range;
import com.aparapi.internal.kernel.KernelManager;

public abstract class Device {
    protected TYPE type = TYPE.UNKNOWN;
    protected int maxWorkGroupSize;
    protected int maxWorkItemDimensions;
    protected int[] maxWorkItemSize = new int[]{0, 0, 0};

    @Deprecated
    public static Device best() {
        return KernelManager.instance().bestDevice();
    }

    @Deprecated
    public static Device bestGPU() {
        return Device.firstGPU();
    }

    @Deprecated
    public static Device first(TYPE _type) {
        return KernelManager.DeprecatedMethods.firstDevice(_type);
    }

    @Deprecated
    public static Device firstGPU() {
        return KernelManager.DeprecatedMethods.firstDevice(TYPE.GPU);
    }

    @Deprecated
    public static Device firstCPU() {
        return KernelManager.DeprecatedMethods.firstDevice(TYPE.CPU);
    }

    @Deprecated
    public static Device bestACC() {
        throw new UnsupportedOperationException();
    }

    public abstract String getShortDescription();

    public TYPE getType() {
        return this.type;
    }

    public void setType(TYPE type) {
        this.type = type;
    }

    public int getMaxWorkItemDimensions() {
        return this.maxWorkItemDimensions;
    }

    public void setMaxWorkItemDimensions(int _maxWorkItemDimensions) {
        this.maxWorkItemDimensions = _maxWorkItemDimensions;
    }

    public int getMaxWorkGroupSize() {
        return this.maxWorkGroupSize;
    }

    public void setMaxWorkGroupSize(int _maxWorkGroupSize) {
        this.maxWorkGroupSize = _maxWorkGroupSize;
    }

    public int[] getMaxWorkItemSize() {
        return this.maxWorkItemSize;
    }

    public void setMaxWorkItemSize(int[] maxWorkItemSize) {
        this.maxWorkItemSize = maxWorkItemSize;
    }

    public Range createRange(int _globalWidth) {
        return Range.create(this, _globalWidth);
    }

    public Range createRange(int _globalWidth, int _localWidth) {
        return Range.create(this, _globalWidth, _localWidth);
    }

    public Range createRange2D(int _globalWidth, int _globalHeight) {
        return Range.create2D(this, _globalWidth, _globalHeight);
    }

    public Range createRange2D(int _globalWidth, int _globalHeight, int _localWidth, int _localHeight) {
        return Range.create2D(this, _globalWidth, _globalHeight, _localWidth, _localHeight);
    }

    public Range createRange3D(int _globalWidth, int _globalHeight, int _globalDepth) {
        return Range.create3D(this, _globalWidth, _globalHeight, _globalDepth);
    }

    public Range createRange3D(int _globalWidth, int _globalHeight, int _globalDepth, int _localWidth, int _localHeight, int _localDepth) {
        return Range.create3D(this, _globalWidth, _globalHeight, _globalDepth, _localWidth, _localHeight, _localDepth);
    }

    public abstract long getDeviceId();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Device)) {
            return false;
        }
        Device device = (Device)o;
        return this.getDeviceId() == device.getDeviceId();
    }

    public int hashCode() {
        return Long.valueOf(this.getDeviceId()).hashCode();
    }

    public static enum TYPE {
        UNKNOWN(Integer.MAX_VALUE),
        GPU(2),
        CPU(3),
        JTP(5),
        SEQ(6),
        ACC(1),
        ALT(4);

        public final int rank;

        private TYPE(int rank) {
            this.rank = rank;
        }
    }
}

