/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi;

import com.aparapi.device.Device;
import com.aparapi.device.JavaDevice;
import com.aparapi.device.OpenCLDevice;
import com.aparapi.internal.jni.RangeJNI;
import java.util.Arrays;

public class Range
extends RangeJNI {
    public static final int THREADS_PER_CORE = 16;
    public static final int MAX_OPENCL_GROUP_SIZE = 256;
    public static final int MAX_GROUP_SIZE = Math.max(Runtime.getRuntime().availableProcessors() * 16, 256);
    private OpenCLDevice device = null;
    private int maxWorkGroupSize;
    private int[] maxWorkItemSize = new int[]{MAX_GROUP_SIZE, MAX_GROUP_SIZE, MAX_GROUP_SIZE};

    public Range(Device _device, int _dims) {
        this.device = !(_device instanceof OpenCLDevice) ? null : (OpenCLDevice)_device;
        this.dims = _dims;
        if (this.device != null) {
            this.maxWorkItemSize = this.device.getMaxWorkItemSize();
            this.maxWorkGroupSize = this.device.getMaxWorkGroupSize();
        } else {
            this.maxWorkGroupSize = MAX_GROUP_SIZE;
        }
    }

    public static Range create(Device _device, int _globalWidth, int _localWidth) {
        Range range = new Range(_device, 1);
        range.setGlobalSize_0(_globalWidth);
        range.setLocalSize_0(_localWidth);
        range.setValid(range.getLocalSize_0() > 0 && range.getLocalSize_0() <= range.getMaxWorkItemSize()[0] && range.getLocalSize_0() <= range.getMaxWorkGroupSize() && range.getGlobalSize_0() % range.getLocalSize_0() == 0);
        return range;
    }

    private static int[] getFactors(int _value, int _max) {
        int[] factors = new int[MAX_GROUP_SIZE];
        int factorIdx = 0;
        for (int possibleFactor = 1; possibleFactor <= _max; ++possibleFactor) {
            if (_value % possibleFactor != 0) continue;
            factors[factorIdx++] = possibleFactor;
        }
        return Arrays.copyOf(factors, factorIdx);
    }

    public static Range create(Device _device, int _globalWidth) {
        Range withoutLocal = Range.create(_device, _globalWidth, 1);
        if (_device == JavaDevice.THREAD_POOL) {
            withoutLocal.setLocalSize_0(Runtime.getRuntime().availableProcessors());
            withoutLocal.setLocalIsDerived(true);
            return withoutLocal;
        }
        if (_device instanceof JavaDevice) {
            withoutLocal.setLocalIsDerived(true);
            return withoutLocal;
        }
        if (_globalWidth == 0) {
            withoutLocal.setLocalIsDerived(true);
            return withoutLocal;
        }
        if (withoutLocal.isValid()) {
            withoutLocal.setLocalIsDerived(true);
            int[] factors = Range.getFactors(withoutLocal.getGlobalSize_0(), withoutLocal.getMaxWorkItemSize()[0]);
            withoutLocal.setLocalSize_0(factors[factors.length - 1]);
            withoutLocal.setValid(withoutLocal.getLocalSize_0() > 0 && withoutLocal.getLocalSize_0() <= withoutLocal.getMaxWorkItemSize()[0] && withoutLocal.getLocalSize_0() <= withoutLocal.getMaxWorkGroupSize() && withoutLocal.getGlobalSize_0() % withoutLocal.getLocalSize_0() == 0);
        }
        return withoutLocal;
    }

    public static Range create(int _globalWidth, int _localWidth) {
        Range range = Range.create(null, _globalWidth, _localWidth);
        return range;
    }

    public static Range create(int _globalWidth) {
        Range range = Range.create(null, _globalWidth);
        return range;
    }

    public static Range create2D(Device _device, int _globalWidth, int _globalHeight, int _localWidth, int _localHeight) {
        Range range = new Range(_device, 2);
        range.setGlobalSize_0(_globalWidth);
        range.setLocalSize_0(_localWidth);
        range.setGlobalSize_1(_globalHeight);
        range.setLocalSize_1(_localHeight);
        range.setValid(range.getLocalSize_0() > 0 && range.getLocalSize_1() > 0 && range.getLocalSize_0() <= range.getMaxWorkItemSize()[0] && range.getLocalSize_1() <= range.getMaxWorkItemSize()[1] && range.getLocalSize_0() * range.getLocalSize_1() <= range.getMaxWorkGroupSize() && range.getGlobalSize_0() % range.getLocalSize_0() == 0 && range.getGlobalSize_1() % range.getLocalSize_1() == 0);
        return range;
    }

    public static Range create2D(Device _device, int _globalWidth, int _globalHeight) {
        Range withoutLocal = Range.create2D(_device, _globalWidth, _globalHeight, 1, 1);
        if (withoutLocal.isValid()) {
            withoutLocal.setLocalIsDerived(true);
            int[] widthFactors = Range.getFactors(_globalWidth, withoutLocal.getMaxWorkItemSize()[0]);
            int[] heightFactors = Range.getFactors(_globalHeight, withoutLocal.getMaxWorkItemSize()[1]);
            withoutLocal.setLocalSize_0(1);
            withoutLocal.setLocalSize_1(1);
            int max = 1;
            int perimeter = 0;
            for (int w : widthFactors) {
                int h;
                int size;
                int[] nArray = heightFactors;
                int n = nArray.length;
                for (int i = 0; i < n && (size = w * (h = nArray[i])) <= withoutLocal.getMaxWorkGroupSize(); ++i) {
                    int localPerimeter;
                    if (size > max) {
                        max = size;
                        perimeter = w + h;
                        withoutLocal.setLocalSize_0(w);
                        withoutLocal.setLocalSize_1(h);
                        continue;
                    }
                    if (size != max || (localPerimeter = w + h) >= perimeter) continue;
                    perimeter = localPerimeter;
                    withoutLocal.setLocalSize_0(w);
                    withoutLocal.setLocalSize_1(h);
                }
            }
            withoutLocal.setValid(withoutLocal.getLocalSize_0() > 0 && withoutLocal.getLocalSize_1() > 0 && withoutLocal.getLocalSize_0() <= withoutLocal.getMaxWorkItemSize()[0] && withoutLocal.getLocalSize_1() <= withoutLocal.getMaxWorkItemSize()[1] && withoutLocal.getLocalSize_0() * withoutLocal.getLocalSize_1() <= withoutLocal.getMaxWorkGroupSize() && withoutLocal.getGlobalSize_0() % withoutLocal.getLocalSize_0() == 0 && withoutLocal.getGlobalSize_1() % withoutLocal.getLocalSize_1() == 0);
        }
        return withoutLocal;
    }

    public static Range create2D(int _globalWidth, int _globalHeight, int _localWidth, int _localHeight) {
        Range range = Range.create2D(null, _globalWidth, _globalHeight, _localWidth, _localHeight);
        return range;
    }

    public static Range create2D(int _globalWidth, int _globalHeight) {
        Range range = Range.create2D(null, _globalWidth, _globalHeight);
        return range;
    }

    public static Range create3D(Device _device, int _globalWidth, int _globalHeight, int _globalDepth, int _localWidth, int _localHeight, int _localDepth) {
        Range range = new Range(_device, 3);
        range.setGlobalSize_0(_globalWidth);
        range.setLocalSize_0(_localWidth);
        range.setGlobalSize_1(_globalHeight);
        range.setLocalSize_1(_localHeight);
        range.setGlobalSize_2(_globalDepth);
        range.setLocalSize_2(_localDepth);
        range.setValid(range.getLocalSize_0() > 0 && range.getLocalSize_1() > 0 && range.getLocalSize_2() > 0 && range.getLocalSize_0() * range.getLocalSize_1() * range.getLocalSize_2() <= range.getMaxWorkGroupSize() && range.getLocalSize_0() <= range.getMaxWorkItemSize()[0] && range.getLocalSize_1() <= range.getMaxWorkItemSize()[1] && range.getLocalSize_2() <= range.getMaxWorkItemSize()[2] && range.getGlobalSize_0() % range.getLocalSize_0() == 0 && range.getGlobalSize_1() % range.getLocalSize_1() == 0 && range.getGlobalSize_2() % range.getLocalSize_2() == 0);
        return range;
    }

    public static Range create3D(Device _device, int _globalWidth, int _globalHeight, int _globalDepth) {
        Range withoutLocal = Range.create3D(_device, _globalWidth, _globalHeight, _globalDepth, 1, 1, 1);
        if (withoutLocal.isValid()) {
            withoutLocal.setLocalIsDerived(true);
            int[] widthFactors = Range.getFactors(_globalWidth, withoutLocal.getMaxWorkItemSize()[0]);
            int[] heightFactors = Range.getFactors(_globalHeight, withoutLocal.getMaxWorkItemSize()[1]);
            int[] depthFactors = Range.getFactors(_globalDepth, withoutLocal.getMaxWorkItemSize()[2]);
            withoutLocal.setLocalSize_0(1);
            withoutLocal.setLocalSize_1(1);
            withoutLocal.setLocalSize_2(1);
            int max = 1;
            int perimeter = 0;
            for (int w : widthFactors) {
                for (int h : heightFactors) {
                    int d;
                    int size;
                    int[] nArray = depthFactors;
                    int n = nArray.length;
                    for (int i = 0; i < n && (size = w * h * (d = nArray[i])) <= withoutLocal.getMaxWorkGroupSize(); ++i) {
                        int localPerimeter;
                        if (size > max) {
                            max = size;
                            perimeter = w + h + d;
                            withoutLocal.setLocalSize_0(w);
                            withoutLocal.setLocalSize_1(h);
                            withoutLocal.setLocalSize_2(d);
                            continue;
                        }
                        if (size != max || (localPerimeter = w + h + d) >= perimeter) continue;
                        perimeter = localPerimeter;
                        withoutLocal.setLocalSize_0(w);
                        withoutLocal.setLocalSize_1(w);
                        withoutLocal.setLocalSize_2(d);
                    }
                }
            }
            withoutLocal.setValid(withoutLocal.getLocalSize_0() > 0 && withoutLocal.getLocalSize_1() > 0 && withoutLocal.getLocalSize_2() > 0 && withoutLocal.getLocalSize_0() * withoutLocal.getLocalSize_1() * withoutLocal.getLocalSize_2() <= withoutLocal.getMaxWorkGroupSize() && withoutLocal.getLocalSize_0() <= withoutLocal.getMaxWorkItemSize()[0] && withoutLocal.getLocalSize_1() <= withoutLocal.getMaxWorkItemSize()[1] && withoutLocal.getLocalSize_2() <= withoutLocal.getMaxWorkItemSize()[2] && withoutLocal.getGlobalSize_0() % withoutLocal.getLocalSize_0() == 0 && withoutLocal.getGlobalSize_1() % withoutLocal.getLocalSize_1() == 0 && withoutLocal.getGlobalSize_2() % withoutLocal.getLocalSize_2() == 0);
        }
        return withoutLocal;
    }

    public static Range create3D(int _globalWidth, int _globalHeight, int _globalDepth) {
        Range range = Range.create3D(null, _globalWidth, _globalHeight, _globalDepth);
        return range;
    }

    public static Range create3D(int _globalWidth, int _globalHeight, int _globalDepth, int _localWidth, int _localHeight, int _localDepth) {
        Range range = Range.create3D(null, _globalWidth, _globalHeight, _globalDepth, _localWidth, _localHeight, _localDepth);
        return range;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        switch (this.dims) {
            case 1: {
                sb.append("global:" + this.globalSize_0 + " local:" + (this.localIsDerived ? "(derived)" : "") + this.localSize_0);
                break;
            }
            case 2: {
                sb.append("2D(global:" + this.globalSize_0 + "x" + this.globalSize_1 + " local:" + (this.localIsDerived ? "(derived)" : "") + this.localSize_0 + "x" + this.localSize_1 + ")");
                break;
            }
            case 3: {
                sb.append("3D(global:" + this.globalSize_0 + "x" + this.globalSize_1 + "x" + this.globalSize_2 + " local:" + (this.localIsDerived ? "(derived)" : "") + this.localSize_0 + "x" + this.localSize_1 + "x" + this.localSize_2 + ")");
            }
        }
        return sb.toString();
    }

    public int getLocalSize(int _dim) {
        return _dim == 0 ? this.localSize_0 : (_dim == 1 ? this.localSize_1 : this.localSize_2);
    }

    public int getGlobalSize(int _dim) {
        return _dim == 0 ? this.globalSize_0 : (_dim == 1 ? this.globalSize_1 : this.globalSize_2);
    }

    public int getNumGroups(int _dim) {
        return _dim == 0 ? this.globalSize_0 / this.localSize_0 : (_dim == 1 ? this.globalSize_1 / this.localSize_1 : this.globalSize_2 / this.localSize_2);
    }

    public int getWorkGroupSize() {
        return this.localSize_0 * this.localSize_1 * this.localSize_2;
    }

    public Device getDevice() {
        return this.device;
    }

    public int getGlobalSize_0() {
        return this.globalSize_0;
    }

    public void setGlobalSize_0(int globalSize_0) {
        this.globalSize_0 = globalSize_0;
    }

    public int getLocalSize_0() {
        return this.localSize_0;
    }

    public void setLocalSize_0(int localSize_0) {
        this.localSize_0 = localSize_0;
    }

    public int getGlobalSize_1() {
        return this.globalSize_1;
    }

    public void setGlobalSize_1(int globalSize_1) {
        this.globalSize_1 = globalSize_1;
    }

    public int getLocalSize_1() {
        return this.localSize_1;
    }

    public void setLocalSize_1(int localSize_1) {
        this.localSize_1 = localSize_1;
    }

    public int getGlobalSize_2() {
        return this.globalSize_2;
    }

    public void setGlobalSize_2(int globalSize_2) {
        this.globalSize_2 = globalSize_2;
    }

    public int getLocalSize_2() {
        return this.localSize_2;
    }

    public void setLocalSize_2(int localSize_2) {
        this.localSize_2 = localSize_2;
    }

    public int getDims() {
        return this.dims;
    }

    public void setDims(int dims) {
        this.dims = dims;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public boolean isLocalIsDerived() {
        return this.localIsDerived;
    }

    public void setLocalIsDerived(boolean localIsDerived) {
        this.localIsDerived = localIsDerived;
    }

    public int getMaxWorkGroupSize() {
        return this.maxWorkGroupSize;
    }

    public void setMaxWorkGroupSize(int maxWorkGroupSize) {
        this.maxWorkGroupSize = maxWorkGroupSize;
    }

    public int[] getMaxWorkItemSize() {
        return this.maxWorkItemSize;
    }

    public void setMaxWorkItemSize(int[] maxWorkItemSize) {
        this.maxWorkItemSize = maxWorkItemSize;
    }
}

