/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi;

import com.aparapi.Config;
import com.aparapi.ProfileInfo;
import com.aparapi.Range;
import com.aparapi.annotation.Experimental;
import com.aparapi.device.Device;
import com.aparapi.device.OpenCLDevice;
import com.aparapi.exception.DeprecatedException;
import com.aparapi.internal.kernel.KernelManager;
import com.aparapi.internal.kernel.KernelProfile;
import com.aparapi.internal.kernel.KernelRunner;
import com.aparapi.internal.model.CacheEnabler;
import com.aparapi.internal.model.ClassModel;
import com.aparapi.internal.model.ValueCache;
import com.aparapi.internal.opencl.OpenCLLoader;
import com.aparapi.internal.util.Reflection;
import com.aparapi.internal.util.UnsafeWrapper;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.logging.Logger;

public abstract class Kernel
implements Cloneable {
    private static Logger logger = Logger.getLogger(Config.getLoggerName());
    public static final String LOCAL_SUFFIX = "_$local$";
    public static final String CONSTANT_SUFFIX = "_$constant$";
    public static final String PRIVATE_SUFFIX = "_$private$";
    private KernelRunner kernelRunner = null;
    private boolean autoCleanUpArrays = false;
    private KernelState kernelState = new KernelState();
    private static final double LOG_2_RECIPROCAL = 1.0 / Math.log(2.0);
    private static final double PI_RECIPROCAL = 0.3183098861837907;
    static final Map<String, String> typeToLetterMap = new HashMap<String, String>();
    boolean useNullForLocalSize = false;
    @Deprecated
    private final LinkedHashSet<EXECUTION_MODE> executionModes = Config.executionMode != null ? EXECUTION_MODE.getDefaultExecutionModes() : new LinkedHashSet<EXECUTION_MODE>(Collections.singleton(EXECUTION_MODE.AUTO));
    @Deprecated
    private Iterator<EXECUTION_MODE> currentMode = this.executionModes.iterator();
    @Deprecated
    private EXECUTION_MODE executionMode = this.currentMode.next();
    private static final ValueCache<Class<?>, Map<String, Boolean>, RuntimeException> mappedMethodFlags;
    private static final ValueCache<Class<?>, Map<String, Boolean>, RuntimeException> openCLDelegateMethodFlags;
    private static final ValueCache<Class<?>, Map<String, Boolean>, RuntimeException> atomic32Cache;
    private static final ValueCache<Class<?>, Map<String, Boolean>, RuntimeException> atomic64Cache;
    private static final ValueCache<Class<?>, Map<String, String>, RuntimeException> mappedMethodNamesCache;

    @OpenCLDelegate
    protected final int getGlobalId() {
        return this.getGlobalId(0);
    }

    @OpenCLDelegate
    protected final int getGlobalId(int _dim) {
        return this.kernelState.getGlobalIds()[_dim];
    }

    @OpenCLDelegate
    protected final int getGroupId() {
        return this.getGroupId(0);
    }

    @OpenCLDelegate
    protected final int getGroupId(int _dim) {
        return this.kernelState.getGroupIds()[_dim];
    }

    @OpenCLDelegate
    protected final int getPassId() {
        return this.kernelState.getPassId();
    }

    @OpenCLDelegate
    protected final int getLocalId() {
        return this.getLocalId(0);
    }

    @OpenCLDelegate
    protected final int getLocalId(int _dim) {
        return this.kernelState.getLocalIds()[_dim];
    }

    @OpenCLDelegate
    protected final int getLocalSize() {
        return this.kernelState.getRange().getLocalSize(0);
    }

    @OpenCLDelegate
    protected final int getLocalSize(int _dim) {
        return this.kernelState.getRange().getLocalSize(_dim);
    }

    @OpenCLDelegate
    protected final int getGlobalSize() {
        return this.kernelState.getRange().getGlobalSize(0);
    }

    @OpenCLDelegate
    protected final int getGlobalSize(int _dim) {
        return this.kernelState.getRange().getGlobalSize(_dim);
    }

    @OpenCLDelegate
    protected final int getNumGroups() {
        return this.kernelState.getRange().getNumGroups(0);
    }

    @OpenCLDelegate
    protected final int getNumGroups(int _dim) {
        return this.kernelState.getRange().getNumGroups(_dim);
    }

    public abstract void run();

    public boolean hasFallbackAlgorithm() {
        return false;
    }

    public void executeFallbackAlgorithm(Range _range, int _passId) {
    }

    public void cancelMultiPass() {
        if (this.kernelRunner == null) {
            return;
        }
        this.kernelRunner.cancelMultiPass();
    }

    public int getCancelState() {
        return this.kernelRunner == null ? 0 : this.kernelRunner.getCancelState();
    }

    public int getCurrentPass() {
        if (this.kernelRunner == null) {
            return -1;
        }
        return this.kernelRunner.getCurrentPass();
    }

    public boolean isExecuting() {
        if (this.kernelRunner == null) {
            return false;
        }
        return this.kernelRunner.isExecuting();
    }

    public Kernel clone() {
        try {
            Kernel worker;
            Kernel kernel = worker = (Kernel)super.clone();
            kernel.getClass();
            worker.kernelState = kernel.new KernelState(this.kernelState);
            worker.kernelState.setGroupIds(new int[]{0, 0, 0});
            worker.kernelState.setLocalIds(new int[]{0, 0, 0});
            worker.kernelState.setGlobalIds(new int[]{0, 0, 0});
            return worker;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    @OpenCLMapping(mapTo="acos")
    protected float acos(float a) {
        return (float)Math.acos(a);
    }

    @OpenCLMapping(mapTo="acos")
    protected double acos(double a) {
        return Math.acos(a);
    }

    @OpenCLMapping(mapTo="asin")
    protected float asin(float _f) {
        return (float)Math.asin(_f);
    }

    @OpenCLMapping(mapTo="asin")
    protected double asin(double _d) {
        return Math.asin(_d);
    }

    @OpenCLMapping(mapTo="atan")
    protected float atan(float _f) {
        return (float)Math.atan(_f);
    }

    @OpenCLMapping(mapTo="atan")
    protected double atan(double _d) {
        return Math.atan(_d);
    }

    @OpenCLMapping(mapTo="atan2")
    protected float atan2(float _f1, float _f2) {
        return (float)Math.atan2(_f1, _f2);
    }

    @OpenCLMapping(mapTo="atan2")
    protected double atan2(double _d1, double _d2) {
        return Math.atan2(_d1, _d2);
    }

    @OpenCLMapping(mapTo="ceil")
    protected float ceil(float _f) {
        return (float)Math.ceil(_f);
    }

    @OpenCLMapping(mapTo="ceil")
    protected double ceil(double _d) {
        return Math.ceil(_d);
    }

    @OpenCLMapping(mapTo="cos")
    protected float cos(float _f) {
        return (float)Math.cos(_f);
    }

    @OpenCLMapping(mapTo="cos")
    protected double cos(double _d) {
        return Math.cos(_d);
    }

    @OpenCLMapping(mapTo="exp")
    protected float exp(float _f) {
        return (float)Math.exp(_f);
    }

    @OpenCLMapping(mapTo="exp")
    protected double exp(double _d) {
        return Math.exp(_d);
    }

    @OpenCLMapping(mapTo="fabs")
    protected float abs(float _f) {
        return Math.abs(_f);
    }

    @OpenCLMapping(mapTo="fabs")
    protected double abs(double _d) {
        return Math.abs(_d);
    }

    @OpenCLMapping(mapTo="abs")
    protected int abs(int n) {
        return Math.abs(n);
    }

    @OpenCLMapping(mapTo="abs")
    protected long abs(long n) {
        return Math.abs(n);
    }

    @OpenCLMapping(mapTo="floor")
    protected float floor(float _f) {
        return (float)Math.floor(_f);
    }

    @OpenCLMapping(mapTo="floor")
    protected double floor(double _d) {
        return Math.floor(_d);
    }

    @OpenCLMapping(mapTo="fmax")
    protected float max(float _f1, float _f2) {
        return Math.max(_f1, _f2);
    }

    @OpenCLMapping(mapTo="fmax")
    protected double max(double _d1, double _d2) {
        return Math.max(_d1, _d2);
    }

    @OpenCLMapping(mapTo="max")
    protected int max(int n1, int n2) {
        return Math.max(n1, n2);
    }

    @OpenCLMapping(mapTo="max")
    protected long max(long n1, long n2) {
        return Math.max(n1, n2);
    }

    @OpenCLMapping(mapTo="fmin")
    protected float min(float _f1, float _f2) {
        return Math.min(_f1, _f2);
    }

    @OpenCLMapping(mapTo="fmin")
    protected double min(double _d1, double _d2) {
        return Math.min(_d1, _d2);
    }

    @OpenCLMapping(mapTo="min")
    protected int min(int n1, int n2) {
        return Math.min(n1, n2);
    }

    @OpenCLMapping(mapTo="min")
    protected long min(long n1, long n2) {
        return Math.min(n1, n2);
    }

    @OpenCLMapping(mapTo="log")
    protected float log(float _f) {
        return (float)Math.log(_f);
    }

    @OpenCLMapping(mapTo="log")
    protected double log(double _d) {
        return Math.log(_d);
    }

    @OpenCLMapping(mapTo="pow")
    protected float pow(float _f1, float _f2) {
        return (float)Math.pow(_f1, _f2);
    }

    @OpenCLMapping(mapTo="pow")
    protected double pow(double _d1, double _d2) {
        return Math.pow(_d1, _d2);
    }

    @OpenCLMapping(mapTo="remainder")
    protected float IEEEremainder(float _f1, float _f2) {
        return (float)Math.IEEEremainder(_f1, _f2);
    }

    @OpenCLMapping(mapTo="remainder")
    protected double IEEEremainder(double _d1, double _d2) {
        return Math.IEEEremainder(_d1, _d2);
    }

    @OpenCLMapping(mapTo="radians")
    protected float toRadians(float _f) {
        return (float)Math.toRadians(_f);
    }

    @OpenCLMapping(mapTo="radians")
    protected double toRadians(double _d) {
        return Math.toRadians(_d);
    }

    @OpenCLMapping(mapTo="degrees")
    protected float toDegrees(float _f) {
        return (float)Math.toDegrees(_f);
    }

    @OpenCLMapping(mapTo="degrees")
    protected double toDegrees(double _d) {
        return Math.toDegrees(_d);
    }

    @OpenCLMapping(mapTo="rint")
    protected float rint(float _f) {
        return (float)Math.rint(_f);
    }

    @OpenCLMapping(mapTo="rint")
    protected double rint(double _d) {
        return Math.rint(_d);
    }

    @OpenCLMapping(mapTo="round")
    protected int round(float _f) {
        return Math.round(_f);
    }

    @OpenCLMapping(mapTo="round")
    protected long round(double _d) {
        return Math.round(_d);
    }

    @OpenCLMapping(mapTo="sin")
    protected float sin(float _f) {
        return (float)Math.sin(_f);
    }

    @OpenCLMapping(mapTo="sin")
    protected double sin(double _d) {
        return Math.sin(_d);
    }

    @OpenCLMapping(mapTo="sqrt")
    protected float sqrt(float _f) {
        return (float)Math.sqrt(_f);
    }

    @OpenCLMapping(mapTo="sqrt")
    protected double sqrt(double _d) {
        return Math.sqrt(_d);
    }

    @OpenCLMapping(mapTo="tan")
    protected float tan(float _f) {
        return (float)Math.tan(_f);
    }

    @OpenCLMapping(mapTo="tan")
    protected double tan(double _d) {
        return Math.tan(_d);
    }

    @OpenCLMapping(mapTo="acospi")
    protected final double acospi(double a) {
        return Math.acos(a) * 0.3183098861837907;
    }

    @OpenCLMapping(mapTo="acospi")
    protected final float acospi(float a) {
        return (float)(Math.acos(a) * 0.3183098861837907);
    }

    @OpenCLMapping(mapTo="asinpi")
    protected final double asinpi(double a) {
        return Math.asin(a) * 0.3183098861837907;
    }

    @OpenCLMapping(mapTo="asinpi")
    protected final float asinpi(float a) {
        return (float)(Math.asin(a) * 0.3183098861837907);
    }

    @OpenCLMapping(mapTo="atanpi")
    protected final double atanpi(double a) {
        return Math.atan(a) * 0.3183098861837907;
    }

    @OpenCLMapping(mapTo="atanpi")
    protected final float atanpi(float a) {
        return (float)(Math.atan(a) * 0.3183098861837907);
    }

    @OpenCLMapping(mapTo="atan2pi")
    protected final double atan2pi(double y, double x) {
        return Math.atan2(y, x) * 0.3183098861837907;
    }

    @OpenCLMapping(mapTo="atan2pi")
    protected final float atan2pi(float y, double x) {
        return (float)(Math.atan2(y, x) * 0.3183098861837907);
    }

    @OpenCLMapping(mapTo="cbrt")
    protected final double cbrt(double a) {
        return Math.cbrt(a);
    }

    @OpenCLMapping(mapTo="cbrt")
    protected final float cbrt(float a) {
        return (float)Math.cbrt(a);
    }

    @OpenCLMapping(mapTo="cosh")
    protected final double cosh(double x) {
        return Math.cosh(x);
    }

    @OpenCLMapping(mapTo="cosh")
    protected final float cosh(float x) {
        return (float)Math.cosh(x);
    }

    @OpenCLMapping(mapTo="cospi")
    protected final double cospi(double a) {
        return Math.cos(a * Math.PI);
    }

    @OpenCLMapping(mapTo="cospi")
    protected final float cospi(float a) {
        return (float)Math.cos((double)a * Math.PI);
    }

    @OpenCLMapping(mapTo="exp2")
    protected final double exp2(double a) {
        return Math.pow(2.0, a);
    }

    @OpenCLMapping(mapTo="exp2")
    protected final float exp2(float a) {
        return (float)Math.pow(2.0, a);
    }

    @OpenCLMapping(mapTo="exp10")
    protected final double exp10(double a) {
        return Math.pow(10.0, a);
    }

    @OpenCLMapping(mapTo="exp10")
    protected final float exp10(float a) {
        return (float)Math.pow(10.0, a);
    }

    @OpenCLMapping(mapTo="expm1")
    protected final double expm1(double x) {
        return Math.expm1(x);
    }

    @OpenCLMapping(mapTo="expm1")
    protected final float expm1(float x) {
        return (float)Math.expm1(x);
    }

    @OpenCLMapping(mapTo="log2")
    protected final double log2(double a) {
        return this.log(a) * LOG_2_RECIPROCAL;
    }

    @OpenCLMapping(mapTo="log2")
    protected final float log2(float a) {
        return (float)((double)this.log(a) * LOG_2_RECIPROCAL);
    }

    @OpenCLMapping(mapTo="log10")
    protected final double log10(double a) {
        return Math.log10(a);
    }

    @OpenCLMapping(mapTo="log10")
    protected final float log10(float a) {
        return (float)Math.log10(a);
    }

    @OpenCLMapping(mapTo="log1p")
    protected final double log1p(double x) {
        return Math.log1p(x);
    }

    @OpenCLMapping(mapTo="log1p")
    protected final float log1p(float x) {
        return (float)Math.log1p(x);
    }

    @OpenCLMapping(mapTo="mad")
    protected final double mad(double a, double b, double c) {
        return a * b + c;
    }

    @OpenCLMapping(mapTo="mad")
    protected final float mad(float a, float b, float c) {
        return a * b + c;
    }

    @OpenCLMapping(mapTo="fma")
    protected float fma(float a, float b, float c) {
        return a * b + c;
    }

    @OpenCLMapping(mapTo="fma")
    protected double fma(double a, double b, double c) {
        return a * b + c;
    }

    @OpenCLMapping(mapTo="nextafter")
    protected final double nextAfter(double start, double direction) {
        return Math.nextAfter(start, direction);
    }

    @OpenCLMapping(mapTo="nextafter")
    protected final float nextAfter(float start, float direction) {
        return Math.nextAfter(start, (double)direction);
    }

    @OpenCLMapping(mapTo="sinh")
    protected final double sinh(double x) {
        return Math.sinh(x);
    }

    @OpenCLMapping(mapTo="sinh")
    protected final float sinh(float x) {
        return (float)Math.sinh(x);
    }

    @OpenCLMapping(mapTo="sinpi")
    protected final double sinpi(double a) {
        return Math.sin(a * Math.PI);
    }

    @OpenCLMapping(mapTo="sinpi")
    protected final float sinpi(float a) {
        return (float)Math.sin((double)a * Math.PI);
    }

    @OpenCLMapping(mapTo="tanh")
    protected final double tanh(double x) {
        return Math.tanh(x);
    }

    @OpenCLMapping(mapTo="tanh")
    protected final float tanh(float x) {
        return (float)Math.tanh(x);
    }

    @OpenCLMapping(mapTo="tanpi")
    protected final double tanpi(double a) {
        return Math.tan(a * Math.PI);
    }

    @OpenCLMapping(mapTo="tanpi")
    protected final float tanpi(float a) {
        return (float)Math.tan((double)a * Math.PI);
    }

    @OpenCLMapping(mapTo="rsqrt")
    protected float rsqrt(float _f) {
        return 1.0f / (float)Math.sqrt(_f);
    }

    @OpenCLMapping(mapTo="rsqrt")
    protected double rsqrt(double _d) {
        return 1.0 / Math.sqrt(_d);
    }

    @OpenCLMapping(mapTo="native_sqrt")
    private float native_sqrt(float _f) {
        int j = Float.floatToIntBits(_f);
        j = 0x20000000 + (j >> 1) - 0x400000 - 19456;
        return Float.intBitsToFloat(j);
    }

    @OpenCLMapping(mapTo="native_rsqrt")
    private float native_rsqrt(float _f) {
        int j = Float.floatToIntBits(_f);
        j = 1597463007 - (j >> 1);
        float x = Float.intBitsToFloat(j);
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OpenCLMapping(atomic32=true)
    protected int atomicAdd(int[] _arr, int _index, int _delta) {
        if (!Config.disableUnsafe) {
            return UnsafeWrapper.atomicAdd(_arr, _index, _delta);
        }
        int[] nArray = _arr;
        synchronized (_arr) {
            int previous = _arr[_index];
            int n = _index;
            _arr[n] = _arr[n] + _delta;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return previous;
        }
    }

    @OpenCLDelegate
    @Experimental
    protected final void localBarrier() {
        this.kernelState.awaitOnLocalBarrier();
    }

    @OpenCLDelegate
    @Deprecated
    @Experimental
    protected final void globalBarrier() throws DeprecatedException {
        throw new DeprecatedException("Kernel.globalBarrier() has been deprecated. It was based an incorrect understanding of OpenCL functionality.");
    }

    @OpenCLMapping(mapTo="hypot")
    protected float hypot(float a, float b) {
        return (float)Math.hypot(a, b);
    }

    @OpenCLMapping(mapTo="hypot")
    protected double hypot(double a, double b) {
        return Math.hypot(a, b);
    }

    public KernelState getKernelState() {
        return this.kernelState;
    }

    private KernelRunner prepareKernelRunner() {
        if (this.kernelRunner == null) {
            this.kernelRunner = new KernelRunner(this);
        }
        return this.kernelRunner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getExecutionTime() {
        KernelProfile profile;
        KernelProfile kernelProfile = profile = KernelManager.instance().getProfile(this.getClass());
        synchronized (kernelProfile) {
            return profile.getLastExecutionTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getAccumulatedExecutionTime() {
        KernelProfile profile;
        KernelProfile kernelProfile = profile = KernelManager.instance().getProfile(this.getClass());
        synchronized (kernelProfile) {
            return profile.getAccumulatedTotalTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getConversionTime() {
        KernelProfile profile;
        KernelProfile kernelProfile = profile = KernelManager.instance().getProfile(this.getClass());
        synchronized (kernelProfile) {
            return profile.getLastConversionTime();
        }
    }

    public synchronized Kernel execute(Range _range) {
        return this.execute(_range, 1);
    }

    public String toString() {
        if (this.executionMode == EXECUTION_MODE.AUTO) {
            List<Device> preferredDevices = KernelManager.instance().getPreferences(this).getPreferredDevices(this);
            StringBuilder preferredDevicesSummary = new StringBuilder("{");
            for (int i = 0; i < preferredDevices.size(); ++i) {
                Device device = preferredDevices.get(i);
                preferredDevicesSummary.append(device.getShortDescription());
                if (i >= preferredDevices.size() - 1) continue;
                preferredDevicesSummary.append("|");
            }
            preferredDevicesSummary.append("}");
            return Reflection.getSimpleName(this.getClass()) + ", devices=" + preferredDevicesSummary.toString();
        }
        return Reflection.getSimpleName(this.getClass()) + ", modes=" + this.executionModes + ", current = " + (Object)((Object)this.executionMode);
    }

    public synchronized Kernel execute(int _range) {
        return this.execute(this.createRange(_range), 1);
    }

    protected Range createRange(int _range) {
        if (this.executionMode.equals((Object)EXECUTION_MODE.AUTO)) {
            Device device = this.getTargetDevice();
            Range range = Range.create(device, _range);
            return range;
        }
        return Range.create(null, _range);
    }

    public synchronized Kernel execute(Range _range, int _passes) {
        return this.execute("run", _range, _passes);
    }

    public synchronized Kernel execute(int _range, int _passes) {
        return this.execute(this.createRange(_range), _passes);
    }

    public synchronized Kernel execute(String _entrypoint, Range _range) {
        return this.execute(_entrypoint, _range, 1);
    }

    public synchronized Kernel execute(String _entrypoint, Range _range, int _passes) {
        return this.prepareKernelRunner().execute(_entrypoint, _range, _passes);
    }

    public boolean isAutoCleanUpArrays() {
        return this.autoCleanUpArrays;
    }

    public void setAutoCleanUpArrays(boolean autoCleanUpArrays) {
        this.autoCleanUpArrays = autoCleanUpArrays;
    }

    public synchronized void cleanUpArrays() {
        if (this.kernelRunner != null) {
            this.kernelRunner.cleanUpArrays();
        }
    }

    public synchronized void dispose() {
        if (this.kernelRunner != null) {
            this.kernelRunner.dispose();
            this.kernelRunner = null;
        }
    }

    public boolean isRunningCL() {
        return this.getTargetDevice() instanceof OpenCLDevice;
    }

    public final Device getTargetDevice() {
        return KernelManager.instance().getPreferences(this).getPreferredDevice(this);
    }

    public boolean isAllowDevice(Device _device) {
        return true;
    }

    @Deprecated
    public EXECUTION_MODE getExecutionMode() {
        return this.executionMode;
    }

    @Deprecated
    public void setExecutionMode(EXECUTION_MODE _executionMode) {
        this.executionMode = _executionMode;
    }

    public void setExecutionModeWithoutFallback(EXECUTION_MODE _executionMode) {
        this.executionModes.clear();
        this.executionModes.add(_executionMode);
        this.currentMode = this.executionModes.iterator();
        this.executionMode = this.currentMode.next();
    }

    @Deprecated
    public void setFallbackExecutionMode() {
        this.executionMode = EXECUTION_MODE.getFallbackExecutionMode();
    }

    private static String descriptorToReturnTypeLetter(String desc) {
        return desc.substring(desc.lastIndexOf(41) + 1);
    }

    private static String getReturnTypeLetter(Method meth) {
        return Kernel.toClassShortNameIfAny(meth.getReturnType());
    }

    private static String toClassShortNameIfAny(Class<?> retClass) {
        if (retClass.isArray()) {
            return "[" + Kernel.toClassShortNameIfAny(retClass.getComponentType());
        }
        String strRetClass = retClass.toString();
        String mapping = typeToLetterMap.get(strRetClass);
        if (mapping == null) {
            return "[" + retClass.getName() + ";";
        }
        return mapping;
    }

    public static String getMappedMethodName(ClassModel.ConstantPool.MethodReferenceEntry _methodReferenceEntry) {
        if (CacheEnabler.areCachesEnabled()) {
            return Kernel.getProperty(mappedMethodNamesCache, _methodReferenceEntry, null);
        }
        String mappedName = null;
        String name = _methodReferenceEntry.getNameAndTypeEntry().getNameUTF8Entry().getUTF8();
        for (Class<?> currentClass = _methodReferenceEntry.getOwnerClassModel().getClassWeAreModelling(); currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            for (Method kernelMethod : currentClass.getDeclaredMethods()) {
                OpenCLMapping annotation;
                String mapTo;
                if (!kernelMethod.isAnnotationPresent(OpenCLMapping.class) || !Kernel.toSignature(_methodReferenceEntry).equals(Kernel.toSignature(kernelMethod)) || (mapTo = (annotation = kernelMethod.getAnnotation(OpenCLMapping.class)).mapTo()).equals("")) continue;
                mappedName = mapTo;
            }
            if (mappedName != null) break;
        }
        return mappedName;
    }

    public static boolean isMappedMethod(ClassModel.ConstantPool.MethodReferenceEntry methodReferenceEntry) {
        if (CacheEnabler.areCachesEnabled()) {
            return Kernel.getBoolean(mappedMethodFlags, methodReferenceEntry);
        }
        boolean isMapped = false;
        for (Method kernelMethod : Kernel.class.getDeclaredMethods()) {
            if (!kernelMethod.isAnnotationPresent(OpenCLMapping.class) || !methodReferenceEntry.getNameAndTypeEntry().getNameUTF8Entry().getUTF8().equals(kernelMethod.getName())) continue;
            isMapped = true;
        }
        return isMapped;
    }

    public static boolean isOpenCLDelegateMethod(ClassModel.ConstantPool.MethodReferenceEntry methodReferenceEntry) {
        if (CacheEnabler.areCachesEnabled()) {
            return Kernel.getBoolean(openCLDelegateMethodFlags, methodReferenceEntry);
        }
        boolean isMapped = false;
        for (Method kernelMethod : Kernel.class.getDeclaredMethods()) {
            if (!kernelMethod.isAnnotationPresent(OpenCLDelegate.class) || !methodReferenceEntry.getNameAndTypeEntry().getNameUTF8Entry().getUTF8().equals(kernelMethod.getName())) continue;
            isMapped = true;
        }
        return isMapped;
    }

    public static boolean usesAtomic32(ClassModel.ConstantPool.MethodReferenceEntry methodReferenceEntry) {
        if (CacheEnabler.areCachesEnabled()) {
            return Kernel.getProperty(atomic32Cache, methodReferenceEntry, false);
        }
        for (Method kernelMethod : Kernel.class.getDeclaredMethods()) {
            if (!kernelMethod.isAnnotationPresent(OpenCLMapping.class) || !methodReferenceEntry.getNameAndTypeEntry().getNameUTF8Entry().getUTF8().equals(kernelMethod.getName())) continue;
            OpenCLMapping annotation = kernelMethod.getAnnotation(OpenCLMapping.class);
            return annotation.atomic32();
        }
        return false;
    }

    public static boolean usesAtomic64(ClassModel.ConstantPool.MethodReferenceEntry methodReferenceEntry) {
        return false;
    }

    public void setExplicit(boolean _explicit) {
        this.prepareKernelRunner().setExplicit(_explicit);
    }

    public boolean isExplicit() {
        return this.prepareKernelRunner().isExplicit();
    }

    public Kernel put(long[] array) {
        this.prepareKernelRunner().put(array);
        return this;
    }

    public Kernel put(long[][] array) {
        this.prepareKernelRunner().put(array);
        return this;
    }

    public Kernel put(long[][][] array) {
        this.prepareKernelRunner().put(array);
        return this;
    }

    public Kernel put(double[] array) {
        this.prepareKernelRunner().put(array);
        return this;
    }

    public Kernel put(double[][] array) {
        this.prepareKernelRunner().put(array);
        return this;
    }

    public Kernel put(double[][][] array) {
        this.prepareKernelRunner().put(array);
        return this;
    }

    public Kernel put(float[] array) {
        this.prepareKernelRunner().put(array);
        return this;
    }

    public Kernel put(float[][] array) {
        this.prepareKernelRunner().put(array);
        return this;
    }

    public Kernel put(float[][][] array) {
        this.prepareKernelRunner().put(array);
        return this;
    }

    public Kernel put(int[] array) {
        this.prepareKernelRunner().put(array);
        return this;
    }

    public Kernel put(int[][] array) {
        this.prepareKernelRunner().put(array);
        return this;
    }

    public Kernel put(int[][][] array) {
        this.prepareKernelRunner().put(array);
        return this;
    }

    public Kernel put(byte[] array) {
        this.prepareKernelRunner().put(array);
        return this;
    }

    public Kernel put(byte[][] array) {
        this.prepareKernelRunner().put(array);
        return this;
    }

    public Kernel put(byte[][][] array) {
        this.prepareKernelRunner().put(array);
        return this;
    }

    public Kernel put(char[] array) {
        this.prepareKernelRunner().put(array);
        return this;
    }

    public Kernel put(char[][] array) {
        this.prepareKernelRunner().put(array);
        return this;
    }

    public Kernel put(char[][][] array) {
        this.prepareKernelRunner().put(array);
        return this;
    }

    public Kernel put(boolean[] array) {
        this.prepareKernelRunner().put(array);
        return this;
    }

    public Kernel put(boolean[][] array) {
        this.prepareKernelRunner().put(array);
        return this;
    }

    public Kernel put(boolean[][][] array) {
        this.prepareKernelRunner().put(array);
        return this;
    }

    public Kernel get(long[] array) {
        this.prepareKernelRunner().get(array);
        return this;
    }

    public Kernel get(long[][] array) {
        this.prepareKernelRunner().get(array);
        return this;
    }

    public Kernel get(long[][][] array) {
        this.prepareKernelRunner().get(array);
        return this;
    }

    public Kernel get(double[] array) {
        this.prepareKernelRunner().get(array);
        return this;
    }

    public Kernel get(double[][] array) {
        this.prepareKernelRunner().get(array);
        return this;
    }

    public Kernel get(double[][][] array) {
        this.prepareKernelRunner().get(array);
        return this;
    }

    public Kernel get(float[] array) {
        this.prepareKernelRunner().get(array);
        return this;
    }

    public Kernel get(float[][] array) {
        this.prepareKernelRunner().get(array);
        return this;
    }

    public Kernel get(float[][][] array) {
        this.prepareKernelRunner().get(array);
        return this;
    }

    public Kernel get(int[] array) {
        this.prepareKernelRunner().get(array);
        return this;
    }

    public Kernel get(int[][] array) {
        this.prepareKernelRunner().get(array);
        return this;
    }

    public Kernel get(int[][][] array) {
        this.prepareKernelRunner().get(array);
        return this;
    }

    public Kernel get(byte[] array) {
        this.prepareKernelRunner().get(array);
        return this;
    }

    public Kernel get(byte[][] array) {
        this.prepareKernelRunner().get(array);
        return this;
    }

    public Kernel get(byte[][][] array) {
        this.prepareKernelRunner().get(array);
        return this;
    }

    public Kernel get(char[] array) {
        this.prepareKernelRunner().get(array);
        return this;
    }

    public Kernel get(char[][] array) {
        this.prepareKernelRunner().get(array);
        return this;
    }

    public Kernel get(char[][][] array) {
        this.prepareKernelRunner().get(array);
        return this;
    }

    public Kernel get(boolean[] array) {
        this.prepareKernelRunner().get(array);
        return this;
    }

    public Kernel get(boolean[][] array) {
        this.prepareKernelRunner().get(array);
        return this;
    }

    public Kernel get(boolean[][][] array) {
        this.prepareKernelRunner().get(array);
        return this;
    }

    public List<ProfileInfo> getProfileInfo() {
        return this.prepareKernelRunner().getProfileInfo();
    }

    @Deprecated
    public void addExecutionModes(EXECUTION_MODE ... platforms) {
        this.executionModes.addAll(Arrays.asList(platforms));
        this.currentMode = this.executionModes.iterator();
        this.executionMode = this.currentMode.next();
    }

    @Deprecated
    public boolean hasNextExecutionMode() {
        return this.currentMode.hasNext();
    }

    @Deprecated
    public void tryNextExecutionMode() {
        if (this.currentMode.hasNext()) {
            this.executionMode = this.currentMode.next();
        }
    }

    private static boolean getBoolean(ValueCache<Class<?>, Map<String, Boolean>, RuntimeException> methodNamesCache, ClassModel.ConstantPool.MethodReferenceEntry methodReferenceEntry) {
        return Kernel.getProperty(methodNamesCache, methodReferenceEntry, false);
    }

    private static <A extends Annotation> ValueCache<Class<?>, Map<String, Boolean>, RuntimeException> markedWith(final Class<A> annotationClass) {
        return Kernel.cacheProperty(new ValueCache.ValueComputer<Class<?>, Map<String, Boolean>>(){

            @Override
            public Map<String, Boolean> compute(Class<?> key) {
                HashMap<String, Boolean> markedMethodNames = new HashMap<String, Boolean>();
                for (Method method : key.getDeclaredMethods()) {
                    markedMethodNames.put(Kernel.toSignature(method), method.isAnnotationPresent(annotationClass));
                }
                return markedMethodNames;
            }
        });
    }

    static String toSignature(Method method) {
        return method.getName() + Kernel.getArgumentsLetters(method) + Kernel.getReturnTypeLetter(method);
    }

    private static String getArgumentsLetters(Method method) {
        StringBuilder sb = new StringBuilder("(");
        for (Class<?> parameterClass : method.getParameterTypes()) {
            sb.append(Kernel.toClassShortNameIfAny(parameterClass));
        }
        sb.append(")");
        return sb.toString();
    }

    private static boolean isRelevant(Method method) {
        return !method.isSynthetic() && !method.isBridge();
    }

    private static <V, T extends Throwable> V getProperty(ValueCache<Class<?>, Map<String, V>, T> cache, ClassModel.ConstantPool.MethodReferenceEntry methodReferenceEntry, V defaultValue) throws T {
        String key;
        Map<String, V> map = cache.computeIfAbsent(methodReferenceEntry.getOwnerClassModel().getClassWeAreModelling());
        if (map.containsKey(key = Kernel.toSignature(methodReferenceEntry))) {
            return map.get(key);
        }
        return defaultValue;
    }

    private static String toSignature(ClassModel.ConstantPool.MethodReferenceEntry methodReferenceEntry) {
        ClassModel.ConstantPool.NameAndTypeEntry nameAndTypeEntry = methodReferenceEntry.getNameAndTypeEntry();
        return nameAndTypeEntry.getNameUTF8Entry().getUTF8() + nameAndTypeEntry.getDescriptorUTF8Entry().getUTF8();
    }

    private static <K, V, T extends Throwable> ValueCache<Class<?>, Map<K, V>, T> cacheProperty(final ValueCache.ThrowingValueComputer<Class<?>, Map<K, V>, T> throwingValueComputer) {
        return ValueCache.on(new ValueCache.ThrowingValueComputer<Class<?>, Map<K, V>, T>(){

            @Override
            public Map<K, V> compute(Class<?> key) throws Throwable {
                HashMap properties = new HashMap();
                ArrayDeque superclasses = new ArrayDeque();
                Class<?> currentSuperClass = key;
                do {
                    superclasses.push(currentSuperClass);
                } while ((currentSuperClass = currentSuperClass.getSuperclass()) != Object.class);
                for (Class clazz : superclasses) {
                    properties.putAll((Map)throwingValueComputer.compute(clazz));
                }
                return properties;
            }
        });
    }

    public static void invalidateCaches() {
        atomic32Cache.invalidate();
        atomic64Cache.invalidate();
        mappedMethodFlags.invalidate();
        mappedMethodNamesCache.invalidate();
        openCLDelegateMethodFlags.invalidate();
    }

    static {
        typeToLetterMap.put("double", "D");
        typeToLetterMap.put("float", "F");
        typeToLetterMap.put("int", "I");
        typeToLetterMap.put("long", "J");
        typeToLetterMap.put("boolean", "Z");
        typeToLetterMap.put("byte", "B");
        typeToLetterMap.put("char", "C");
        typeToLetterMap.put("short", "S");
        typeToLetterMap.put("void", "V");
        mappedMethodFlags = Kernel.markedWith(OpenCLMapping.class);
        openCLDelegateMethodFlags = Kernel.markedWith(OpenCLDelegate.class);
        atomic32Cache = Kernel.cacheProperty(new ValueCache.ValueComputer<Class<?>, Map<String, Boolean>>(){

            @Override
            public Map<String, Boolean> compute(Class<?> key) {
                HashMap<String, Boolean> properties = new HashMap<String, Boolean>();
                for (Method method : key.getDeclaredMethods()) {
                    if (!Kernel.isRelevant(method) || !method.isAnnotationPresent(OpenCLMapping.class)) continue;
                    properties.put(Kernel.toSignature(method), method.getAnnotation(OpenCLMapping.class).atomic32());
                }
                return properties;
            }
        });
        atomic64Cache = Kernel.cacheProperty(new ValueCache.ValueComputer<Class<?>, Map<String, Boolean>>(){

            @Override
            public Map<String, Boolean> compute(Class<?> key) {
                HashMap<String, Boolean> properties = new HashMap<String, Boolean>();
                for (Method method : key.getDeclaredMethods()) {
                    if (!Kernel.isRelevant(method) || !method.isAnnotationPresent(OpenCLMapping.class)) continue;
                    properties.put(Kernel.toSignature(method), method.getAnnotation(OpenCLMapping.class).atomic64());
                }
                return properties;
            }
        });
        mappedMethodNamesCache = Kernel.cacheProperty(new ValueCache.ValueComputer<Class<?>, Map<String, String>>(){

            @Override
            public Map<String, String> compute(Class<?> key) {
                HashMap<String, String> properties = new HashMap<String, String>();
                for (Method method : key.getDeclaredMethods()) {
                    OpenCLMapping annotation;
                    String mapTo;
                    if (!Kernel.isRelevant(method) || !method.isAnnotationPresent(OpenCLMapping.class) || (mapTo = (annotation = method.getAnnotation(OpenCLMapping.class)).mapTo()) == null || mapTo.equals("")) continue;
                    properties.put(Kernel.toSignature(method), mapTo);
                }
                return properties;
            }
        });
    }

    public final class KernelState {
        private int[] globalIds = new int[]{0, 0, 0};
        private int[] localIds = new int[]{0, 0, 0};
        private int[] groupIds = new int[]{0, 0, 0};
        private Range range;
        private int passId;
        private volatile CyclicBarrier localBarrier;
        private boolean localBarrierDisabled;

        protected KernelState() {
        }

        protected KernelState(KernelState kernelState) {
            this.globalIds = kernelState.getGlobalIds();
            this.localIds = kernelState.getLocalIds();
            this.groupIds = kernelState.getGroupIds();
            this.range = kernelState.getRange();
            this.passId = kernelState.getPassId();
            this.localBarrier = kernelState.getLocalBarrier();
        }

        public int[] getGlobalIds() {
            return this.globalIds;
        }

        public void setGlobalIds(int[] globalIds) {
            this.globalIds = globalIds;
        }

        public void setGlobalId(int _index, int value) {
            this.globalIds[_index] = value;
        }

        public int[] getLocalIds() {
            return this.localIds;
        }

        public void setLocalIds(int[] localIds) {
            this.localIds = localIds;
        }

        public void setLocalId(int _index, int value) {
            this.localIds[_index] = value;
        }

        public int[] getGroupIds() {
            return this.groupIds;
        }

        public void setGroupIds(int[] groupIds) {
            this.groupIds = groupIds;
        }

        public void setGroupId(int _index, int value) {
            this.groupIds[_index] = value;
        }

        public Range getRange() {
            return this.range;
        }

        public void setRange(Range range) {
            this.range = range;
        }

        public int getPassId() {
            return this.passId;
        }

        public void setPassId(int passId) {
            this.passId = passId;
        }

        public CyclicBarrier getLocalBarrier() {
            return this.localBarrier;
        }

        public void setLocalBarrier(CyclicBarrier localBarrier) {
            this.localBarrier = localBarrier;
        }

        public void awaitOnLocalBarrier() {
            if (!this.localBarrierDisabled) {
                try {
                    Kernel.this.kernelState.getLocalBarrier().await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (BrokenBarrierException e) {
                    e.printStackTrace();
                }
            }
        }

        public void disableLocalBarrier() {
            this.localBarrierDisabled = true;
        }
    }

    @Deprecated
    public static enum EXECUTION_MODE {
        AUTO,
        NONE,
        GPU,
        CPU,
        JTP,
        SEQ,
        ACC;


        @Deprecated
        static LinkedHashSet<EXECUTION_MODE> getDefaultExecutionModes() {
            LinkedHashSet<EXECUTION_MODE> defaultExecutionModes = new LinkedHashSet<EXECUTION_MODE>();
            if (OpenCLLoader.isOpenCLAvailable()) {
                defaultExecutionModes.add(GPU);
                defaultExecutionModes.add(JTP);
            } else {
                defaultExecutionModes.add(JTP);
            }
            String executionMode = Config.executionMode;
            if (executionMode != null) {
                try {
                    LinkedHashSet<EXECUTION_MODE> requestedExecutionModes = EXECUTION_MODE.getExecutionModeFromString(executionMode);
                    logger.fine("requested execution mode =");
                    for (EXECUTION_MODE mode : requestedExecutionModes) {
                        logger.fine(" " + (Object)((Object)mode));
                    }
                    if (OpenCLLoader.isOpenCLAvailable() && EXECUTION_MODE.anyOpenCL(requestedExecutionModes) || !EXECUTION_MODE.anyOpenCL(requestedExecutionModes)) {
                        defaultExecutionModes = requestedExecutionModes;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            logger.info("default execution modes = " + defaultExecutionModes);
            for (EXECUTION_MODE e : defaultExecutionModes) {
                logger.info("SETTING DEFAULT MODE: " + e.toString());
            }
            return defaultExecutionModes;
        }

        static LinkedHashSet<EXECUTION_MODE> getExecutionModeFromString(String executionMode) {
            LinkedHashSet<EXECUTION_MODE> executionModes = new LinkedHashSet<EXECUTION_MODE>();
            for (String mode : executionMode.split(",")) {
                executionModes.add(EXECUTION_MODE.valueOf(mode.toUpperCase()));
            }
            return executionModes;
        }

        static EXECUTION_MODE getFallbackExecutionMode() {
            EXECUTION_MODE defaultFallbackExecutionMode = JTP;
            logger.info("fallback execution mode = " + (Object)((Object)defaultFallbackExecutionMode));
            return defaultFallbackExecutionMode;
        }

        static boolean anyOpenCL(LinkedHashSet<EXECUTION_MODE> _executionModes) {
            for (EXECUTION_MODE mode : _executionModes) {
                if (mode != GPU && mode != ACC && mode != CPU) continue;
                return true;
            }
            return false;
        }

        public boolean isOpenCL() {
            return this == GPU || this == ACC || this == CPU;
        }
    }

    public abstract class Entry {
        public abstract void run();

        public Kernel execute(Range _range) {
            return Kernel.this.execute("foo", _range, 1);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface OpenCLMapping {
        public String mapTo() default "";

        public boolean atomic32() default false;

        public boolean atomic64() default false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    protected static @interface OpenCLDelegate {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.FIELD})
    public static @interface NoCL {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface PrivateMemorySpace {
        public int value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Constant {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Local {
    }
}

