/*
 * Decompiled with CFR 0.152.
 */
package com.aparapi;

import com.aparapi.internal.instruction.Instruction;
import com.aparapi.internal.jni.ConfigJNI;
import com.aparapi.internal.tool.InstructionViewer;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Config
extends ConfigJNI {
    private static final String logPropName = propPkgName + ".logLevel";
    private static final Logger logger = Logger.getLogger(Config.getLoggerName());
    public static final boolean useAgent = Boolean.getBoolean(propPkgName + ".useAgent");
    public static final boolean disableUnsafe = Boolean.getBoolean(propPkgName + ".disableUnsafe");
    public static final String executionMode = System.getProperty(propPkgName + ".executionMode");
    public static final boolean enableExecutionModeReporting = Boolean.getBoolean(propPkgName + ".enableExecutionModeReporting");
    public static final boolean enableShowGeneratedOpenCL = Boolean.getBoolean(propPkgName + ".enableShowGeneratedOpenCL");
    public static final boolean dumpProfilesOnExit = Boolean.getBoolean(propPkgName + ".dumpProfilesOnExit");
    public static final boolean dumpProfileOnExecution = Boolean.getBoolean(propPkgName + ".dumpProfileOnExecution");
    public static final boolean enableAtomic32 = Boolean.getBoolean(propPkgName + ".enableAtomic32");
    public static final boolean enableAtomic64 = Boolean.getBoolean(propPkgName + ".enableAtomic64");
    public static final boolean enableByteWrites = Boolean.getBoolean(propPkgName + ".enableByteWrites");
    public static final boolean enableDoubles = Boolean.getBoolean(propPkgName + ".enableDoubles");
    public static final boolean verboseComparitor = Boolean.getBoolean(propPkgName + ".verboseComparitor");
    public static final boolean dumpFlags = Boolean.getBoolean(propPkgName + ".dumpFlags");
    public static final boolean enablePUTFIELD = Boolean.getBoolean(propPkgName + ".enable.PUTFIELD");
    public static final boolean enableARETURN = !Boolean.getBoolean(propPkgName + ".disable.ARETURN");
    public static final boolean enablePUTSTATIC = Boolean.getBoolean(propPkgName + ".enable.PUTSTATIC");
    public static final boolean enableGETSTATIC = true;
    public static final boolean enableINVOKEINTERFACE = Boolean.getBoolean(propPkgName + ".enable.INVOKEINTERFACE");
    public static final boolean enableMONITOR = Boolean.getBoolean(propPkgName + ".enable.MONITOR");
    public static final boolean enableNEW = Boolean.getBoolean(propPkgName + ".enable.NEW");
    public static final boolean enableATHROW = Boolean.getBoolean(propPkgName + ".enable.ATHROW");
    public static final boolean enableMETHODARRAYPASSING = !Boolean.getBoolean(propPkgName + ".disable.METHODARRAYPASSING");
    public static final boolean enableARRAYLENGTH = Boolean.getBoolean(propPkgName + ".enable.ARRAYLENGTH");
    public static final boolean enableSWITCH = Boolean.getBoolean(propPkgName + ".enable.SWITCH");
    public static boolean enableShowFakeLocalVariableTable = Boolean.getBoolean(propPkgName + ".enableShowFakeLocalVariableTable");
    public static final boolean enableInstructionDecodeViewer = Boolean.getBoolean(propPkgName + ".enableInstructionDecodeViewer");
    public static String instructionListenerClassName = System.getProperty(propPkgName + ".instructionListenerClass");
    public static InstructionListener instructionListener = null;

    public static String getLoggerName() {
        return logPropName;
    }

    static {
        try {
            Handler[] handlers;
            Level level = Level.parse(System.getProperty(Config.getLoggerName(), "WARNING"));
            for (Handler handler : handlers = Logger.getLogger("").getHandlers()) {
                handler.setLevel(level);
            }
            logger.setLevel(level);
        }
        catch (Exception e) {
            System.out.println("Exception " + e + " in Aparapi logging setup");
            e.printStackTrace();
        }
        if (enableInstructionDecodeViewer && (instructionListenerClassName == null || instructionListenerClassName.equals(""))) {
            instructionListenerClassName = InstructionViewer.class.getName();
        }
        if (instructionListenerClassName != null && !instructionListenerClassName.equals("")) {
            try {
                Class<?> instructionListenerClass = Class.forName(instructionListenerClassName);
                instructionListener = (InstructionListener)instructionListenerClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (dumpFlags) {
            System.out.println(propPkgName + ".executionMode{GPU|ACC|CPU|JTP|SEQ}=" + executionMode);
            System.out.println(propPkgName + ".logLevel{OFF|FINEST|FINER|FINE|WARNING|SEVERE|ALL}=" + logger.getLevel());
            System.out.println(propPkgName + ".enableProfiling{true|false}=" + enableProfiling);
            System.out.println(propPkgName + ".enableProfilingCSV{true|false}=" + enableProfilingCSV);
            System.out.println(propPkgName + ".enableVerboseJNI{true|false}=" + enableVerboseJNI);
            System.out.println(propPkgName + ".enableVerboseJNIOpenCLResourceTracking{true|false}=" + enableVerboseJNIOpenCLResourceTracking);
            System.out.println(propPkgName + ".enableShowGeneratedOpenCL{true|false}=" + enableShowGeneratedOpenCL);
            System.out.println(propPkgName + ".enableExecutionModeReporting{true|false}=" + enableExecutionModeReporting);
            System.out.println(propPkgName + ".enableInstructionDecodeViewer{true|false}=" + enableInstructionDecodeViewer);
            System.out.println(propPkgName + ".instructionListenerClassName{<class name which extends com.codegen.Config.InstructionListener>}=" + instructionListenerClassName);
        }
    }

    public static interface InstructionListener {
        public void showAndTell(String var1, Instruction var2, Instruction var3);
    }
}

