/*
 * Decompiled with CFR 0.152.
 */
package WavFile;

import WavFile.WavFile;
import java.io.File;

public class WriteExample {
    public static void main(String[] args) {
        try {
            int sampleRate = 44100;
            double duration = 5.0;
            long numFrames = (long)(duration * (double)sampleRate);
            WavFile wavFile = WavFile.newWavFile(new File(args[0]), 2, numFrames, 16, sampleRate);
            double[][] buffer = new double[2][100];
            long frameCounter = 0L;
            while (frameCounter < numFrames) {
                long remaining = wavFile.getFramesRemaining();
                int toWrite = remaining > 100L ? 100 : (int)remaining;
                int s = 0;
                while (s < toWrite) {
                    buffer[0][s] = Math.sin(2513.2741228718346 * (double)frameCounter / (double)sampleRate);
                    buffer[1][s] = Math.sin(3141.592653589793 * (double)frameCounter / (double)sampleRate);
                    ++s;
                    ++frameCounter;
                }
                wavFile.writeFrames(buffer, toWrite);
            }
            wavFile.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

