; freeram.. check if any of these are used or not, and change them if they are!
!name_length = $60  ; 1 byte
!number_of_tiles = $61  ; 1 byte

!name_pointer = $62  ; 2 bytes

; it doesn't matter when any of these are cleared

!text_props = $30  ; YXPPCCCT properties of the text being drawn
; keep the priority bits at max!!!

; edit "section_names.asm" to configure which levels display what text
; edit "section_name_characters.txt" to configure what character represents what tile

init:
	REP #$30

	; take level number multiply by 2 because the pointers are two bytes
	; put it into x
	LDA $010B|!addr
	ASL : TAX
	
	; use that to load the name pointer from the table
	; store to scratch and for later
	LDA names,x
	STA !name_pointer
	STA $00
	
	SEP #$20
	
	; loop until we hit sentinel 0xFF which marks the end of the name
	; keep track of non-space characters in the process
	STZ !number_of_tiles
	
	LDY #$0000
	.check_size_loop
	LDA ($00),y
	CMP #$FF
	BEQ .done
	
	CMP #$00
	BEQ .space
	INC !number_of_tiles
	.space
	
	INY
	BRA .check_size_loop
	.done
	SEP #$10

	STY !name_length  ; y at this point is how many characters the name is

; RTL  ; uncomment this if you don't want the name to appear during fade in

main:
	LDY !number_of_tiles
	BEQ .return  ; if the name is blank, why do anything?

	REP #$30
	LDA #$0000  ; priority
	; number of tiles already in y
	JSL $0084B0
	BCS .success
	SEP #$30 : RTL
	.success

	; prepare some scratch addresses for later
	LDA !name_pointer
	STA $00
	
	LDA !name_length
	AND #$00FF
	STA $02
	
	; LDA #$0000  ; reset high of accum. because of accum. to index reg transfers
	; however this is already done by the operation above
	SEP #$20

	LDA #$04
	STA $04  ; starting x position

	LDX $3100
	LDY #$0000
.name_draw_loop_main
	
	LDA ($00),y
	BEQ .space  ; move on if it's a space
	STA $400002,x  ; tile
	
	LDA $04
	STA $400000,x  ; x
	
	LDA #$D4
	STA $400001,x  ; y
	
	LDA #!text_props
	STA $400003,x  ; props
	
	INX #4
	.space
	LDA $04
	CLC : ADC #$07
	STA $04  ; move along
	
	INY : CPY $02 : BNE .name_draw_loop_main
	
	; set extra bits
	LDX $3102
	LDA !number_of_tiles
	TAY : DEY  ; loop count = number of tiles -1
	LDA #$00
.name_draw_loop_extra
	STA $400000,x
	INX
	DEY : BPL .name_draw_loop_extra
	
	SEP #$10
	.return
RTL

incsrc section_names.asm