; ###########################################################
; #                                                         #
; #  OW Speed Changer by WhiteYoshiEgg, ASMagician Maks     #
; #  Based on original code by carol                        #
; #                                                         #
; ###########################################################

	; ###############
	; # DEFINITIONS #
	; ###############

	!Speed		= $01		;    $01 = keep the original speed
					;    $02 = twice the original speed
					;    $03 = three times the original speed
					;    [...]
					;    $80 = 128 times the original speed
					;    $00 = stay in place, unless fractional speed is set

	!UpperFraction	= $01		;    $01 and $02 = add a 1/2 to the speed multiplier
	!LowerFraction	= $04		;    $01 and $04 = add a 1/4 to the speed multiplier
					;    $03 and $04 = add a 3/4 to the speed multiplier
					;    $05 and $08 = add a 5/8 to the speed multiplier
					;    [...]
					;    $00 and $00 = do not add to the speed multiplier


	!YoshiSpeed	= $02		;    Speed  to  use   while  riding  on  Yoshi
					;    (same rules as above).
	!YoshiUpFrac	= $00
	!YoshiLowFrac	= $00


	!RunSpeed	= $01		;    Speed to use while holding the run input
					;    (same rules as above).
	!RunUpFrac	= $01
	!RunLowFrac	= $02


	!YoshiRunSpeed	= $00		;    Speed to use while holding the run input on Yoshi
					;    (same rules as above).
	!YoshiRunUpFrac	= $03
	!YoshiRunLoFrac	= $04


					;Which buttons have to be held to run
	!RunInput	= %00000000	;BYsSUDLR
	!RunInput2	= %00100000	;AXLR----


!sa1	= 0
!addr	= $0000
!bank	= $800000

if read1($00FFD5) == $23
	sa1rom
	!sa1	= 1
	!addr	= $6000
	!bank	= $000000
endif

	; ############
	; # THE CODE #
	; ############

org $04945D				;    Hijack overworld process 04
	autoclean JML ApplySpeed
	NOP

org $0497FE
	JMP $9468

freecode
reset bytes
print " Inserted at $",pc

Speed:
db !Speed-1,!RunSpeed-1,!YoshiSpeed-1,!YoshiRunSpeed-1
UpperFraction:
db !UpperFraction,!RunUpFrac,!YoshiUpFrac,!YoshiRunUpFrac
LowerFraction:
db !LowerFraction-1,!RunLowFrac-1,!YoshiLowFrac-1,!YoshiRunLoFrac-1

ApplySpeed:
	LDA $0DD8|!addr
	BEQ +
	JML $049462|!bank
+
	LDX #$00
	LDA $15
	AND #!RunInput
	CMP #!RunInput
	BNE +
	LDA $17
	AND #!RunInput2
	CMP #!RunInput2
	BNE +
	INX
+
	LDA $0DD6|!addr
	LSR #2
	TAY
	LDA $0DBA|!addr,y
	BEQ .noYoshi
	INX #2
.noYoshi
	LDA.l Speed,x
	TAY
	LDA $14
	AND.l LowerFraction,x
	CMP.l UpperFraction,x
	BCS .loop
	INY
.loop	
	DEY
	BMI .return
	PHY
	PHK
	PEA.w (+)-1
	PEA.w $048575-1
	JML $049468|!bank		;Run overworld movement code as many times as the defined speed
+
	PLY
	LDA $13D9|!addr			;End execution if the player has reached a stopping tile or an exit
	CMP #$04
	BEQ .loop
-
	JML $049467|!bank
.return
	INY
	BMI -
	JML $049468|!bank		;Do 1 last movement iteration
